package com.ejianc.business.salary.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMSalaryPayApplyDetailVO;
import com.ejianc.business.financeintegration.PMSalary.vo.PMGzDetailVO;
import com.ejianc.business.profinance.vo.SalaryPayApplyDetailVO;
import com.ejianc.business.salary.bean.PushcwEntity;
import com.ejianc.business.salary.dto.PayrollActualMnyDTO;
import com.ejianc.business.salary.service.IPushcwService;
import com.ejianc.business.salary.vo.PushcwVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.salary.mapper.PayrollMapper;
import com.ejianc.business.salary.bean.PayrollEntity;
import com.ejianc.business.salary.service.IPayrollService;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 工资单-主实体
 * 
 * @author generator
 * 
 */
@Service("payrollService")
public class PayrollServiceImpl extends BaseServiceImpl<PayrollMapper, PayrollEntity> implements IPayrollService{

    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPushcwService pushcwService;

    @Override
    public List<PushcwEntity> getActualMny(Date month, Long companyId) {
        return baseMapper.getActualMny(month,companyId);
    }

    @Override
    public List<PushcwEntity> getAcActualMny(Date month, Long companyId) {
        return baseMapper.getAcActualMny(month,companyId);
    }

    @Override
    public List<PushcwEntity> getIdCardActualMny(Date month, Long companyId) {
        return baseMapper.getIdCardActualMny(month,companyId);
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void handMQMessage(String salaryPayApplyResultMsg) {
        /*
            处理中间库定时任务推送的工资支付数据
            1.修改cwPush表中的明细实付数据
            2.修改payroll-detail表中的实付，已付，剩余可付金额
            2.修改payroll表中的实付，已付，剩余可付金额
         */
        logger.info("profinance处理中间库工资支付-修改支付状态申请定时任务---SalaryPayApplyServiceImpl--handMQMessage--begin！");
        logger.info("从消息队列中获取到待处理的工资支付申请付款结果：{}", salaryPayApplyResultMsg);
        if (StringUtils.isNotBlank(salaryPayApplyResultMsg)){
            List<PMGzDetailVO> resultList = JSONObject.parseArray(salaryPayApplyResultMsg, PMGzDetailVO.class);
            logger.info("接收一建财务系统的工资支付付款结果：{}", JSONObject.toJSONString(resultList));

            if (CollectionUtils.isNotEmpty(resultList)){
                List<String> companyIdAndMonthList = new ArrayList<>();
                for (PMGzDetailVO pmGzDetailVO : resultList) {
                    QueryParam param = new QueryParam();
                    param.getParams().put("code", new Parameter(QueryParam.EQ, pmGzDetailVO.getPmBillId()));
                    param.getParams().put("id_card", new Parameter(QueryParam.EQ, pmGzDetailVO.getIdCard()));
                    List<PushcwEntity> pushcwEntityList = pushcwService.queryList(param);

                    if (CollectionUtil.isNotEmpty(pushcwEntityList)){
                        if ("2".equals(pmGzDetailVO.getState())){
                            //已支付
                            pushcwEntityList.get(0).setAlreadyMny(pmGzDetailVO.getActualMny());
                        }else {
                            pushcwEntityList.get(0).setAlreadyMny(BigDecimal.ZERO);
                        }
                        pushcwService.updateById(pushcwEntityList.get(0));

                        companyIdAndMonthList.add(pmGzDetailVO.getPmBillId().substring(0,pmGzDetailVO.getPmBillId().lastIndexOf("-")));
                    }

                }
                List<String> collect = companyIdAndMonthList.stream().distinct().collect(Collectors.toList());

                if (CollectionUtils.isNotEmpty(collect)){
                    for (String s : collect) {
                        updateActualMnyDetail(s);//先更新子表的实付金额
                        updateActualMny(s);//在更新主表的实付金额
                    }
                }
            }
        }
        logger.info("profinance处理中间库工资支付-修改支付状态定时任务---SalaryPayApplyServiceImpl--handMQMessage--end！");
    }

    @Override
    public void updateActualMnyDetail(String companyIdAndMonth) {
        baseMapper.updateActualMnyDetail(companyIdAndMonth+"%");
    }

    @Override
    public void updateActualMny(String companyIdAndMonth) {
        baseMapper.updateActualMny(companyIdAndMonth);
    }

}
