/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.salary.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.salary.bean.AcSetRelateEntity;
import com.ejianc.business.salary.bean.JspayableAdjustEntity;
import com.ejianc.business.salary.bean.JspayableDetailEntity;
import com.ejianc.business.salary.bean.JspayableEntity;
import com.ejianc.business.salary.bean.JspayableSourceEntity;
import com.ejianc.business.salary.bean.PayableDetailEntity;
import com.ejianc.business.salary.mapper.JspayableAdjustMapper;
import com.ejianc.business.salary.service.IAcSetRelateService;
import com.ejianc.business.salary.service.IJspayableAdjustService;
import com.ejianc.business.salary.service.IJspayableDetailService;
import com.ejianc.business.salary.service.IJspayableService;
import com.ejianc.business.salary.service.IJspayableSourceService;
import com.ejianc.business.salary.service.IPayableDetailService;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="jspayableAdjustService")
public class JspayableAdjustServiceImpl
extends BaseServiceImpl<JspayableAdjustMapper, JspayableAdjustEntity>
implements IJspayableAdjustService {
    @Autowired
    private IJspayableService jspayableService;
    @Autowired
    private IJspayableSourceService sourceService;
    @Autowired
    private IPayableDetailService payableDetailService;
    @Autowired
    private IJspayableDetailService jspayableDetailService;
    @Autowired
    private IAcSetRelateService acSetRelateService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void insuranceAdjustApportion(Long jspayableId) {
        JspayableEntity jspayableEntity = (JspayableEntity)((Object)this.jspayableService.selectById(jspayableId));
        List<JspayableDetailEntity> detailList = jspayableEntity.getJspayableDetailList();
        List jsDetailIdCardList = detailList.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getSourceType()) && "1".equals(e.getSourceType())).map(JspayableDetailEntity::getIdCard).collect(Collectors.toList());
        super.remove((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"id_card", jsDetailIdCardList)).eq((Object)"period", (Object)jspayableEntity.getMonth())).eq((Object)"company_id", (Object)jspayableEntity.getCompanyId()));
        List idCardList = detailList.stream().map(JspayableDetailEntity::getIdCard).collect(Collectors.toList());
        List sourceList = this.sourceService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"id_card", idCardList)).eq((Object)"period", (Object)jspayableEntity.getMonth())).eq((Object)"company_id", (Object)jspayableEntity.getCompanyId()));
        List sourceDetailId = sourceList.stream().map(JspayableSourceEntity::getSourceDetailId).collect(Collectors.toList());
        List payableDetailList = this.payableDetailService.list((Wrapper)new QueryWrapper().in((Object)"id", sourceDetailId));
        ArrayList acOrgIdList = new ArrayList();
        List collect = payableDetailList.stream().map(PayableDetailEntity::getSbcdOrgId).distinct().collect(Collectors.toList());
        List collect1 = payableDetailList.stream().map(PayableDetailEntity::getGzffOrgId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect)) {
            acOrgIdList.addAll(collect);
        }
        if (CollectionUtils.isNotEmpty(collect1)) {
            acOrgIdList.addAll(collect1);
        }
        List acSetList = this.acSetRelateService.list((Wrapper)new QueryWrapper().in((Object)"org_id", acOrgIdList));
        Map acSetMap = acSetList.stream().collect(Collectors.toMap(p -> p.getOrgId(), Function.identity()));
        Map<String, List<JspayableSourceEntity>> sourceMap = sourceList.stream().collect(Collectors.groupingBy(JspayableSourceEntity::getIdCard));
        Map<String, List<PayableDetailEntity>> payableDetailMap = payableDetailList.stream().collect(Collectors.groupingBy(PayableDetailEntity::getIdCard));
        ArrayList allAdjustEntityList = new ArrayList();
        for (JspayableDetailEntity jspayableDetailEntity : detailList) {
            String sbcdOrgName = "";
            List<PayableDetailEntity> payableDetailEntityList = payableDetailMap.get(jspayableDetailEntity.getIdCard());
            if (CollectionUtils.isNotEmpty(payableDetailEntityList)) {
                ArrayList<JspayableAdjustEntity> adjustEntityList = new ArrayList<JspayableAdjustEntity>();
                BigDecimal totalYfSalaryMny = payableDetailEntityList.stream().filter(p -> p.getYfSalaryMny() != null).map(PayableDetailEntity::getYfSalaryMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                int count = 0;
                for (PayableDetailEntity entity : payableDetailEntityList) {
                    JspayableAdjustEntity jspayableAdjustEntity = new JspayableAdjustEntity();
                    jspayableAdjustEntity.setId(IdWorker.getId());
                    jspayableAdjustEntity.setJspayableDetailId(jspayableDetailEntity.getId());
                    jspayableAdjustEntity.setSbcdOrgId(entity.getGzffOrgId());
                    jspayableAdjustEntity.setSbcdOrgCode(entity.getGzffOrgCode());
                    jspayableAdjustEntity.setSbcdOrgName(entity.getGzffOrgName());
                    jspayableAdjustEntity.setIdCard(entity.getIdCard());
                    jspayableAdjustEntity.setPeriod(sourceMap.get(jspayableDetailEntity.getIdCard()).get(0).getPeriod());
                    jspayableAdjustEntity.setCompanyId(jspayableEntity.getCompanyId());
                    jspayableAdjustEntity.setCompanyName(jspayableEntity.getCompanyName());
                    if (entity.getSbcdOrgId() != null) {
                        jspayableAdjustEntity.setAcSet(acSetMap.containsKey(entity.getSbcdOrgId()) ? ((AcSetRelateEntity)((Object)acSetMap.get(entity.getSbcdOrgId()))).getAcSet() : null);
                        jspayableAdjustEntity.setAcSetCode(acSetMap.containsKey(entity.getSbcdOrgId()) ? ((AcSetRelateEntity)((Object)acSetMap.get(entity.getSbcdOrgId()))).getAcSetCode() : null);
                        jspayableAdjustEntity.setIsDefault(entity.getSbcdOrgId().toString().equals(jspayableDetailEntity.getDetailOrgId().toString()) ? "1" : "2");
                    } else {
                        jspayableAdjustEntity.setAcSet(acSetMap.containsKey(entity.getGzffOrgId()) ? ((AcSetRelateEntity)((Object)acSetMap.get(entity.getGzffOrgId()))).getAcSet() : null);
                        jspayableAdjustEntity.setAcSetCode(acSetMap.containsKey(entity.getGzffOrgId()) ? ((AcSetRelateEntity)((Object)acSetMap.get(entity.getGzffOrgId()))).getAcSetCode() : null);
                        jspayableAdjustEntity.setIsDefault(entity.getGzffOrgId().toString().equals(jspayableDetailEntity.getDetailOrgId().toString()) ? "1" : "2");
                    }
                    BigDecimal scale = ComputeUtil.safeDiv((BigDecimal)entity.getYfSalaryMny(), (BigDecimal[])new BigDecimal[]{totalYfSalaryMny, new BigDecimal(100)});
                    jspayableAdjustEntity.setScale(scale);
                    sbcdOrgName = sbcdOrgName + entity.getGzffOrgName();
                    if (payableDetailEntityList.size() == 1 || payableDetailEntityList.size() != ++count) {
                        if (payableDetailEntityList.size() != 1) {
                            sbcdOrgName = sbcdOrgName + "\uff0c";
                        }
                        jspayableAdjustEntity.setPersonEndowmentMny(ComputeUtil.safeMultiply((BigDecimal)jspayableDetailEntity.getPersonEndowmentMny(), (BigDecimal[])new BigDecimal[]{scale, new BigDecimal(100)}).setScale(2, 4));
                        jspayableAdjustEntity.setPersonMedicalMny(ComputeUtil.safeMultiply((BigDecimal)jspayableDetailEntity.getPersonMedicalMny(), (BigDecimal[])new BigDecimal[]{scale, new BigDecimal(100)}).setScale(2, 4));
                        jspayableAdjustEntity.setPersonUnemploymentMny(ComputeUtil.safeMultiply((BigDecimal)jspayableDetailEntity.getPersonUnemploymentMny(), (BigDecimal[])new BigDecimal[]{scale, new BigDecimal(100)}).setScale(2, 4));
                        jspayableAdjustEntity.setPersonHouseMny(ComputeUtil.safeMultiply((BigDecimal)jspayableDetailEntity.getPersonHouseMny(), (BigDecimal[])new BigDecimal[]{scale, new BigDecimal(100)}).setScale(2, 4));
                        jspayableAdjustEntity.setCompanyEndowmentMny(ComputeUtil.safeMultiply((BigDecimal)jspayableDetailEntity.getCompanyEndowmentMny(), (BigDecimal[])new BigDecimal[]{scale, new BigDecimal(100)}).setScale(2, 4));
                        jspayableAdjustEntity.setCompanyMedicalMny(ComputeUtil.safeMultiply((BigDecimal)jspayableDetailEntity.getCompanyMedicalMny(), (BigDecimal[])new BigDecimal[]{scale, new BigDecimal(100)}).setScale(2, 4));
                        jspayableAdjustEntity.setCompanyUnemploymentMny(ComputeUtil.safeMultiply((BigDecimal)jspayableDetailEntity.getCompanyUnemploymentMny(), (BigDecimal[])new BigDecimal[]{scale, new BigDecimal(100)}).setScale(2, 4));
                        jspayableAdjustEntity.setCompanyBirthMny(ComputeUtil.safeMultiply((BigDecimal)jspayableDetailEntity.getCompanyBirthMny(), (BigDecimal[])new BigDecimal[]{scale, new BigDecimal(100)}).setScale(2, 4));
                        jspayableAdjustEntity.setCompanyInjureMny(ComputeUtil.safeMultiply((BigDecimal)jspayableDetailEntity.getCompanyInjureMny(), (BigDecimal[])new BigDecimal[]{scale, new BigDecimal(100)}).setScale(2, 4));
                        jspayableAdjustEntity.setCompanyHouseMny(ComputeUtil.safeMultiply((BigDecimal)jspayableDetailEntity.getCompanyHouseMny(), (BigDecimal[])new BigDecimal[]{scale, new BigDecimal(100)}).setScale(2, 4));
                    } else {
                        jspayableAdjustEntity.setPersonEndowmentMny(ComputeUtil.safeSub((BigDecimal)jspayableDetailEntity.getPersonEndowmentMny(), (BigDecimal)adjustEntityList.stream().filter(p -> p.getPersonEndowmentMny() != null).map(JspayableAdjustEntity::getPersonEndowmentMny).reduce(BigDecimal.ZERO, BigDecimal::add)));
                        jspayableAdjustEntity.setPersonMedicalMny(ComputeUtil.safeSub((BigDecimal)jspayableDetailEntity.getPersonMedicalMny(), (BigDecimal)adjustEntityList.stream().filter(p -> p.getPersonMedicalMny() != null).map(JspayableAdjustEntity::getPersonMedicalMny).reduce(BigDecimal.ZERO, BigDecimal::add)));
                        jspayableAdjustEntity.setPersonUnemploymentMny(ComputeUtil.safeSub((BigDecimal)jspayableDetailEntity.getPersonUnemploymentMny(), (BigDecimal)adjustEntityList.stream().filter(p -> p.getPersonUnemploymentMny() != null).map(JspayableAdjustEntity::getPersonUnemploymentMny).reduce(BigDecimal.ZERO, BigDecimal::add)));
                        jspayableAdjustEntity.setPersonHouseMny(ComputeUtil.safeSub((BigDecimal)jspayableDetailEntity.getPersonHouseMny(), (BigDecimal)adjustEntityList.stream().filter(p -> p.getPersonHouseMny() != null).map(JspayableAdjustEntity::getPersonHouseMny).reduce(BigDecimal.ZERO, BigDecimal::add)));
                        jspayableAdjustEntity.setCompanyEndowmentMny(ComputeUtil.safeSub((BigDecimal)jspayableDetailEntity.getCompanyEndowmentMny(), (BigDecimal)adjustEntityList.stream().filter(p -> p.getCompanyEndowmentMny() != null).map(JspayableAdjustEntity::getCompanyEndowmentMny).reduce(BigDecimal.ZERO, BigDecimal::add)));
                        jspayableAdjustEntity.setCompanyMedicalMny(ComputeUtil.safeSub((BigDecimal)jspayableDetailEntity.getCompanyMedicalMny(), (BigDecimal)adjustEntityList.stream().filter(p -> p.getCompanyMedicalMny() != null).map(JspayableAdjustEntity::getCompanyMedicalMny).reduce(BigDecimal.ZERO, BigDecimal::add)));
                        jspayableAdjustEntity.setCompanyUnemploymentMny(ComputeUtil.safeSub((BigDecimal)jspayableDetailEntity.getCompanyUnemploymentMny(), (BigDecimal)adjustEntityList.stream().filter(p -> p.getCompanyUnemploymentMny() != null).map(JspayableAdjustEntity::getCompanyUnemploymentMny).reduce(BigDecimal.ZERO, BigDecimal::add)));
                        jspayableAdjustEntity.setCompanyBirthMny(ComputeUtil.safeSub((BigDecimal)jspayableDetailEntity.getCompanyBirthMny(), (BigDecimal)adjustEntityList.stream().filter(p -> p.getCompanyBirthMny() != null).map(JspayableAdjustEntity::getCompanyBirthMny).reduce(BigDecimal.ZERO, BigDecimal::add)));
                        jspayableAdjustEntity.setCompanyInjureMny(ComputeUtil.safeSub((BigDecimal)jspayableDetailEntity.getCompanyInjureMny(), (BigDecimal)adjustEntityList.stream().filter(p -> p.getCompanyInjureMny() != null).map(JspayableAdjustEntity::getCompanyInjureMny).reduce(BigDecimal.ZERO, BigDecimal::add)));
                        jspayableAdjustEntity.setCompanyHouseMny(ComputeUtil.safeSub((BigDecimal)jspayableDetailEntity.getCompanyHouseMny(), (BigDecimal)adjustEntityList.stream().filter(p -> p.getCompanyHouseMny() != null).map(JspayableAdjustEntity::getCompanyHouseMny).reduce(BigDecimal.ZERO, BigDecimal::add)));
                    }
                    adjustEntityList.add(jspayableAdjustEntity);
                }
                allAdjustEntityList.addAll(adjustEntityList);
            }
            jspayableDetailEntity.setSbcdOrgName(sbcdOrgName);
        }
        super.saveOrUpdateBatch(allAdjustEntityList, allAdjustEntityList.size());
        this.jspayableDetailService.saveOrUpdateBatch(detailList, detailList.size());
    }

    public static void main(String[] args) {
        BigDecimal scale = ComputeUtil.safeDiv((BigDecimal)new BigDecimal(0.0), (BigDecimal[])new BigDecimal[]{new BigDecimal(0.05), new BigDecimal(100)});
    }
}

