/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.salary.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.salary.bean.JspayableAdjustEntity;
import com.ejianc.business.salary.service.IJspayableAdjustService;
import com.ejianc.business.salary.vo.JsAdjustVO;
import com.ejianc.business.salary.vo.JspayableAdjustVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"jspayableAdjust"})
public class JspayableAdjustController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IJspayableAdjustService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JsAdjustVO> saveOrUpdate(@RequestBody JsAdjustVO saveOrUpdateVO) {
        List jspayableAdjustVOS = saveOrUpdateVO.getJspayableAdjustList();
        if (!CollectionUtils.isNotEmpty((Collection)jspayableAdjustVOS)) {
            throw new BusinessException("\u5b50\u8868\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        jspayableAdjustVOS.forEach(e -> {
            e.setCompanyId(((JspayableAdjustVO)jspayableAdjustVOS.get(0)).getCompanyId());
            e.setCompanyName(((JspayableAdjustVO)jspayableAdjustVOS.get(0)).getCompanyName());
            this.service.saveOrUpdate(BeanMapper.map((Object)e, JspayableAdjustEntity.class), false);
        });
        String idCard = ((JspayableAdjustVO)jspayableAdjustVOS.get(0)).getIdCard();
        Date period = ((JspayableAdjustVO)jspayableAdjustVOS.get(0)).getPeriod();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM");
        String dateString = formatter.format(period);
        return this.queryDetail(idCard, dateString, ((JspayableAdjustVO)jspayableAdjustVOS.get(0)).getCompanyId());
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JsAdjustVO> queryDetail(String idCard, String period, Long companyId) {
        Date month = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM");
        try {
            month = dateFormat.parse(period);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        JsAdjustVO resVO = new JsAdjustVO();
        LambdaQueryWrapper lambdaQueryWrapper2 = new LambdaQueryWrapper();
        lambdaQueryWrapper2.eq(JspayableAdjustEntity::getPeriod, (Object)month);
        lambdaQueryWrapper2.eq(JspayableAdjustEntity::getIdCard, (Object)idCard);
        lambdaQueryWrapper2.eq(JspayableAdjustEntity::getCompanyId, (Object)companyId);
        List list = this.service.list((Wrapper)lambdaQueryWrapper2);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            resVO.setJspayableAdjustList(BeanMapper.mapList((Iterable)list, JspayableAdjustVO.class));
            BigDecimal personEndowmentMny = BigDecimal.ZERO;
            BigDecimal personMedicalMny = BigDecimal.ZERO;
            BigDecimal personUnemploymentMny = BigDecimal.ZERO;
            BigDecimal personHouseMny = BigDecimal.ZERO;
            BigDecimal companyEndowmentMny = BigDecimal.ZERO;
            BigDecimal companyMedicalMny = BigDecimal.ZERO;
            BigDecimal companyUnemploymentMny = BigDecimal.ZERO;
            BigDecimal companyBirthMny = BigDecimal.ZERO;
            BigDecimal companyInjureMny = BigDecimal.ZERO;
            BigDecimal companyHouseMny = BigDecimal.ZERO;
            BigDecimal criticalIllnessMny = BigDecimal.ZERO;
            for (JspayableAdjustEntity e : list) {
                personEndowmentMny = ComputeUtil.safeAdd((BigDecimal)personEndowmentMny, (BigDecimal)e.getPersonEndowmentMny());
                personMedicalMny = ComputeUtil.safeAdd((BigDecimal)personMedicalMny, (BigDecimal)e.getPersonMedicalMny());
                personUnemploymentMny = ComputeUtil.safeAdd((BigDecimal)personUnemploymentMny, (BigDecimal)e.getPersonUnemploymentMny());
                personHouseMny = ComputeUtil.safeAdd((BigDecimal)personHouseMny, (BigDecimal)e.getPersonHouseMny());
                companyEndowmentMny = ComputeUtil.safeAdd((BigDecimal)companyEndowmentMny, (BigDecimal)e.getCompanyEndowmentMny());
                companyMedicalMny = ComputeUtil.safeAdd((BigDecimal)companyMedicalMny, (BigDecimal)e.getCompanyMedicalMny());
                companyUnemploymentMny = ComputeUtil.safeAdd((BigDecimal)companyUnemploymentMny, (BigDecimal)e.getCompanyUnemploymentMny());
                companyBirthMny = ComputeUtil.safeAdd((BigDecimal)companyBirthMny, (BigDecimal)e.getCompanyBirthMny());
                companyInjureMny = ComputeUtil.safeAdd((BigDecimal)companyInjureMny, (BigDecimal)e.getCompanyInjureMny());
                companyHouseMny = ComputeUtil.safeAdd((BigDecimal)companyHouseMny, (BigDecimal)e.getCompanyHouseMny());
                criticalIllnessMny = ComputeUtil.safeAdd((BigDecimal)criticalIllnessMny, (BigDecimal)e.getCriticalIllnessMny());
            }
            resVO.setPersonEndowmentMny(personEndowmentMny);
            resVO.setPersonMedicalMny(personMedicalMny);
            resVO.setPersonUnemploymentMny(personUnemploymentMny);
            resVO.setPersonHouseMny(personHouseMny);
            resVO.setCompanyEndowmentMny(companyEndowmentMny);
            resVO.setCompanyMedicalMny(companyMedicalMny);
            resVO.setCompanyUnemploymentMny(companyUnemploymentMny);
            resVO.setCompanyBirthMny(companyBirthMny);
            resVO.setCompanyInjureMny(companyInjureMny);
            resVO.setCompanyHouseMny(companyHouseMny);
            resVO.setCriticalIllnessMny(criticalIllnessMny);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)resVO);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<JspayableAdjustVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (JspayableAdjustVO jspayableAdjustVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<JspayableAdjustVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), JspayableAdjustVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("JspayableAdjust-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refJspayableAdjustData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<JspayableAdjustVO>> refJspayableAdjustData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), JspayableAdjustVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/insuranceAdjustApportion"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> insuranceAdjustApportion(Long jspayableId) {
        this.service.insuranceAdjustApportion(jspayableId);
        return CommonResponse.success((String)"\u793e\u4fdd\u516c\u79ef\u91d1\u5206\u644a\u6210\u529f\uff01");
    }
}

