package com.ejianc.business.salary.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.financeintegration.PMSalary.api.IPMSalarySystemApi;
import com.ejianc.business.financeintegration.PMSalary.vo.PMGzDetailVO;
import com.ejianc.business.financeintegration.PMSalary.vo.PMGzVO;
import com.ejianc.business.financeintegration.PMSalary.vo.PMSbgjjgsVO;
import com.ejianc.business.salary.bean.*;
import com.ejianc.business.salary.service.IPayrollService;
import com.ejianc.business.salary.service.IPushcwService;
import com.ejianc.business.salary.service.IResendService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

@Service("resend") 
public class ResendBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IBillTypeApi billTypeApi;
	@Autowired
	private IResendService resendService;
	@Autowired
	private IPushcwService pushcwService;

	@Autowired
	private IPMSalarySystemApi salarySystemApi;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		ResendEntity resendEntity = resendService.selectById(billId);
		List<PushcwEntity> actualMny = resendService.changeToPushcw(resendEntity.getResendDetailList());
		if (CollectionUtils.isNotEmpty(actualMny)){
			BigDecimal actualSum = BigDecimal.ZERO;
			//校验字段为空
			for (PushcwEntity pushcwEntity : actualMny) {

				if (StringUtils.isBlank(pushcwEntity.getBankName())  || StringUtils.isBlank(pushcwEntity.getBankAccount())){
					return CommonResponse.error("银行信息为空！人员名称："+pushcwEntity.getDetailEmployeeName());
				}
				if (pushcwEntity.getActual().compareTo(BigDecimal.ZERO) < 0){
					return CommonResponse.error("实发小于0！人员名称："+pushcwEntity.getDetailEmployeeName());
				}

				pushcwEntity.setMonth(resendEntity.getMonth());
				pushcwEntity.setJspayableDetailId(pushcwEntity.getId());
				pushcwEntity.setSourceId(resendEntity.getId());

				pushcwEntity.setAcSet(resendEntity.getAcSet());
				pushcwEntity.setAcSetCode(resendEntity.getAcSetCode());

				pushcwEntity.setCompanyId(resendEntity.getCompanyId());
				pushcwEntity.setCompanyName(resendEntity.getCompanyName());

				SimpleDateFormat simpleDateFormat1=new SimpleDateFormat("yyyyMMddHHmmss");
				String today = simpleDateFormat1.format(resendEntity.getCreateTime());

				pushcwEntity.setCode(resendEntity.getCompanyId()+"-"+today+"-"+resendEntity.getAcSetCode());

				pushcwEntity.setId(null);
				pushcwEntity.setSourceType("重发单");
				pushcwEntity.setPayState("0");

				actualSum = actualSum.add(pushcwEntity.getActual());
			}
			if (actualSum.compareTo(resendEntity.getActualSumMny()) != 0){
				return CommonResponse.error("请联系开发人员！重发单推送到财务的实发金额错误，金额为："+actualSum);
			}
			pushcwService.saveOrUpdateBatch(actualMny);
		}
		CommonResponse<PMGzVO> res = salaryTakeEffect(billId);
		if (!res.isSuccess()) {
			logger.error("调用PM财务模块生效接口失败！message-{}", res.getMsg());
			return CommonResponse.error("调用PM财务模块生效接口失败");
		}

		return CommonResponse.success();
	}
	private CommonResponse<PMGzVO> salaryTakeEffect(Long resendId) {
		logger.info("调用财务的生效接口---重发单ID-{}", resendId);
		QueryParam queryParam = new QueryParam();
		queryParam.getParams().put("sourceId",new Parameter(QueryParam.EQ,resendId));
		List<PushcwEntity> acActualMny = pushcwService.queryList(queryParam);

		if (CollectionUtils.isEmpty(acActualMny) ) {
			logger.error("根据重发单ID-{}，查询不到工资数据，无法调用生效接口", resendId);
			return CommonResponse.error("根据重发单ID-【" + resendId + "】查询不到工资支付申请数据，无法调用生效接口");
		}
		//计算出总的实发金额
		BigDecimal reduce = acActualMny.stream().map(PushcwEntity::getActual).reduce(BigDecimal.ZERO, BigDecimal::add);
		SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
		ArrayList<PMGzVO> pmGzVOS = new ArrayList<>();
			PMGzVO pmSalaryPayApplyVO = new PMGzVO();
			pmSalaryPayApplyVO.setId(IdWorker.getId()+"");
			//账套
			pmSalaryPayApplyVO.setAcCode(acActualMny.get(0).getAcSetCode());
			pmSalaryPayApplyVO.setAcName(acActualMny.get(0).getAcSet());
			//月份，编号，金额
			pmSalaryPayApplyVO.setYearMonth(sdf.format(acActualMny.get(0).getMonth()));
			pmSalaryPayApplyVO.setPmBillId(acActualMny.get(0).getCode());
			pmSalaryPayApplyVO.setActualMny(reduce);
			pmSalaryPayApplyVO.setQuoteFlag("N");//初始引用状态 为未引用
			pmGzVOS.add(pmSalaryPayApplyVO);

		ArrayList<PMGzDetailVO> pmGzDetailVOS = new ArrayList<>();
		for (PushcwEntity pushcwEntity : acActualMny) {
			PMGzDetailVO pmApplyDetailVO = new PMGzDetailVO();

			pmApplyDetailVO.setId(IdWorker.getId()+"");
			//姓名
			pmApplyDetailVO.setName(pushcwEntity.getDetailEmployeeName());
			pmApplyDetailVO.setIdCard(pushcwEntity.getIdCard());
			//银行相关
			pmApplyDetailVO.setBankName(pushcwEntity.getBankName());
			pmApplyDetailVO.setBankCount(pushcwEntity.getBankAccount());
			pmApplyDetailVO.setBankAddress(pushcwEntity.getBankAddress());
			//编号，金额
			pmApplyDetailVO.setPmBillId(pushcwEntity.getCode());
			pmApplyDetailVO.setActualMny(pushcwEntity.getActual());
			pmApplyDetailVO.setState("0");//默认未发放
			pmGzDetailVOS.add(pmApplyDetailVO);
		}
		pmGzVOS.get(0).setDetailList(pmGzDetailVOS);


		logger.info("开始调用PM工资支付申请生效接口，接口参数VO-{}", JSONObject.toJSONString(pmGzVOS));
		CommonResponse<PMGzVO> res = salarySystemApi.salaryTakeEffect(pmGzVOS);
		logger.info("调用PM资金的生效接口----SalaryPayApplyBpmServiceImpl类---salaryTakeEffect方法---end，接口返回结果-{}", JSONObject.toJSONString(res, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
		if (!res.isSuccess()){
			return  CommonResponse.error("工资信息推送中间表失败，失败原因：" + res.getMsg());
		}

		return res;
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	}
	private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
		// 查询当前申请单是否是当前所属合同下的申请单中的最新的一个，如果不是，不允许撤回
		ResendEntity resendEntity = resendService.selectById(billId);


		if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(resendEntity.getBillState()) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(resendEntity.getBillState())){

			//判断当前申请单是否在中间表中被引用，如果被引用，则不可撤回
			if (null != resendEntity){

				QueryParam queryParam = new QueryParam();
				queryParam.getParams().put("sourceId",new Parameter(QueryParam.EQ,billId));
				List<PushcwEntity> acActualMny = pushcwService.queryList(queryParam);

				if (CollectionUtils.isEmpty(acActualMny) ) {
					logger.error("根据重发单ID-{}，查询不到工资数据，无法调用生效接口", billId);
					return CommonResponse.error("根据重发单ID-【" + billId + "】查询不到工资支付申请数据，无法调用生效接口");
				}

					PMGzVO pmSalaryPayApplyVO = new PMGzVO();
					pmSalaryPayApplyVO.setId(IdWorker.getId()+"");
					pmSalaryPayApplyVO.setPmBillId(acActualMny.get(0).getCode());
					CommonResponse<PMGzVO> res = salarySystemApi.salaryAbandonOrClose(pmSalaryPayApplyVO);
					logger.info("调用PM工资支付的弃审接口---ejc-profinance项目---bpmBackCheck方法---end，接口返回结果-{}", JSONObject.toJSONString(res, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
					if (!res.isSuccess()) {
						return CommonResponse.error("工资重发查询财务系统中间表失败，失败原因：" + res.getMsg());
					} else {
						PMGzVO resultVO = res.getData();
						if (null != resultVO) {
							if ("Y".equals(resultVO.getQuoteFlag())) {
								return CommonResponse.error("该申请单已经被财务系统引用，不能撤回/弃审");
							} else {
								//删除实付明细表的数据
								pushcwService.remove(new QueryWrapper<PushcwEntity>()
										.eq("source_id", billId)
								);
							}
						}
					}
				}
			}

		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
