/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.salary.controller;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.desktop.api.IIdmUserApi;
import com.ejianc.business.salary.bean.CompanyEntity;
import com.ejianc.business.salary.bean.PayableDetailEntity;
import com.ejianc.business.salary.bean.PayableEntity;
import com.ejianc.business.salary.bean.RosterAttendanceEntity;
import com.ejianc.business.salary.bean.RosterEntity;
import com.ejianc.business.salary.mapper.RosterTransferMapper;
import com.ejianc.business.salary.service.ICompanyService;
import com.ejianc.business.salary.service.IPayableService;
import com.ejianc.business.salary.service.IRosterAttendanceService;
import com.ejianc.business.salary.service.IRosterService;
import com.ejianc.business.salary.service.IRosterTransferService;
import com.ejianc.business.salary.util.DetailIndexExcelReader;
import com.ejianc.business.salary.vo.PayableDetailVO;
import com.ejianc.business.salary.vo.PayableVO;
import com.ejianc.business.salary.vo.RosterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"payable"})
public class PayableController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "YFGZSC_CODE";
    @Autowired
    private IPayableService service;
    @Autowired
    private IRosterService rosterService;
    @Autowired
    private ICompanyService companyService;
    @Autowired
    private IRosterTransferService transferService;
    static Long zzyjOrgId = 1502571152583692289L;
    @Autowired
    private RosterTransferMapper transferMapper;
    @Autowired
    private IIdmUserApi userApi;
    @Autowired
    private IRosterAttendanceService attendanceService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PayableVO> saveOrUpdate(@RequestBody PayableVO saveOrUpdateVO) {
        PayableEntity entity = (PayableEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PayableEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setOrgBillNum(entity.getOrgBillNum() + 1);
        }
        List<Long> zzyjOrgIds = this.zzyjOrgIds();
        List<PayableDetailEntity> payableDetailList = entity.getPayableDetailList();
        if (CollectionUtils.isNotEmpty(payableDetailList)) {
            for (PayableDetailEntity payableDetailEntity : payableDetailList) {
                payableDetailEntity.setGzffOrgId(entity.getOrgId());
                payableDetailEntity.setGzffOrgCode(entity.getOrgCode());
                payableDetailEntity.setGzffOrgName(entity.getOrgName());
                Map<Long, String> orgids = null;
                if (zzyjOrgId.equals(payableDetailEntity.getSbcdCompanyId())) {
                    orgids = zzyjOrgIds.stream().collect(Collectors.toMap(p -> p, p -> p.toString(), (v1, v2) -> v2));
                } else {
                    CommonResponse childrenByParentId = this.iOrgApi.findChildrenByParentId(payableDetailEntity.getSbcdCompanyId());
                    if (childrenByParentId != null && childrenByParentId.getCode() == 0) {
                        List data = (List)childrenByParentId.getData();
                        if (CollectionUtils.isEmpty((Collection)data)) {
                            throw new BusinessException("\u83b7\u53d6\u793e\u4fdd\u72ec\u7acb\u5f00\u6237\u516c\u53f8\u4fe1\u606f\u5931\u8d25\uff01");
                        }
                        orgids = data.stream().collect(Collectors.toMap(BaseVO::getId, OrgVO::getInnerCode, (v1, v2) -> v2));
                    }
                }
                if (orgids.containsKey(payableDetailEntity.getGzffOrgId())) continue;
                payableDetailEntity.setSbcdOrgId(null);
                payableDetailEntity.setSbcdOrgCode(null);
                payableDetailEntity.setSbcdOrgName(null);
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        PayableVO vo = (PayableVO)BeanMapper.map((Object)((Object)entity), PayableVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PayableVO> queryDetail(Long id) {
        PayableEntity entity = (PayableEntity)((Object)this.service.selectById(id));
        PayableVO vo = (PayableVO)BeanMapper.map((Object)((Object)entity), PayableVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/getDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> getDetail(Long id) {
        PayableEntity entity = (PayableEntity)((Object)this.service.selectById(id));
        List<Object> orgIds = new ArrayList();
        CommonResponse orgVo = this.iOrgApi.getOneById(entity.getOrgId());
        if (5 == ((OrgVO)orgVo.getData()).getOrgType()) {
            Long parendId = ((OrgVO)this.iOrgApi.getOneById(((OrgVO)orgVo.getData()).getParentId()).getData()).getId();
            orgIds = ((List)this.iOrgApi.findChildrenByParentId(parendId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        } else {
            orgIds = ((List)this.iOrgApi.findChildrenByParentId(entity.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        }
        Map<Object, Object> orgMnyMap = new HashMap();
        List<PayableDetailVO> orgMnyList = this.service.getDetailByOrg(entity.getMonth(), orgIds);
        orgMnyMap = orgMnyList.stream().collect(Collectors.toMap(PayableDetailVO::getIdCard, PayableDetailVO::getYfSalaryMny, (key1, key2) -> key2));
        Map<Object, Object> mnyMap = new HashMap();
        List<PayableDetailVO> mnyList = this.service.getDetail(entity.getMonth());
        mnyMap = mnyList.stream().collect(Collectors.toMap(PayableDetailVO::getIdCard, PayableDetailVO::getYfSalaryMny, (key1, key2) -> key2));
        for (PayableDetailEntity detailVO : entity.getPayableDetailList()) {
            if (orgMnyMap.containsKey(detailVO.getIdCard())) {
                detailVO.setOrgSalaryMny((BigDecimal)orgMnyMap.get(detailVO.getIdCard()));
            }
            if (!mnyMap.containsKey(detailVO.getIdCard())) continue;
            detailVO.setOrgsSalaryMny((BigDecimal)mnyMap.get(detailVO.getIdCard()));
        }
        this.service.saveOrUpdate((Object)entity, false);
        PayableVO vo = (PayableVO)BeanMapper.map((Object)((Object)entity), PayableVO.class);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)true);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PayableVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (PayableVO payableVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PayableVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("acSet");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("corpName");
        fuzzyFields.add("payableName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PayableVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("acSet");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("corpName");
        fuzzyFields.add("payableName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List resList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            resList = BeanMapper.mapList((Iterable)list, PayableVO.class);
            resList.forEach(e -> {
                e.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)e.getBillState()).getDescription());
                if (2 == e.getCollectStatus()) {
                    e.setCollectStatusName("\u88ab\u9a73\u56de");
                } else if (1 == e.getCollectStatus()) {
                    e.setCollectStatusName("\u5df2\u6c47\u603b");
                } else {
                    e.setCollectStatusName("\u672a\u6c47\u603b");
                }
            });
        }
        HashMap beans = new HashMap();
        beans.put("records", resList);
        ExcelExport.getInstance().export("Payable-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refPayableData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PayableVO>> refPayableData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PayableVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/downloadInfo"})
    @ResponseBody
    public void downloadMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"PayableDetail-import.xlsx", (String)"\u5e94\u53d1\u5de5\u8d44\u4e0a\u4f20-\u660e\u7ec6\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="month", required=true) Integer month, @RequestParam(value="orgIda", required=true) Long orgId, @RequestParam(value="orgType", required=true) Integer orgType) throws ParseException {
        SimpleDateFormat ft = new SimpleDateFormat("yyyyMM");
        DateTime dateTime = DateUtil.date((Date)ft.parse(month + ""));
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<PayableDetailVO> successList = new ArrayList<PayableDetailVO>();
        ArrayList<PayableDetailVO> errorList = new ArrayList<PayableDetailVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List<List<String>> result = DetailIndexExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            ArrayList<String> idCardList = new ArrayList<String>();
            for (int i = 1; i < result.size(); ++i) {
                List<String> datas = result.get(i);
                idCardList.add(datas.get(1).trim());
            }
            List<Object> userList = new ArrayList();
            ArrayList<String> orgCodes = new ArrayList<String>();
            ArrayList<String> orgCodes2 = new ArrayList<String>();
            CommonResponse orgVOCommonResponse = this.orgApi.detailById(orgId);
            orgCodes.add(((OrgVO)orgVOCommonResponse.getData()).getCode());
            if (5 == orgType) {
                orgCodes2.add(((OrgVO)orgVOCommonResponse.getData()).getCode());
                userList = this.service.getUserByOrgCode(orgCodes, orgCodes2, month);
            } else {
                userList = this.service.getUserByOrgCode(orgCodes, null, month);
            }
            Map userIdCard = userList.stream().collect(Collectors.toMap(RosterVO::getIdCard, Function.identity(), (v1, v2) -> v1.getSourceType().indexOf("\u4e3b\u5c97") > -1 ? v1 : v2));
            Map<Object, Object> map = new HashMap();
            LambdaQueryWrapper lambdaQueryWrapper1 = new LambdaQueryWrapper();
            lambdaQueryWrapper1.in(RosterEntity::getIdCard, idCardList);
            lambdaQueryWrapper1.isNotNull(RosterEntity::getIdCard);
            List rosterEntityList = this.rosterService.list((Wrapper)lambdaQueryWrapper1);
            map = rosterEntityList.stream().collect(Collectors.toMap(p -> p.getIdCard(), Function.identity(), (v1, v2) -> v2));
            this.logger.info("\u4eba\u5458map: {}", (Object)JSONObject.toJSONString(map));
            Map<Object, Object> attendanceMap = new HashMap();
            LambdaQueryWrapper lambdaQueryWrapper2 = new LambdaQueryWrapper();
            lambdaQueryWrapper2.in(RosterAttendanceEntity::getIdCard, idCardList);
            lambdaQueryWrapper2.eq(RosterAttendanceEntity::getMonth, (Object)month);
            List list = this.attendanceService.list((Wrapper)lambdaQueryWrapper2);
            attendanceMap = list.stream().collect(Collectors.toMap(p -> p.getIdCard(), Function.identity(), (v1, v2) -> v2));
            List<Long> zzyjOrgIds = this.zzyjOrgIds();
            for (int i = 1; i < result.size(); ++i) {
                PayableDetailVO detailVO;
                List<String> datas;
                block69: {
                    datas = result.get(i);
                    detailVO = new PayableDetailVO();
                    detailVO.setId(Long.valueOf(IdWorker.getId()));
                    try {
                        String idCard = datas.get(1).trim();
                        detailVO.setIdCard(idCard);
                        if (ObjectUtils.isEmpty((Object)map.get(idCard))) {
                            throw new Exception("\u6ca1\u6709\u8be5\u4eba\u5458\u4fe1\u606f\uff01");
                        }
                        RosterEntity rosterEntity = (RosterEntity)((Object)map.get(idCard));
                        if (!rosterEntity.getUserName().equals(datas.get(0))) {
                            throw new Exception("\u59d3\u540d\u6216\u8eab\u4efd\u8bc1\u53f7\u586b\u5199\u9519\u8bef\uff01");
                        }
                        detailVO.setDetailEmployeeName(datas.get(0));
                        detailVO.setDetailEmployeeId(rosterEntity.getUserId());
                        detailVO.setDetailEmployeeCode(rosterEntity.getUserCode());
                        if (!userIdCard.containsKey(idCard)) {
                            throw new Exception("\u8be5\u4eba\u5458\u4e0d\u5c5e\u4e8e\u672c\u7ec4\u7ec7\uff0c\u65e0\u6cd5\u5728\u672c\u7ec4\u7ec7\u4e0b\u53d1\u653e\u5de5\u8d44\uff01");
                        }
                        QueryParam param = new QueryParam();
                        param.getParams().put("isOnlySocial", new Parameter("eq", (Object)"\u662f"));
                        param.getParams().put("hrState", new Parameter("eq", (Object)"1"));
                        List rosterEntities = this.rosterService.queryList(param);
                        Map onlySocialList = rosterEntities.stream().collect(Collectors.toMap(RosterEntity::getIdCard, Function.identity(), (v1, v2) -> v2));
                        if (onlySocialList.containsKey(idCard)) {
                            throw new Exception("\u8be5\u4eba\u5458\u4e3a\u4ec5\u793e\u4fdd\u4eba\u5458\uff0c\u4e0d\u4e0a\u4f20\u5de5\u8d44\uff01");
                        }
                        if (rosterEntity.getSocialCompanyId() == null) {
                            throw new Exception("\u8bf7\u7ef4\u62a4\u8be5\u4eba\u5458\u7684\u793e\u4fdd\u627f\u62c5\u516c\u53f8\u4fe1\u606f\uff01");
                        }
                        if (((RosterVO)userIdCard.get(idCard)).getSourceType().indexOf("\u4e3b\u5c97") > -1) {
                            detailVO.setJobType(((RosterVO)userIdCard.get(idCard)).getSourceType());
                        } else {
                            detailVO.setJobType("\u975e\u4e3b\u5c97");
                        }
                        if (rosterEntity.getPayOrgId() != null) {
                            detailVO.setDetailOrgId(rosterEntity.getPayOrgId());
                            detailVO.setDetailOrgCode(rosterEntity.getPayOrgCode());
                            detailVO.setDetailOrgName(rosterEntity.getPayOrgName());
                        } else {
                            detailVO.setDetailOrgId(rosterEntity.getOrgId());
                            detailVO.setDetailOrgCode(rosterEntity.getOrgCode());
                            detailVO.setDetailOrgName(rosterEntity.getOrgName());
                        }
                        detailVO.setJob(rosterEntity.getPostName());
                        detailVO.setDept(rosterEntity.getDepartmentName());
                        detailVO.setJobLevel(rosterEntity.getJobLevelName());
                        detailVO.setSbjnOrgName(rosterEntity.getSocialDepartmentName());
                        detailVO.setSbjnOrgCode(rosterEntity.getSocialDepartmentCode());
                        detailVO.setIsMove("2");
                        detailVO.setSbcdCompanyId(rosterEntity.getSocialCompanyId());
                        detailVO.setSbcdCompanyCode(rosterEntity.getSocialCompanyCode());
                        detailVO.setSbcdCompanyName(rosterEntity.getCompanyName());
                        detailVO.setDetailCollectStatus(Integer.valueOf(0));
                        Map<Long, String> orgids = null;
                        if (zzyjOrgId.equals(rosterEntity.getSocialCompanyId())) {
                            orgids = zzyjOrgIds.stream().collect(Collectors.toMap(p -> p, p -> p.toString(), (v1, v2) -> v2));
                        } else {
                            CommonResponse childrenByParentId = this.iOrgApi.findChildrenByParentId(rosterEntity.getSocialCompanyId());
                            if (childrenByParentId != null && childrenByParentId.getCode() == 0) {
                                List data = (List)childrenByParentId.getData();
                                if (CollectionUtils.isEmpty((Collection)data)) {
                                    throw new BusinessException("\u83b7\u53d6\u793e\u4fdd\u72ec\u7acb\u5f00\u6237\u516c\u53f8\u4fe1\u606f\u5931\u8d25\uff01");
                                }
                                orgids = data.stream().collect(Collectors.toMap(BaseVO::getId, OrgVO::getInnerCode, (v1, v2) -> v2));
                            }
                        }
                        if (orgids.containsKey(rosterEntity.getPayOrgId())) {
                            detailVO.setSbcdOrgId(rosterEntity.getPayOrgId());
                            detailVO.setSbcdOrgCode(rosterEntity.getPayOrgCode());
                            detailVO.setSbcdOrgName(rosterEntity.getPayOrgName());
                        } else if (orgids.containsKey(rosterEntity.getOrgId())) {
                            detailVO.setSbcdOrgId(rosterEntity.getOrgId());
                            detailVO.setSbcdOrgCode(rosterEntity.getOrgCode());
                            detailVO.setSbcdOrgName(rosterEntity.getOrgName());
                        } else {
                            detailVO.setSbcdOrgId(rosterEntity.getSocialCompanyId());
                            detailVO.setSbcdOrgCode(rosterEntity.getSocialCompanyCode());
                            detailVO.setSbcdOrgName(rosterEntity.getCompanyName());
                        }
                        if (!ObjectUtils.isNotEmpty((Object)attendanceMap.get(idCard))) break block69;
                        detailVO.setWorkDaysLastMonth(((RosterAttendanceEntity)((Object)attendanceMap.get(idCard))).getActualDay());
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg(e.getMessage());
                        errorList.add(detailVO);
                        continue;
                    }
                }
                try {
                    String unWriteOffMny = datas.get(17);
                    detailVO.setUnWriteOffMny(StringUtils.isNotBlank((CharSequence)unWriteOffMny) ? new BigDecimal(unWriteOffMny) : null);
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u622a\u6b62\u5f53\u524d\u672a\u6838\u9500\u91d1\u989d\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                try {
                    String writeOffMny = datas.get(18);
                    detailVO.setWriteOffMny(StringUtils.isNotBlank((CharSequence)writeOffMny) ? new BigDecimal(writeOffMny) : null);
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u672c\u6b21\u6838\u9500\u91d1\u989d\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                try {
                    String yfjsMny = datas.get(19);
                    detailVO.setYfjsMny(StringUtils.isNotBlank((CharSequence)yfjsMny) ? new BigDecimal(yfjsMny) : null);
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u5e94\u53d1\u8ba1\u7a0e\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                try {
                    String yfmsMny = datas.get(20);
                    detailVO.setYfmsMny(StringUtils.isNotBlank((CharSequence)yfmsMny) ? new BigDecimal(yfmsMny) : null);
                    detailVO.setTaxYfmsMny(detailVO.getYfmsMny());
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u5e94\u53d1\u514d\u7a0e\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                try {
                    String jobMny = datas.get(3);
                    detailVO.setJobMny(StringUtils.isNotBlank((CharSequence)jobMny) ? new BigDecimal(jobMny) : null);
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u5c97\u4f4d\u5de5\u8d44\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                try {
                    String performanceMny = datas.get(4);
                    detailVO.setPerformanceMny(StringUtils.isNotBlank((CharSequence)performanceMny) ? new BigDecimal(performanceMny) : null);
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u7ee9\u6548\u5de5\u8d44\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                try {
                    String workYearMny = datas.get(5);
                    detailVO.setWorkYearMny(StringUtils.isNotBlank((CharSequence)workYearMny) ? new BigDecimal(workYearMny) : null);
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u53f8\u9f84\u8865\u8d34\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                try {
                    String workTypeMny = datas.get(6);
                    detailVO.setWorkTypeMny(StringUtils.isNotBlank((CharSequence)workTypeMny) ? new BigDecimal(workTypeMny) : null);
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u804c\u79f0\u8865\u8d34\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                try {
                    String certificateMny = datas.get(7);
                    detailVO.setCertificateMny(StringUtils.isNotBlank((CharSequence)certificateMny) ? new BigDecimal(certificateMny) : null);
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u8bc1\u4e66\u8865\u8d34\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                try {
                    String travelMny = datas.get(8);
                    detailVO.setTravelMny(StringUtils.isNotBlank((CharSequence)travelMny) ? new BigDecimal(travelMny) : null);
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u6d3e\u9a7b\u8865\u8d34\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                try {
                    String trafficMny = datas.get(9);
                    detailVO.setTrafficMny(StringUtils.isNotBlank((CharSequence)trafficMny) ? new BigDecimal(trafficMny) : null);
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u4ea4\u901a\u8865\u8d34\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                try {
                    String mealMny = datas.get(10);
                    detailVO.setMealMny(StringUtils.isNotBlank((CharSequence)mealMny) ? new BigDecimal(mealMny) : null);
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u9910\u8865\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                try {
                    String benefitMny = datas.get(11);
                    detailVO.setBenefitMny(StringUtils.isNotBlank((CharSequence)benefitMny) ? new BigDecimal(benefitMny) : null);
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u798f\u5229\u8d39\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                try {
                    String holidayMny = datas.get(12);
                    detailVO.setHolidayMny(StringUtils.isNotBlank((CharSequence)holidayMny) ? new BigDecimal(holidayMny) : null);
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u8fc7\u8282\u8d39\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                try {
                    String yearEndMny = datas.get(13);
                    detailVO.setYearEndMny(StringUtils.isNotBlank((CharSequence)yearEndMny) ? new BigDecimal(yearEndMny) : null);
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u5e74\u7ec8\u5956\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                try {
                    String overtimeMny = datas.get(14);
                    detailVO.setOvertimeMny(StringUtils.isNotBlank((CharSequence)overtimeMny) ? new BigDecimal(overtimeMny) : null);
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u52a0\u73ed\u8d39\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                try {
                    String addMny = datas.get(15);
                    detailVO.setAddMny(StringUtils.isNotBlank((CharSequence)addMny) ? new BigDecimal(addMny) : null);
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u8865\u6b3e\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                try {
                    String buttonMny = datas.get(16);
                    detailVO.setButtonMny(StringUtils.isNotBlank((CharSequence)buttonMny) ? new BigDecimal(buttonMny) : null);
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u6263\u6b3e\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                try {
                    BigDecimal add = ComputeUtil.safeAdd((BigDecimal)detailVO.getJobMny(), (BigDecimal[])new BigDecimal[]{detailVO.getPerformanceMny(), detailVO.getWorkYearMny(), detailVO.getWorkTypeMny(), detailVO.getCertificateMny(), detailVO.getTravelMny(), detailVO.getTrafficMny(), detailVO.getMealMny(), detailVO.getBenefitMny(), detailVO.getHolidayMny(), detailVO.getYearEndMny(), detailVO.getOvertimeMny(), detailVO.getAddMny()});
                    detailVO.setSalaryMny(ComputeUtil.safeSub((BigDecimal)add, (BigDecimal)detailVO.getButtonMny()));
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u5de5\u8d44\u5408\u8ba1\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                try {
                    detailVO.setYfSalaryMny(ComputeUtil.safeAdd((BigDecimal)detailVO.getWriteOffMny(), (BigDecimal)detailVO.getSalaryMny()));
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u5e94\u53d1\u5de5\u8d44\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                if (orgId.equals(detailVO.getDetailOrgId())) {
                    BigDecimal sbGjjPersonMoney = this.service.getSbGjjPersonMoney(detailVO.getIdCard());
                    if (sbGjjPersonMoney == null) {
                        sbGjjPersonMoney = BigDecimal.ZERO;
                    }
                    if (sbGjjPersonMoney != null && sbGjjPersonMoney.multiply(new BigDecimal(1.2)).compareTo(detailVO.getYfSalaryMny()) > 0) {
                        detailVO.setErrorMsg("\u5e94\u53d1\u5de5\u8d44(" + detailVO.getYfSalaryMny() + ")\u5e94\u5927\u4e8e\u793e\u4fdd\u516c\u79ef\u91d1\u4e2a\u4eba\u90e8\u5206(" + sbGjjPersonMoney + ")1.2\u500d\uff01");
                        errorList.add(detailVO);
                        continue;
                    }
                }
                detailVO.setYfmsSalaryMny(ComputeUtil.safeAdd((BigDecimal)detailVO.getYfmsMny(), (BigDecimal)detailVO.getYfSalaryMny()));
                detailVO.setRowState("add");
                successList.add(detailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    public List<Long> zzyjOrgIds() {
        return this.service.zzyjOrgIds();
    }

    @RequestMapping(value={"/isZzyjOrg"}, method={RequestMethod.GET})
    @ResponseBody
    public Boolean isZzyjOrg(Long orgId) {
        return this.service.isZzyjOrg(orgId);
    }

    public String lastMonthStart(DateTime dateTime) {
        int year = DateUtil.year((Date)dateTime);
        int month = DateUtil.month((Date)dateTime) + 1;
        DateTime parse = DateUtil.parse((String)(year + "-" + month + "-15"), (String)"yyyy-MM-dd");
        return parse.toDateStr();
    }

    @RequestMapping(value={"/queryPayableDataByOrg"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PayableVO>> queryPayableDataByOrg(@RequestBody QueryParam param) {
        Long orgId;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        if (param.getParams().get("month") != null) {
            String month = ((Parameter)param.getParams().get("month")).getValue().toString();
            param.getParams().remove("month");
            param.getParams().put("month", new Parameter("eq", (Object)(month + "-01")));
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (param.getParams().get("orgId") != null) {
            orgId = Long.valueOf(((Parameter)param.getParams().get("orgId")).getValue().toString());
            param.getParams().remove("orgId");
        } else {
            orgId = InvocationInfoProxy.getOrgId();
        }
        CommonResponse orgIdCrs = this.iOrgApi.getOneById(orgId);
        if (!orgIdCrs.isSuccess() || null == orgIdCrs.getData()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        Integer orgType = ((OrgVO)orgIdCrs.getData()).getOrgType();
        if (5 == orgType) {
            CommonResponse parentByOrgId = this.iOrgApi.findParentByOrgId(orgId);
            if (!parentByOrgId.isSuccess() || null == parentByOrgId.getData()) {
                throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("org_id", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(((OrgVO)parentByOrgId.getData()).getId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("org_id", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PayableVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelPayableDataExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelPayableDataExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgIdCrs = this.iOrgApi.getOneById(orgId);
        if (!orgIdCrs.isSuccess() || null == orgIdCrs.getData()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        Integer orgType = ((OrgVO)orgIdCrs.getData()).getOrgType();
        if (5 == orgType) {
            CommonResponse parentByOrgId = this.iOrgApi.findParentByOrgId(orgId);
            if (!parentByOrgId.isSuccess() || null == parentByOrgId.getData()) {
                throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("org_id", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(((OrgVO)parentByOrgId.getData()).getId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("org_id", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", BeanMapper.mapList((Iterable)page.getRecords(), PayableVO.class));
        ExcelExport.getInstance().export("PayableData-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/autoCreateBillNoSecurity"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> autoCreateBillNoSecurity(Long companyId) {
        ArrayList<Long> companyIds = new ArrayList();
        if (zzyjOrgId.equals(companyId)) {
            companyIds = this.service.zzyjOrgIds();
        } else {
            CommonResponse childrenByParentId = this.iOrgApi.findChildrenByParentId(companyId);
            if (childrenByParentId != null && childrenByParentId.getCode() == 0) {
                List data = (List)childrenByParentId.getData();
                if (CollectionUtils.isEmpty((Collection)data)) {
                    throw new BusinessException("\u83b7\u53d6\u793e\u4fdd\u72ec\u7acb\u5f00\u6237\u516c\u53f8\u4fe1\u606f\u5931\u8d25\uff01");
                }
                companyIds = data.stream().map(BaseVO::getId).collect(Collectors.toList());
            }
        }
        Date lastMonth = this.getLastMonth();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        QueryParam paramPayable = new QueryParam();
        paramPayable.getParams().put("month", new Parameter("eq", (Object)sdf.format(lastMonth)));
        paramPayable.getParams().put("payableType", new Parameter("eq", (Object)3));
        paramPayable.getParams().put("orgId", new Parameter("in", companyIds));
        List payableEntities = this.service.queryList(paramPayable);
        if (CollectionUtils.isNotEmpty((Collection)payableEntities)) {
            throw new BusinessException("\u672c\u6708\u5df2\u751f\u6210\u4ec5\u793e\u4fdd\u5de5\u8d44\u5355\uff01");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("isOnlySocial", new Parameter("eq", (Object)"\u662f"));
        param.getParams().put("hrState", new Parameter("eq", (Object)"1"));
        List rosterEntities = this.rosterService.queryList(param);
        if (CollectionUtils.isNotEmpty((Collection)rosterEntities)) {
            return this.service.autoCreatePayableDetail(rosterEntities, companyIds, 3);
        }
        return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (Object)true);
    }

    @RequestMapping(value={"/getNoUploadPersonList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<RosterVO>> getNoUploadPersonList(@RequestBody QueryParam param) {
        List<Object> companyIds;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("idCard");
        fuzzyFields.add("userName");
        if (param.getParams().containsKey("company")) {
            Long company = Long.parseLong(((Parameter)param.getParams().get("company")).getValue().toString());
            CompanyEntity companyEntity = (CompanyEntity)((Object)this.companyService.selectById(company));
            Long companyId = companyEntity.getOrgId();
            companyIds = new ArrayList();
            if (zzyjOrgId.equals(companyId)) {
                companyIds = this.service.zzyjOrgIds();
            } else {
                CommonResponse childrenByParentId = this.iOrgApi.findChildrenByParentId(companyId);
                if (childrenByParentId != null && childrenByParentId.getCode() == 0) {
                    List data = (List)childrenByParentId.getData();
                    if (CollectionUtils.isEmpty((Collection)data)) {
                        throw new BusinessException("\u83b7\u53d6\u793e\u4fdd\u72ec\u7acb\u5f00\u6237\u516c\u53f8\u4e0b\u5c5e\u7ec4\u7ec7\u5931\u8d25\uff01");
                    }
                    companyIds = data.stream().map(BaseVO::getId).collect(Collectors.toList());
                }
            }
        } else {
            return CommonResponse.error((String)"\u8bf7\u5148\u9009\u62e9\u516c\u53f8\uff01");
        }
        param.getParams().put("orgId", new Parameter("in", companyIds));
        param.getParams().remove("company");
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<RosterVO> noUploadPersonList = this.service.getNoUploadPersonList((Page<RosterVO>)page, wrapper);
        page.setRecords(noUploadPersonList);
        return CommonResponse.success((String)"\u67e5\u8be2\u62a5\u5907\u4eba\u5458\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/autoCreateNoUpload"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> autoCreateNoUpload(String ids, Long company) {
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter("in", (Object)ids));
        List rosterEntities = this.rosterService.queryList(param);
        if (CollectionUtils.isNotEmpty((Collection)rosterEntities)) {
            CompanyEntity companyEntity = (CompanyEntity)((Object)this.companyService.selectById(company));
            Long companyId = companyEntity.getOrgId();
            List<Object> companyIds = new ArrayList();
            if (zzyjOrgId.equals(companyId)) {
                companyIds = this.service.zzyjOrgIds();
            } else {
                CommonResponse childrenByParentId = this.iOrgApi.findChildrenByParentId(companyId);
                if (childrenByParentId != null && childrenByParentId.getCode() == 0) {
                    List data = (List)childrenByParentId.getData();
                    if (CollectionUtils.isEmpty((Collection)data)) {
                        throw new BusinessException("\u83b7\u53d6\u793e\u4fdd\u72ec\u7acb\u5f00\u6237\u516c\u53f8\u4fe1\u606f\u5931\u8d25\uff01");
                    }
                    companyIds = data.stream().map(BaseVO::getId).collect(Collectors.toList());
                }
            }
            return this.service.autoCreatePayableDetail(rosterEntities, companyIds, 2);
        }
        return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (Object)true);
    }

    public Date getLastMonth() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(2, -1);
        cal.set(5, cal.getActualMinimum(5));
        return cal.getTime();
    }
}

