/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.salary.controller.warn;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.salary.service.ILockService;
import com.ejianc.business.salary.service.IPayableService;
import com.ejianc.business.salary.vo.RosterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/payableWarn/"})
public class PayableWarnController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPayableService service;
    @Autowired
    private ILockService lockService;
    @Autowired
    private IWarnCenterApi warnCenterApi;
    @Autowired
    private IOrgApi iOrgApi;
    static String PC_URL = "/ejc-salary-frontend/#/payableUpload";

    @PostMapping(value={"execute"})
    public CommonResponse<String> execute(@RequestBody JSONArray jsonParam) {
        this.logger.info("\u63a5\u6536\u5230 Task \u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList<EarlyWarnTransVO> warnList = new ArrayList<EarlyWarnTransVO>();
        String warnCode = null;
        QueryParam paramLock = new QueryParam();
        paramLock.getParams().put("state", new Parameter("eq", (Object)"\u5f00\u542f"));
        List lockEntities = this.lockService.queryList(paramLock);
        for (int i = 0; i < jsonParam.size(); ++i) {
            QueryParam param;
            QueryWrapper wrapper;
            Page page;
            List<RosterVO> noUploadPersonList;
            Map<Long, List<RosterVO>> collect;
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            if (!CollectionUtils.isNotEmpty((Collection)lockEntities) || !CollectionUtils.isNotEmpty((collect = (noUploadPersonList = this.service.getNoUploadPersonList((Page<RosterVO>)(page = new Page(1L, -1L)), wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)(param = new QueryParam())))).stream().collect(Collectors.groupingBy(RosterVO::getOrgId))).keySet())) continue;
            for (Long orgId : collect.keySet()) {
                int i1;
                List<RosterVO> rosterVOS = collect.get(orgId);
                JSONObject orgSet = null;
                JSONObject defaultSet = null;
                OrgVO orgVO = (OrgVO)this.iOrgApi.getOneById(orgId).getData();
                if (orgVO == null) continue;
                String innerCode = orgVO.getInnerCode();
                String[] parentIds = innerCode.split("\\|");
                this.logger.info("parentIds______" + innerCode);
                for (i1 = parentIds.length - 1; i1 >= 0; --i1) {
                    Long pOrgId = Long.parseLong(parentIds[i1]);
                    for (int j = 0; j < orgSettings.size(); ++j) {
                        JSONObject set = orgSettings.getJSONObject(j);
                        if (!pOrgId.equals(set.getLong("orgId"))) continue;
                        orgSet = set;
                        break;
                    }
                    if (orgSet != null) break;
                }
                for (i1 = 0; i1 < orgSettings.size(); ++i1) {
                    JSONObject set = orgSettings.getJSONObject(i1);
                    if (!set.getBoolean("default").booleanValue()) continue;
                    defaultSet = set;
                    break;
                }
                if (orgSet == null) {
                    orgSet = defaultSet;
                }
                if (orgSet == null || !ListUtil.isNotEmpty((List)orgSet.getJSONArray("warningSetings"))) continue;
                JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                boolean high = false;
                boolean meddle = false;
                boolean low = false;
                JSONObject useSetHigh = null;
                Object useSetMeddle = null;
                Object useSetLow = null;
                Date now = new Date();
                for (int i12 = 0; i12 < warningSettings.size(); ++i12) {
                    JSONObject set = warningSettings.getJSONObject(i12);
                    if (!"\u9ad8".equals(set.getString("warningLevel"))) continue;
                    high = true;
                    useSetHigh = set;
                }
                if (!high && !meddle && !low) continue;
                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                vo.setBillName(rosterVOS.get(0).getOrgName() + "\u5b58\u5728\u672a\u4e0a\u4f20\u5de5\u8d44\u4eba\u5458");
                vo.setPcTitle("\u5e94\u53d1\u5de5\u8d44\u4e0a\u4f20");
                vo.setPcUrl(PC_URL);
                vo.setOrgId(orgId);
                vo.setSendOrgId(orgId + "");
                vo.setOrgName(rosterVOS.get(0).getOrgName());
                vo.setSourceId("");
                vo.setTenantId(tenantId);
                vo.setWarnSetId(orgSet.getLong("warnId"));
                vo.setEarlywarnName(orgSet.getString("warnName"));
                vo.setWarnType(orgSet.getString("warnType"));
                String tmpContent = orgSet.getString("warningContentTemplate");
                String nameString = rosterVOS.stream().map(r -> "'" + r.getUserName() + "'").collect(Collectors.joining(","));
                if (high) {
                    vo.setWarnLevel("\u9ad8");
                    vo.setWarnSetParamId(useSetHigh.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#num#", rosterVOS.size() + "").replaceAll("#list#", nameString).replaceAll("#orgName#", rosterVOS.get(0).getOrgName()));
                } else if (meddle) {
                    vo.setWarnLevel("\u4e2d");
                    vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#num#", rosterVOS.size() + "").replaceAll("#list#", nameString).replaceAll("#orgName#", rosterVOS.get(0).getOrgName()));
                } else {
                    vo.setWarnLevel("\u4f4e");
                    vo.setWarnSetParamId(useSetLow.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#num#", rosterVOS.size() + "").replaceAll("#list#", nameString).replaceAll("#orgName#", rosterVOS.get(0).getOrgName()));
                }
                warnList.add(vo);
            }
        }
        return this.sendWarnToTask(warnList, warnCode);
    }

    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, String warnCode) {
        CommonResponse warnResp = this.warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
        if (!warnResp.isSuccess()) {
            this.logger.error("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Object)warnResp.getMsg());
            return CommonResponse.error((String)("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25" + warnResp.getMsg()));
        }
        return CommonResponse.success((String)"\u4efb\u52a1\u63a5\u53d7\u5904\u7406\u6210\u529f\uff01");
    }
}

