/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.salary.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.salary.bean.JspayableDetailEntity;
import com.ejianc.business.salary.bean.JspayableEntity;
import com.ejianc.business.salary.bean.JspayableSourceEntity;
import com.ejianc.business.salary.bean.PayableDetailEntity;
import com.ejianc.business.salary.bean.PayrollEntity;
import com.ejianc.business.salary.bean.PayrollPersonEntity;
import com.ejianc.business.salary.bean.PayrollUnitEntity;
import com.ejianc.business.salary.bean.TaxDetailEntity;
import com.ejianc.business.salary.bean.TaxEntity;
import com.ejianc.business.salary.mapper.JspayableMapper;
import com.ejianc.business.salary.service.IAcSetRelateService;
import com.ejianc.business.salary.service.IJspayableService;
import com.ejianc.business.salary.service.IJspayableSourceService;
import com.ejianc.business.salary.service.IPayableDetailService;
import com.ejianc.business.salary.service.IPayrollService;
import com.ejianc.business.salary.service.ITaxModifyService;
import com.ejianc.business.salary.service.ITaxService;
import com.ejianc.business.salary.vo.JspayableDetailVO;
import com.ejianc.business.salary.vo.PayrollVO;
import com.ejianc.business.salary.vo.TaxVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="jspayable")
public class JspayableBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String TAX_BILL_CODE = "TAX";
    private static final String PAYROLL_BILL_CODE = "PAYROLL_CODE";
    @Autowired
    private IJspayableService jspayableService;
    @Autowired
    private ITaxService taxService;
    @Autowired
    private IPayrollService payrollService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ITaxModifyService taxModifyService;
    @Autowired
    private IJspayableSourceService jspayableSourceService;
    @Autowired
    private IAcSetRelateService acSetRelateService;
    @Autowired
    private IPayableDetailService payableDetailService;
    @Autowired
    private JspayableMapper mapper;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        JspayableEntity jspayableEntity = (JspayableEntity)((Object)this.jspayableService.selectById(billId));
        List<JspayableDetailVO> jspayableDetailVOS = this.mapper.checkSumMny(jspayableEntity.getMonth(), jspayableEntity.getCompanyId());
        if (CollectionUtils.isNotEmpty(jspayableDetailVOS)) {
            JspayableDetailVO jspayableDetailVO0 = jspayableDetailVOS.get(0);
            JspayableDetailVO jspayableDetailVO1 = jspayableDetailVOS.get(1);
            if (jspayableDetailVO0.getPersonEndowmentMny().compareTo(jspayableDetailVO1.getPersonEndowmentMny()) != 0 || jspayableDetailVO0.getPersonHouseMny().compareTo(jspayableDetailVO1.getPersonHouseMny()) != 0) {
                return CommonResponse.error((String)"\u65e0\u6cd5\u83b7\u53d6\u660e\u7ec6\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff01\uff01\uff01");
            }
        } else {
            return CommonResponse.error((String)"\u65e0\u6cd5\u83b7\u53d6\u660e\u7ec6\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        JspayableEntity jspayableEntity = (JspayableEntity)((Object)this.jspayableService.selectById(billId));
        TaxEntity taxEntity = new TaxEntity();
        taxEntity.setBillState(0);
        taxEntity.setId(IdWorker.getId());
        taxEntity.setEmployeeId(jspayableEntity.getEmployeeId());
        taxEntity.setEmployeeName(jspayableEntity.getEmployeeName());
        taxEntity.setYfgzjsBillId(jspayableEntity.getId());
        taxEntity.setYfgzjsBillCode(jspayableEntity.getBillCode());
        taxEntity.setMonth(jspayableEntity.getMonth());
        taxEntity.setCompanyId(jspayableEntity.getCompanyId());
        taxEntity.setCompanyOrgId(jspayableEntity.getCompanyOrgId());
        taxEntity.setCompanyName(jspayableEntity.getCompanyName());
        BillCodeParam billCodeParam = BillCodeParam.build((String)TAX_BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)((BaseVO)BeanMapper.map((Object)((Object)taxEntity), TaxVO.class)));
        CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
        if (!billCode.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        taxEntity.setBillCode((String)billCode.getData());
        ArrayList<TaxDetailEntity> taxDetailList = new ArrayList<TaxDetailEntity>();
        for (JspayableDetailEntity detail : jspayableEntity.getJspayableDetailList()) {
            TaxDetailEntity taxDetailEntity = (TaxDetailEntity)((Object)BeanMapper.map((Object)((Object)detail), TaxDetailEntity.class));
            taxDetailEntity.setId(IdWorker.getId());
            taxDetailEntity.setTaxId(taxEntity.getId());
            taxDetailEntity.setSybxMny(detail.getCriticalIllnessMny());
            taxDetailEntity.setIsAdjust("2");
            taxDetailEntity.setYfgzjsBillDetailId(detail.getId());
            taxDetailEntity.setYfgzjsBillId(billId);
            taxDetailEntity.setYfgzjsBillDetailSourceType(detail.getSourceType());
            taxDetailEntity.setTaxHoldOrgName(detail.getSbcdOrgName());
            taxDetailEntity.setTaxHoldOrgId(detail.getSbcdOrgId());
            taxDetailEntity.setTaxHoldOrgCode(detail.getSbcdOrgCode());
            taxDetailEntity.setYfmscwMny(BigDecimal.ZERO);
            taxDetailEntity.setYfjscwMny(BigDecimal.ZERO);
            taxDetailEntity.setYfmsSalaryMny(ComputeUtil.safeAdd((BigDecimal)(null != detail.getYfSalaryMny() ? detail.getYfSalaryMny() : BigDecimal.ZERO), (BigDecimal)(null != detail.getYfjsMny() ? detail.getYfjsMny() : BigDecimal.ZERO)));
            taxDetailList.add(taxDetailEntity);
        }
        taxEntity.setDetailList(taxDetailList);
        this.logger.info("\u751f\u6210\u4e2a\u7a0e\u8ba1\u7b97\u5355\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)taxEntity)));
        this.taxService.saveOrUpdate((Object)taxEntity, false);
        this.taxModifyService.initTaxModify(taxEntity.getId());
        PayrollEntity payrollEntity = new PayrollEntity();
        payrollEntity.setBillState(0);
        payrollEntity.setId(IdWorker.getId());
        payrollEntity.setEmployeeId(jspayableEntity.getEmployeeId());
        payrollEntity.setEmployeeName(jspayableEntity.getEmployeeName());
        payrollEntity.setYfgzjsBillId(jspayableEntity.getId());
        payrollEntity.setYfgzjsBillCode(jspayableEntity.getBillCode());
        payrollEntity.setTaxBillId(taxEntity.getId());
        payrollEntity.setMonth(jspayableEntity.getMonth());
        payrollEntity.setCompanyId(jspayableEntity.getCompanyId());
        payrollEntity.setCompanyOrgId(jspayableEntity.getCompanyOrgId());
        payrollEntity.setCompanyName(jspayableEntity.getCompanyName());
        BillCodeParam payrollBillCodeParam = BillCodeParam.build((String)PAYROLL_BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)((BaseVO)BeanMapper.map((Object)((Object)payrollEntity), PayrollVO.class)));
        CommonResponse payrollBillCode = this.billCodeApi.generateBillCode(payrollBillCodeParam);
        if (!payrollBillCode.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u5de5\u8d44\u5355\u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        payrollEntity.setBillCode((String)payrollBillCode.getData());
        ArrayList<PayrollPersonEntity> personDetailList = new ArrayList<PayrollPersonEntity>();
        for (JspayableDetailEntity detail : jspayableEntity.getJspayableDetailList()) {
            PayrollPersonEntity personDetailEntity = (PayrollPersonEntity)((Object)BeanMapper.map((Object)((Object)detail), PayrollPersonEntity.class));
            personDetailEntity.setId(IdWorker.getId());
            personDetailEntity.setSybxMny(detail.getCriticalIllnessMny());
            personDetailEntity.setGzffOrgId(detail.getDetailOrgId());
            personDetailEntity.setGzffOrgCode(detail.getDetailOrgCode());
            personDetailEntity.setGzffOrgName(detail.getDetailOrgName());
            personDetailEntity.setYfgzjsBillDetailId(detail.getId());
            personDetailEntity.setYfgzjsBillId(billId);
            personDetailEntity.setTaxBillId(taxEntity.getId());
            personDetailEntity.setPayrollId(payrollEntity.getId());
            personDetailEntity.setYfjscwMny(BigDecimal.ZERO);
            personDetailEntity.setYfmscwMny(BigDecimal.ZERO);
            personDetailEntity.setActualMny(ComputeUtil.safeAdd((BigDecimal)ComputeUtil.safeSub((BigDecimal)personDetailEntity.getYfSalaryMny(), (BigDecimal[])new BigDecimal[]{personDetailEntity.getPersonEndowmentMny(), personDetailEntity.getPersonUnemploymentMny(), personDetailEntity.getPersonMedicalMny(), personDetailEntity.getPersonHouseMny(), personDetailEntity.getSybxMny()}), (BigDecimal[])new BigDecimal[]{personDetailEntity.getYfmsMny(), personDetailEntity.getYfmscwMny()}));
            personDetailEntity.setAlreadyMny(BigDecimal.ZERO);
            personDetailEntity.setLeftMny(personDetailEntity.getActualMny());
            personDetailList.add(personDetailEntity);
        }
        payrollEntity.setPayrollPersonList(personDetailList);
        List sourceEntityList = this.jspayableSourceService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"id_card", (Collection)jspayableEntity.getJspayableDetailList().stream().map(JspayableDetailEntity::getIdCard).collect(Collectors.toList()))).eq((Object)"period", (Object)jspayableEntity.getMonth())).eq((Object)"company_id", (Object)jspayableEntity.getCompanyId()));
        List payableDetailList = this.payableDetailService.list((Wrapper)new QueryWrapper().in((Object)"id", (Collection)sourceEntityList.stream().map(JspayableSourceEntity::getSourceDetailId).collect(Collectors.toList())));
        Map<Long, List<PayableDetailEntity>> payableDetailMap = payableDetailList.stream().collect(Collectors.groupingBy(PayableDetailEntity::getDetailOrgId));
        Map<Long, List<JspayableDetailEntity>> jsPayableDetailMap = jspayableEntity.getJspayableDetailList().stream().collect(Collectors.groupingBy(JspayableDetailEntity::getDetailOrgId));
        ArrayList<PayrollUnitEntity> unitDetailList = new ArrayList<PayrollUnitEntity>();
        for (Long orgId : payableDetailMap.keySet()) {
            List<PayableDetailEntity> detailList = payableDetailMap.get(orgId);
            PayrollUnitEntity payrollUnitEntity = new PayrollUnitEntity();
            payrollUnitEntity.setId(IdWorker.getId());
            payrollUnitEntity.setPayrollId(payrollEntity.getId());
            payrollUnitEntity.setTaxBillId(taxEntity.getId());
            payrollUnitEntity.setYfgzjsBillId(billId);
            payrollUnitEntity.setGzffOrgId(detailList.get(0).getGzffOrgId());
            payrollUnitEntity.setGzffOrgCode(detailList.get(0).getGzffOrgCode());
            payrollUnitEntity.setGzffOrgName(detailList.get(0).getGzffOrgName());
            payrollUnitEntity.setUnWriteOffMny(detailList.stream().filter(p -> p.getUnWriteOffMny() != null).map(PayableDetailEntity::getUnWriteOffMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            payrollUnitEntity.setWriteOffMny(detailList.stream().filter(p -> p.getWriteOffMny() != null).map(PayableDetailEntity::getWriteOffMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            payrollUnitEntity.setYfjsMny(detailList.stream().filter(p -> p.getYfjsMny() != null).map(PayableDetailEntity::getYfjsMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            payrollUnitEntity.setYfmsMny(detailList.stream().filter(p -> p.getYfmsMny() != null).map(PayableDetailEntity::getYfmsMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            payrollUnitEntity.setJobMny(detailList.stream().filter(p -> p.getJobMny() != null).map(PayableDetailEntity::getJobMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            payrollUnitEntity.setPerformanceMny(detailList.stream().filter(p -> p.getPerformanceMny() != null).map(PayableDetailEntity::getPerformanceMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            payrollUnitEntity.setWorkYearMny(detailList.stream().filter(p -> p.getWorkYearMny() != null).map(PayableDetailEntity::getWorkYearMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            payrollUnitEntity.setWorkTypeMny(detailList.stream().filter(p -> p.getWorkTypeMny() != null).map(PayableDetailEntity::getWorkTypeMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            payrollUnitEntity.setCertificateMny(detailList.stream().filter(p -> p.getCertificateMny() != null).map(PayableDetailEntity::getCertificateMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            payrollUnitEntity.setTravelMny(detailList.stream().filter(p -> p.getTravelMny() != null).map(PayableDetailEntity::getTravelMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            payrollUnitEntity.setTrafficMny(detailList.stream().filter(p -> p.getTrafficMny() != null).map(PayableDetailEntity::getTrafficMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            payrollUnitEntity.setMealMny(detailList.stream().filter(p -> p.getMealMny() != null).map(PayableDetailEntity::getMealMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            payrollUnitEntity.setBenefitMny(detailList.stream().filter(p -> p.getBenefitMny() != null).map(PayableDetailEntity::getBenefitMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            payrollUnitEntity.setHolidayMny(detailList.stream().filter(p -> p.getHolidayMny() != null).map(PayableDetailEntity::getHolidayMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            payrollUnitEntity.setYearEndMny(detailList.stream().filter(p -> p.getYearEndMny() != null).map(PayableDetailEntity::getYearEndMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            payrollUnitEntity.setOvertimeMny(detailList.stream().filter(p -> p.getOvertimeMny() != null).map(PayableDetailEntity::getOvertimeMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            payrollUnitEntity.setAddMny(detailList.stream().filter(p -> p.getAddMny() != null).map(PayableDetailEntity::getAddMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            payrollUnitEntity.setButtonMny(detailList.stream().filter(p -> p.getButtonMny() != null).map(PayableDetailEntity::getButtonMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            payrollUnitEntity.setSalaryMny(detailList.stream().filter(p -> p.getSalaryMny() != null).map(PayableDetailEntity::getSalaryMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            payrollUnitEntity.setYfSalaryMny(detailList.stream().filter(p -> p.getYfSalaryMny() != null).map(PayableDetailEntity::getYfSalaryMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            payrollUnitEntity.setYfmsSalaryMny(detailList.stream().filter(p -> p.getYfmsSalaryMny() != null).map(PayableDetailEntity::getYfmsSalaryMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            if (jsPayableDetailMap.containsKey(orgId)) {
                List<JspayableDetailEntity> jsPayableDetailList = jsPayableDetailMap.get(orgId);
                payrollUnitEntity.setCriticalIllnessMny(jsPayableDetailList.stream().filter(p -> p.getCriticalIllnessMny() != null).map(JspayableDetailEntity::getCriticalIllnessMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                payrollUnitEntity.setPersonEndowmentMny(jsPayableDetailList.stream().filter(p -> p.getPersonEndowmentMny() != null).map(JspayableDetailEntity::getPersonEndowmentMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                payrollUnitEntity.setPersonMedicalMny(jsPayableDetailList.stream().filter(p -> p.getPersonMedicalMny() != null).map(JspayableDetailEntity::getPersonMedicalMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                payrollUnitEntity.setPersonUnemploymentMny(jsPayableDetailList.stream().filter(p -> p.getPersonUnemploymentMny() != null).map(JspayableDetailEntity::getPersonUnemploymentMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                payrollUnitEntity.setPersonHouseMny(jsPayableDetailList.stream().filter(p -> p.getPersonHouseMny() != null).map(JspayableDetailEntity::getPersonHouseMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            }
            payrollUnitEntity.setActualMny(ComputeUtil.safeAdd((BigDecimal)ComputeUtil.safeSub((BigDecimal)payrollUnitEntity.getYfSalaryMny(), (BigDecimal[])new BigDecimal[]{payrollUnitEntity.getPersonHouseMny(), payrollUnitEntity.getCertificateMny()}), (BigDecimal)payrollUnitEntity.getYfmsMny()));
            payrollUnitEntity.setAlreadyMny(BigDecimal.ZERO);
            payrollUnitEntity.setLeftMny(payrollUnitEntity.getActualMny());
            unitDetailList.add(payrollUnitEntity);
        }
        payrollEntity.setPayrollUnitList(unitDetailList);
        if (CollectionUtils.isNotEmpty(personDetailList)) {
            payrollEntity.setPayableSumMny(personDetailList.stream().filter(p -> p.getYfSalaryMny() != null).map(PayrollPersonEntity::getYfSalaryMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            payrollEntity.setActualSumMny(personDetailList.stream().filter(p -> p.getActualMny() != null).map(PayrollPersonEntity::getActualMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            payrollEntity.setAlreadySumMny(BigDecimal.ZERO);
            payrollEntity.setLeftSumMny(payrollEntity.getActualSumMny());
        }
        this.logger.info("\u751f\u6210\u5de5\u8d44\u5355\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)payrollEntity)));
        this.payrollService.saveOrUpdate((Object)payrollEntity, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        JspayableEntity jspayableEntity = (JspayableEntity)((Object)this.jspayableService.selectById(billId));
        TaxEntity taxEntity = (TaxEntity)((Object)this.taxService.getOne((Wrapper)new QueryWrapper().eq((Object)"yfgzjs_bill_id", (Object)jspayableEntity.getId())));
        if (taxEntity.getBillState() == 1 || taxEntity.getBillState() == 3 || taxEntity.getBillState() == 2 || taxEntity.getBillState() == 5) {
            return CommonResponse.error((String)"\u4e2a\u7a0e\u8ba1\u7b97\u5ba1\u6279\u4e2d\u6216\u5df2\u751f\u6548\uff0c\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        PayrollEntity payrollEntity = (PayrollEntity)((Object)this.payrollService.getOne((Wrapper)new QueryWrapper().eq((Object)"yfgzjs_bill_id", (Object)jspayableEntity.getId())));
        if (payrollEntity.getBillState() == 1 || payrollEntity.getBillState() == 3 || payrollEntity.getBillState() == 2 || payrollEntity.getBillState() == 5) {
            return CommonResponse.error((String)"\u5de5\u8d44\u5355\u5ba1\u6279\u4e2d\u6216\u5df2\u751f\u6548\uff0c\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        this.taxService.removeById(taxEntity.getId());
        this.taxModifyService.remove((Wrapper)new QueryWrapper().eq((Object)"tax_bill_id", (Object)taxEntity.getId()));
        this.payrollService.removeById(payrollEntity.getId());
        return CommonResponse.success();
    }
}

