/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.report.controller;

import cn.hutool.core.date.DateTime;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.financeintegration.PMSalary.api.IPMSalarySystemApi;
import com.ejianc.business.report.bean.SalaryListVWEntity;
import com.ejianc.business.report.service.ISalaryListVWService;
import com.ejianc.business.report.vo.ExportBankVO;
import com.ejianc.business.report.vo.SalaryListVWVO;
import com.ejianc.business.salary.service.IAcSetRelateService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"salaryListVW"})
public class SalaryListVWController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IPMSalarySystemApi salarySystemApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private ISalaryListVWService service;
    @Autowired
    private IAcSetRelateService acSetRelateService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SalaryListVWVO> saveOrUpdate(@RequestBody SalaryListVWVO saveOrUpdateVO) {
        SalaryListVWEntity entity = (SalaryListVWEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SalaryListVWEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        SalaryListVWVO vo = (SalaryListVWVO)BeanMapper.map((Object)((Object)entity), SalaryListVWVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SalaryListVWVO> queryDetail(Long id) {
        SalaryListVWEntity entity = (SalaryListVWEntity)((Object)this.service.selectById(id));
        SalaryListVWVO vo = (SalaryListVWVO)BeanMapper.map((Object)((Object)entity), SalaryListVWVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SalaryListVWVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SalaryListVWVO salaryListVWVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SalaryListVWVO>> queryList(@RequestBody QueryParam param) {
        String[] split;
        String month;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("detailEmployeeName");
        fuzzyFields.add("detailEmployeeCode");
        fuzzyFields.add("orgName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        if (param.getParams().containsKey("month")) {
            month = ((Parameter)param.getParams().get("month")).getValue().toString();
            split = month.split(",");
            split[0] = split[0] + "-01";
            split[1] = split[1] + "-01";
            param.getParams().put("month", new Parameter("between", (Object)(split[0] + "," + split[1])));
        } else if (param.getParams().containsKey("period")) {
            month = ((Parameter)param.getParams().get("period")).getValue().toString();
            split = month.split(",");
            split[0] = split[0] + "-01";
            split[1] = split[1] + "-01";
            param.getParams().put("period", new Parameter("between", (Object)(split[0] + "," + split[1])));
        } else {
            return CommonResponse.error((String)"\u8bf7\u5728\u7b5b\u9009\u6761\u4ef6\u4e2d\u9009\u62e9\u65f6\u95f4\uff01");
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SalaryListVWVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("detailEmployeeName");
        fuzzyFields.add("detailEmployeeCode");
        fuzzyFields.add("orgName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SalaryListVW-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelBankExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelBankExport(@RequestBody QueryParam param, HttpServletResponse response) {
        CommonResponse commonResponse;
        param.setPageSize(200);
        if (!param.getParams().containsKey("acCode")) {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            queryParam.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            List acSetRelateEntities = this.acSetRelateService.queryList(queryParam);
            if (CollectionUtils.isNotEmpty((Collection)acSetRelateEntities)) {
                List collect = acSetRelateEntities.stream().map(p -> p.getAcSetCode()).collect(Collectors.toList());
                param.getParams().put("acCode", new Parameter("in", collect));
            }
        }
        if (!(commonResponse = this.salarySystemApi.queryGZList(param)).isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u5de5\u8d44\u660e\u7ec6\u5931\u8d25!");
        }
        JSONObject responseData = (JSONObject)commonResponse.getData();
        HashMap<String, List> beans = new HashMap<String, List>();
        JSONArray records = responseData.getJSONArray("records");
        List exportBankVOS = records.toJavaList(ExportBankVO.class);
        for (int i = 0; i < exportBankVOS.size(); ++i) {
            String formattedDate;
            String bankName = ((ExportBankVO)exportBankVOS.get(i)).getBankName();
            ((ExportBankVO)exportBankVOS.get(i)).setSortNum(Integer.valueOf(i + 1));
            String yearMonth = ((ExportBankVO)exportBankVOS.get(i)).getYearMonth();
            DateTime dateTime = new DateTime(yearMonth, "yyyyMM");
            if (bankName.contains("\u6d66\u4e1c\u53d1\u5c55\u94f6\u884c") || bankName.contains("\u6d66\u53d1\u94f6\u884c")) {
                formattedDate = dateTime.toString("yyyy-MM-dd");
                ((ExportBankVO)exportBankVOS.get(i)).setYearMonth(formattedDate);
                continue;
            }
            formattedDate = dateTime.toString("yyyy/MM/dd");
            ((ExportBankVO)exportBankVOS.get(i)).setYearMonth(formattedDate);
        }
        beans.put("records", exportBankVOS);
        if (ListUtil.isNotEmpty((List)exportBankVOS)) {
            String bankName = ((ExportBankVO)exportBankVOS.get(0)).getBankName();
            this.logger.info("1-----------bankName{}", (Object)bankName);
            this.logger.info("2-----------records{}", (Object)responseData.get((Object)"records").toString());
            if (bankName.contains("\u6d66\u4e1c\u53d1\u5c55\u94f6\u884c") || bankName.contains("\u6d66\u53d1\u94f6\u884c")) {
                ExcelExport.getInstance().export("\u94f6\u4f01\u76f4\u8fde\uff08\u4ee3\u4ed8\uff09-\u6d66\u53d1\u6a21\u7248.xlsx", beans, response);
            }
            if (bankName.contains("\u519c\u4e1a\u94f6\u884c")) {
                ExcelExport.getInstance().export("\u94f6\u4f01\u76f4\u8fde\uff08\u4ee3\u4ed8\uff09-\u519c\u884c\u5de5\u8d44\u6a21\u7248.xlsx", beans, response);
            }
            if (bankName.contains("\u90d1\u5dde\u94f6\u884c")) {
                ExcelExport.getInstance().export("\u94f6\u4f01\u76f4\u8fde\uff08\u4ee3\u4ed8\uff09-\u90d1\u5dde\u94f6\u884c\u6a21\u7248.xlsx", beans, response);
            }
            if (bankName.contains("\u4ea4\u901a\u94f6\u884c")) {
                ExcelExport.getInstance().export("\u7f51\u94f6-\u4ea4\u884c\u4ee3\u53d1\u85aa\u8d44\u6a21\u7248.xlsx", beans, response);
            }
            if (bankName.contains("\u5efa\u8bbe\u94f6\u884c")) {
                ExcelExport.getInstance().export("\u7f51\u94f6-\u5efa\u884c\u5de5\u8d44\u6a21\u677f.xlsx", beans, response);
            }
        }
        ExcelExport.getInstance().export("\u94f6\u4f01\u76f4\u8fde\uff08\u4ee3\u4ed8\uff09-\u90d1\u5dde\u94f6\u884c\u6a21\u7248.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSalaryListVWData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SalaryListVWVO>> refSalaryListVWData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SalaryListVWVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/querySbList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> querySbList(@RequestBody QueryParam param) {
        return this.salarySystemApi.queryList(param);
    }

    @RequestMapping(value={"/queryGzList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryGzList(@RequestBody QueryParam param) {
        if (!param.getParams().containsKey("acCode")) {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            queryParam.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            List acSetRelateEntities = this.acSetRelateService.queryList(queryParam);
            if (CollectionUtils.isNotEmpty((Collection)acSetRelateEntities)) {
                List collect = acSetRelateEntities.stream().map(p -> p.getAcSetCode()).collect(Collectors.toList());
                param.getParams().put("acCode", new Parameter("in", collect));
            }
        }
        return this.salarySystemApi.queryGZList(param);
    }
}

