/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.salary.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.salary.bean.CompanyEntity;
import com.ejianc.business.salary.bean.RosterEntity;
import com.ejianc.business.salary.bean.SocialSecurityChangeSdetailEntity;
import com.ejianc.business.salary.service.ICompanyService;
import com.ejianc.business.salary.service.IRosterService;
import com.ejianc.business.salary.service.ISocialSecurityChangeSdetailService;
import com.ejianc.business.salary.util.DetailIndexExcelReaderZzyj;
import com.ejianc.business.salary.vo.SocialSecurityChangeSdetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"socialSecurityChangeSdetail"})
public class SocialSecurityChangeSdetailController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private ISocialSecurityChangeSdetailService service;
    @Autowired
    private IRosterService rosterService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ICompanyService companyService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SocialSecurityChangeSdetailVO> saveOrUpdate(@RequestBody SocialSecurityChangeSdetailVO saveOrUpdateVO) {
        BillCodeParam billCodeParam;
        CommonResponse billCode;
        SocialSecurityChangeSdetailEntity entity = (SocialSecurityChangeSdetailEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SocialSecurityChangeSdetailEntity.class));
        if (!(entity.getId() != null && entity.getId() != 0L || (billCode = this.billCodeApi.generateBillCode(billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO))).isSuccess())) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        this.service.saveOrUpdate((Object)entity, false);
        SocialSecurityChangeSdetailVO vo = (SocialSecurityChangeSdetailVO)BeanMapper.map((Object)((Object)entity), SocialSecurityChangeSdetailVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SocialSecurityChangeSdetailVO> queryDetail(Long id) {
        SocialSecurityChangeSdetailEntity entity = (SocialSecurityChangeSdetailEntity)((Object)this.service.selectById(id));
        SocialSecurityChangeSdetailVO vo = (SocialSecurityChangeSdetailVO)BeanMapper.map((Object)((Object)entity), SocialSecurityChangeSdetailVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SocialSecurityChangeSdetailVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SocialSecurityChangeSdetailVO socialSecurityChangeSdetailVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SocialSecurityChangeSdetailVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SocialSecurityChangeSdetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SocialSecurityChangeSdetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSocialSecurityChangeSdetailData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SocialSecurityChangeSdetailVO>> refSocialSecurityChangeSdetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SocialSecurityChangeSdetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/downloadInfo"})
    @ResponseBody
    public void downloadMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"SocialSecurityChangeSdetail-import.xlsx", (String)"\u793e\u4fdd\u8c03\u6574\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="companyId", required=true) Long companyId) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<SocialSecurityChangeSdetailVO> successList = new ArrayList<SocialSecurityChangeSdetailVO>();
        ArrayList<SocialSecurityChangeSdetailVO> errorList = new ArrayList<SocialSecurityChangeSdetailVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List<List<String>> result = DetailIndexExcelReaderZzyj.readExcel(mf);
        if (result != null && result.size() > 0) {
            ArrayList<String> idCardList = new ArrayList<String>();
            for (int i = 0; i < result.size(); ++i) {
                List<String> datas = result.get(i);
                idCardList.add(datas.get(1).trim());
            }
            Map<Object, Object> map = new HashMap();
            LambdaQueryWrapper lambdaQueryWrapper1 = new LambdaQueryWrapper();
            lambdaQueryWrapper1.in(RosterEntity::getIdCard, idCardList);
            lambdaQueryWrapper1.isNotNull(RosterEntity::getIdCard);
            List rosterEntityList = this.rosterService.list((Wrapper)lambdaQueryWrapper1);
            map = rosterEntityList.stream().collect(Collectors.toMap(p -> p.getIdCard(), Function.identity()));
            this.logger.info("\u4eba\u5458map: {}", (Object)JSONObject.toJSONString(map));
            CompanyEntity companyEntity = (CompanyEntity)((Object)this.companyService.selectById(companyId));
            HashMap<String, SocialSecurityChangeSdetailVO> stringSocialSecurityChangeSdetailVOHashMap = new HashMap<String, SocialSecurityChangeSdetailVO>();
            for (int i = 0; i < result.size(); ++i) {
                SocialSecurityChangeSdetailVO detailVO;
                List<String> datas = result.get(i);
                String idCard = datas.get(1).trim();
                if (stringSocialSecurityChangeSdetailVOHashMap.containsKey(idCard)) {
                    detailVO = (SocialSecurityChangeSdetailVO)stringSocialSecurityChangeSdetailVOHashMap.get(idCard);
                    try {
                        this.checkSbData(detailVO, errorList, datas);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg(e.getMessage());
                        errorList.add(detailVO);
                    }
                    continue;
                }
                detailVO = new SocialSecurityChangeSdetailVO();
                detailVO.setId(Long.valueOf(IdWorker.getId()));
                try {
                    detailVO.setIdCard(idCard);
                    if (ObjectUtils.isEmpty((Object)map.get(idCard))) {
                        throw new Exception("\u6ca1\u6709\u8be5\u4eba\u5458\u4fe1\u606f\uff01");
                    }
                    RosterEntity rosterEntity = (RosterEntity)((Object)map.get(idCard));
                    String userName = datas.get(0).trim();
                    this.logger.info("-----------------------{}", (Object)userName);
                    if (userName == null || !userName.equals(rosterEntity.getUserName())) {
                        throw new Exception("\u4eba\u5458\u8eab\u4efd\u8bc1\u53f7\u3001\u59d3\u540d\u4e0d\u5339\u914d\uff01");
                    }
                    detailVO.setUserName(userName);
                    detailVO.setUserId(rosterEntity.getUserId());
                    detailVO.setUserCode(rosterEntity.getUserCode());
                    if (!companyEntity.getHrCompanyName().equals(rosterEntity.getSocialDepartmentName())) {
                        throw new Exception("\u4eba\u5458\u793e\u4fdd\u7f34\u7eb3\u5355\u4f4d\u4e0d\u4e00\u81f4\uff01" + rosterEntity.getSocialDepartmentName());
                    }
                }
                catch (Exception e) {
                    detailVO.setErrorMsg(e.getMessage());
                    errorList.add(detailVO);
                    continue;
                }
                try {
                    this.checkSbData(detailVO, errorList, datas);
                    stringSocialSecurityChangeSdetailVOHashMap.put(idCard, detailVO);
                    continue;
                }
                catch (Exception e) {
                    detailVO.setErrorMsg(e.getMessage());
                    errorList.add(detailVO);
                }
            }
            Collection values = stringSocialSecurityChangeSdetailVOHashMap.values();
            for (SocialSecurityChangeSdetailVO value : values) {
                value.setRowState("add");
                if (value.getPersonAnnuityMoney() == null) {
                    value.setPersonAnnuityMoney(new BigDecimal(0));
                }
                if (value.getPersonAnnuityMoneyPercent() == null) {
                    value.setPersonAnnuityMoneyPercent(new BigDecimal(0));
                }
                if (value.getCompanyAnnuityMoney() == null) {
                    value.setCompanyAnnuityMoney(new BigDecimal(0));
                }
                if (value.getCompanyAnnuityMoneyPercent() == null) {
                    value.setCompanyAnnuityMoneyPercent(new BigDecimal(0));
                }
                if (value.getPersonMedicalMoney() == null) {
                    value.setPersonMedicalMoney(new BigDecimal(0));
                }
                if (value.getPersonMedicalMoneyPercent() == null) {
                    value.setPersonMedicalMoneyPercent(new BigDecimal(0));
                }
                if (value.getCompanyMedicalMoney() == null) {
                    value.setCompanyMedicalMoney(new BigDecimal(0));
                }
                if (value.getCompanyMedicalMoneyPercent() == null) {
                    value.setCompanyMedicalMoneyPercent(new BigDecimal(0));
                }
                if (value.getPersonUnemploymentMoney() == null) {
                    value.setPersonUnemploymentMoney(new BigDecimal(0));
                }
                if (value.getPersonUnemploymentMoneyPercent() == null) {
                    value.setPersonUnemploymentMoneyPercent(new BigDecimal(0));
                }
                if (value.getCompanyUnemploymentMoney() == null) {
                    value.setCompanyUnemploymentMoney(new BigDecimal(0));
                }
                if (value.getCompanyUnemploymentMoneyPercent() == null) {
                    value.setCompanyUnemploymentMoneyPercent(new BigDecimal(0));
                }
                if (value.getCompanyChildbirthMoney() == null) {
                    value.setCompanyChildbirthMoney(new BigDecimal(0));
                }
                if (value.getCompanyChildbirthMoneyPercent() == null) {
                    value.setCompanyChildbirthMoneyPercent(new BigDecimal(0));
                }
                if (value.getCompanyInjuryMoney() == null) {
                    value.setCompanyInjuryMoney(new BigDecimal(0));
                }
                if (value.getCompanyInjuryMoneyPercent() == null) {
                    value.setCompanyInjuryMoneyPercent(new BigDecimal(0));
                }
                if (value.getCriticalIllnessMny() == null) {
                    value.setCriticalIllnessMny(new BigDecimal(0));
                }
                successList.add(value);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SocialSecurityChangeSdetailVO checkSbData(SocialSecurityChangeSdetailVO detailVO, List<SocialSecurityChangeSdetailVO> errorList, List<String> datas) throws Exception {
        String paymentBase = datas.get(4);
        if (!StringUtils.isNotBlank((CharSequence)paymentBase)) {
            throw new Exception("\u7f34\u8d39\u57fa\u6570\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        detailVO.setPaymentBase(new BigDecimal(paymentBase));
        String money = datas.get(5);
        if (!StringUtils.isNotBlank((CharSequence)money)) throw new Exception("\u7f34\u8d39\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String xzlx = datas.get(2);
        if (!StringUtils.isNotBlank((CharSequence)xzlx)) throw new Exception("\u9669\u79cd\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String jjly = datas.get(3);
        if (!StringUtils.isNotBlank((CharSequence)jjly)) throw new Exception("\u57fa\u91d1\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if ("\u5de5\u4f24\u4fdd\u9669".equals(xzlx)) {
            if (!"\u5355\u4f4d\u7f34\u7eb3".equals(jjly)) throw new Exception("\u57fa\u91d1\u6765\u6e90\u5f02\u5e38\uff01" + jjly);
            if (detailVO.getCompanyInjuryMoney() != null) {
                detailVO.setCompanyInjuryMoney(detailVO.getCompanyInjuryMoney().add(new BigDecimal(money)));
                return detailVO;
            } else {
                detailVO.setCompanyInjuryMoney(new BigDecimal(money));
            }
            return detailVO;
        } else if ("\u751f\u80b2\u4fdd\u9669".equals(xzlx)) {
            if (!"\u5355\u4f4d\u7f34\u7eb3".equals(jjly)) throw new Exception("\u57fa\u91d1\u6765\u6e90\u5f02\u5e38\uff01" + jjly);
            if (detailVO.getCompanyChildbirthMoney() != null) {
                detailVO.setCompanyChildbirthMoney(detailVO.getCompanyChildbirthMoney().add(new BigDecimal(money)));
                return detailVO;
            } else {
                detailVO.setCompanyChildbirthMoney(new BigDecimal(money));
            }
            return detailVO;
        } else if ("\u5931\u4e1a\u4fdd\u9669".equals(xzlx)) {
            if ("\u5355\u4f4d\u7f34\u7eb3".equals(jjly)) {
                if (detailVO.getCompanyUnemploymentMoney() != null) {
                    detailVO.setCompanyUnemploymentMoney(detailVO.getCompanyUnemploymentMoney().add(new BigDecimal(money)));
                    return detailVO;
                } else {
                    detailVO.setCompanyUnemploymentMoney(new BigDecimal(money));
                }
                return detailVO;
            } else {
                if (!"\u4e2a\u4eba\u7f34\u7eb3(\u5355\u4f4d\u4ee3\u6263)".equals(jjly)) throw new Exception("\u57fa\u91d1\u6765\u6e90\u5f02\u5e38\uff01" + jjly);
                if (detailVO.getPersonUnemploymentMoney() != null) {
                    detailVO.setPersonUnemploymentMoney(detailVO.getPersonUnemploymentMoney().add(new BigDecimal(money)));
                    return detailVO;
                } else {
                    detailVO.setPersonUnemploymentMoney(new BigDecimal(money));
                }
            }
            return detailVO;
        } else if ("\u4f01\u4e1a\u57fa\u672c\u517b\u8001\u4fdd\u9669".equals(xzlx)) {
            if ("\u5355\u4f4d\u7f34\u7eb3".equals(jjly)) {
                if (detailVO.getCompanyAnnuityMoney() != null) {
                    detailVO.setCompanyAnnuityMoney(detailVO.getCompanyAnnuityMoney().add(new BigDecimal(money)));
                    return detailVO;
                } else {
                    detailVO.setCompanyAnnuityMoney(new BigDecimal(money));
                }
                return detailVO;
            } else {
                if (!"\u4e2a\u4eba\u7f34\u7eb3(\u5355\u4f4d\u4ee3\u6263)".equals(jjly)) throw new Exception("\u57fa\u91d1\u6765\u6e90\u5f02\u5e38\uff01" + jjly);
                if (detailVO.getPersonAnnuityMoney() != null) {
                    detailVO.setPersonAnnuityMoney(detailVO.getPersonAnnuityMoney().add(new BigDecimal(money)));
                    return detailVO;
                } else {
                    detailVO.setPersonAnnuityMoney(new BigDecimal(money));
                }
            }
            return detailVO;
        } else if ("\u57fa\u672c\u533b\u7597\u4fdd\u9669".equals(xzlx)) {
            if ("\u5355\u4f4d\u7f34\u7eb3".equals(jjly)) {
                if (detailVO.getCompanyMedicalMoney() != null) {
                    detailVO.setCompanyMedicalMoney(detailVO.getCompanyMedicalMoney().add(new BigDecimal(money)));
                    return detailVO;
                } else {
                    detailVO.setCompanyMedicalMoney(new BigDecimal(money));
                }
                return detailVO;
            } else {
                if (!"\u4e2a\u4eba\u7f34\u7eb3(\u5355\u4f4d\u4ee3\u6263)".equals(jjly)) throw new Exception("\u57fa\u91d1\u6765\u6e90\u5f02\u5e38\uff01" + jjly);
                if (detailVO.getPersonMedicalMoney() != null) {
                    detailVO.setPersonMedicalMoney(detailVO.getPersonMedicalMoney().add(new BigDecimal(money)));
                    return detailVO;
                } else {
                    detailVO.setPersonMedicalMoney(new BigDecimal(money));
                }
            }
            return detailVO;
        } else {
            if (!"\u5546\u4e1a\u8865\u5145\u533b\u7597\u4fdd\u9669".equals(xzlx)) return detailVO;
            if (!"\u4e2a\u4eba\u7f34\u7eb3(\u5355\u4f4d\u4ee3\u6263)".equals(jjly)) throw new Exception("\u57fa\u91d1\u6765\u6e90\u5f02\u5e38\uff01" + jjly);
            if (detailVO.getCriticalIllnessMny() != null) {
                detailVO.setCriticalIllnessMny(detailVO.getCriticalIllnessMny().add(new BigDecimal(money)));
                return detailVO;
            } else {
                detailVO.setCriticalIllnessMny(new BigDecimal(money));
            }
        }
        return detailVO;
    }
}

