/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.salary.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.financeintegration.PMSalary.api.IPMSalarySystemApi;
import com.ejianc.business.financeintegration.PMSalary.vo.PMGzDetailVO;
import com.ejianc.business.financeintegration.PMSalary.vo.PMGzVO;
import com.ejianc.business.salary.bean.PushcwEntity;
import com.ejianc.business.salary.bean.ResendEntity;
import com.ejianc.business.salary.service.IPushcwService;
import com.ejianc.business.salary.service.IResendService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="resend")
public class ResendBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IResendService resendService;
    @Autowired
    private IPushcwService pushcwService;
    @Autowired
    private IPMSalarySystemApi salarySystemApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse<PMGzVO> res;
        ResendEntity resendEntity = (ResendEntity)((Object)this.resendService.selectById(billId));
        List<PushcwEntity> actualMny = this.resendService.changeToPushcw(resendEntity.getResendDetailList());
        if (CollectionUtils.isNotEmpty(actualMny)) {
            BigDecimal actualSum = BigDecimal.ZERO;
            for (PushcwEntity pushcwEntity : actualMny) {
                if (StringUtils.isBlank((CharSequence)pushcwEntity.getBankName()) || StringUtils.isBlank((CharSequence)pushcwEntity.getBankAccount())) {
                    return CommonResponse.error((String)("\u94f6\u884c\u4fe1\u606f\u4e3a\u7a7a\uff01\u4eba\u5458\u540d\u79f0\uff1a" + pushcwEntity.getDetailEmployeeName()));
                }
                if (pushcwEntity.getActual().compareTo(BigDecimal.ZERO) < 0) {
                    return CommonResponse.error((String)("\u5b9e\u53d1\u5c0f\u4e8e0\uff01\u4eba\u5458\u540d\u79f0\uff1a" + pushcwEntity.getDetailEmployeeName()));
                }
                pushcwEntity.setMonth(resendEntity.getMonth());
                pushcwEntity.setJspayableDetailId(pushcwEntity.getId());
                pushcwEntity.setSourceId(resendEntity.getId());
                pushcwEntity.setAcSet(resendEntity.getAcSet());
                pushcwEntity.setAcSetCode(resendEntity.getAcSetCode());
                pushcwEntity.setCompanyId(resendEntity.getCompanyId());
                pushcwEntity.setCompanyName(resendEntity.getCompanyName());
                SimpleDateFormat simpleDateFormat1 = new SimpleDateFormat("yyyyMMddHHmmss");
                String today = simpleDateFormat1.format(resendEntity.getCreateTime());
                pushcwEntity.setCode(resendEntity.getCompanyId() + "-" + today + "-" + resendEntity.getAcSetCode());
                pushcwEntity.setId(null);
                pushcwEntity.setSourceType("\u91cd\u53d1\u5355");
                pushcwEntity.setPayState("0");
                actualSum = actualSum.add(pushcwEntity.getActual());
            }
            if (actualSum.compareTo(resendEntity.getActualSumMny()) != 0) {
                return CommonResponse.error((String)("\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff01\u91cd\u53d1\u5355\u63a8\u9001\u5230\u8d22\u52a1\u7684\u5b9e\u53d1\u91d1\u989d\u9519\u8bef\uff0c\u91d1\u989d\u4e3a\uff1a" + actualSum));
            }
            this.pushcwService.saveOrUpdateBatch(actualMny);
        }
        if (!(res = this.salaryTakeEffect(billId)).isSuccess()) {
            this.logger.error("\u8c03\u7528PM\u8d22\u52a1\u6a21\u5757\u751f\u6548\u63a5\u53e3\u5931\u8d25\uff01message-{}", (Object)res.getMsg());
            return CommonResponse.error((String)"\u8c03\u7528PM\u8d22\u52a1\u6a21\u5757\u751f\u6548\u63a5\u53e3\u5931\u8d25");
        }
        return CommonResponse.success();
    }

    private CommonResponse<PMGzVO> salaryTakeEffect(Long resendId) {
        this.logger.info("\u8c03\u7528\u8d22\u52a1\u7684\u751f\u6548\u63a5\u53e3---\u91cd\u53d1\u5355ID-{}", (Object)resendId);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("sourceId", new Parameter("eq", (Object)resendId));
        List acActualMny = this.pushcwService.queryList(queryParam);
        if (CollectionUtils.isEmpty((Collection)acActualMny)) {
            this.logger.error("\u6839\u636e\u91cd\u53d1\u5355ID-{}\uff0c\u67e5\u8be2\u4e0d\u5230\u5de5\u8d44\u6570\u636e\uff0c\u65e0\u6cd5\u8c03\u7528\u751f\u6548\u63a5\u53e3", (Object)resendId);
            return CommonResponse.error((String)("\u6839\u636e\u91cd\u53d1\u5355ID-\u3010" + resendId + "\u3011\u67e5\u8be2\u4e0d\u5230\u5de5\u8d44\u652f\u4ed8\u7533\u8bf7\u6570\u636e\uff0c\u65e0\u6cd5\u8c03\u7528\u751f\u6548\u63a5\u53e3"));
        }
        BigDecimal reduce = acActualMny.stream().map(PushcwEntity::getActual).reduce(BigDecimal.ZERO, BigDecimal::add);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
        ArrayList<PMGzVO> pmGzVOS = new ArrayList<PMGzVO>();
        PMGzVO pmSalaryPayApplyVO = new PMGzVO();
        pmSalaryPayApplyVO.setId(IdWorker.getId() + "");
        pmSalaryPayApplyVO.setAcCode(((PushcwEntity)((Object)acActualMny.get(0))).getAcSetCode());
        pmSalaryPayApplyVO.setAcName(((PushcwEntity)((Object)acActualMny.get(0))).getAcSet());
        pmSalaryPayApplyVO.setYearMonth(sdf.format(((PushcwEntity)((Object)acActualMny.get(0))).getMonth()));
        pmSalaryPayApplyVO.setPmBillId(((PushcwEntity)((Object)acActualMny.get(0))).getCode());
        pmSalaryPayApplyVO.setActualMny(reduce);
        pmSalaryPayApplyVO.setQuoteFlag("N");
        pmGzVOS.add(pmSalaryPayApplyVO);
        ArrayList<PMGzDetailVO> pmGzDetailVOS = new ArrayList<PMGzDetailVO>();
        for (PushcwEntity pushcwEntity : acActualMny) {
            PMGzDetailVO pmApplyDetailVO = new PMGzDetailVO();
            pmApplyDetailVO.setId(IdWorker.getId() + "");
            pmApplyDetailVO.setName(pushcwEntity.getDetailEmployeeName());
            pmApplyDetailVO.setIdCard(pushcwEntity.getIdCard());
            pmApplyDetailVO.setBankName(pushcwEntity.getBankName());
            pmApplyDetailVO.setBankCount(pushcwEntity.getBankAccount());
            pmApplyDetailVO.setBankAddress(pushcwEntity.getBankAddress());
            pmApplyDetailVO.setPmBillId(pushcwEntity.getCode());
            pmApplyDetailVO.setActualMny(pushcwEntity.getActual());
            pmApplyDetailVO.setState("0");
            pmGzDetailVOS.add(pmApplyDetailVO);
        }
        ((PMGzVO)pmGzVOS.get(0)).setDetailList(pmGzDetailVOS);
        this.logger.info("\u5f00\u59cb\u8c03\u7528PM\u5de5\u8d44\u652f\u4ed8\u7533\u8bf7\u751f\u6548\u63a5\u53e3\uff0c\u63a5\u53e3\u53c2\u6570VO-{}", (Object)JSONObject.toJSONString(pmGzVOS));
        CommonResponse res = this.salarySystemApi.salaryTakeEffect(pmGzVOS);
        this.logger.info("\u8c03\u7528PM\u8d44\u91d1\u7684\u751f\u6548\u63a5\u53e3----SalaryPayApplyBpmServiceImpl\u7c7b---salaryTakeEffect\u65b9\u6cd5---end\uff0c\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c-{}", (Object)JSONObject.toJSONString((Object)res, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        if (!res.isSuccess()) {
            return CommonResponse.error((String)("\u5de5\u8d44\u4fe1\u606f\u63a8\u9001\u4e2d\u95f4\u8868\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + res.getMsg()));
        }
        return res;
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        ResendEntity resendEntity = (ResendEntity)((Object)this.resendService.selectById(billId));
        if ((BillStateEnum.COMMITED_STATE.getBillStateCode().equals(resendEntity.getBillState()) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(resendEntity.getBillState())) && null != resendEntity) {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("sourceId", new Parameter("eq", (Object)billId));
            List acActualMny = this.pushcwService.queryList(queryParam);
            if (CollectionUtils.isEmpty((Collection)acActualMny)) {
                this.logger.error("\u6839\u636e\u91cd\u53d1\u5355ID-{}\uff0c\u67e5\u8be2\u4e0d\u5230\u5de5\u8d44\u6570\u636e\uff0c\u65e0\u6cd5\u8c03\u7528\u751f\u6548\u63a5\u53e3", (Object)billId);
                return CommonResponse.error((String)("\u6839\u636e\u91cd\u53d1\u5355ID-\u3010" + billId + "\u3011\u67e5\u8be2\u4e0d\u5230\u5de5\u8d44\u652f\u4ed8\u7533\u8bf7\u6570\u636e\uff0c\u65e0\u6cd5\u8c03\u7528\u751f\u6548\u63a5\u53e3"));
            }
            PMGzVO pmSalaryPayApplyVO = new PMGzVO();
            pmSalaryPayApplyVO.setId(IdWorker.getId() + "");
            pmSalaryPayApplyVO.setPmBillId(((PushcwEntity)((Object)acActualMny.get(0))).getCode());
            CommonResponse res = this.salarySystemApi.salaryAbandonOrClose(pmSalaryPayApplyVO);
            this.logger.info("\u8c03\u7528PM\u5de5\u8d44\u652f\u4ed8\u7684\u5f03\u5ba1\u63a5\u53e3---ejc-profinance\u9879\u76ee---bpmBackCheck\u65b9\u6cd5---end\uff0c\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c-{}", (Object)JSONObject.toJSONString((Object)res, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
            if (!res.isSuccess()) {
                return CommonResponse.error((String)("\u5de5\u8d44\u91cd\u53d1\u67e5\u8be2\u8d22\u52a1\u7cfb\u7edf\u4e2d\u95f4\u8868\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + res.getMsg()));
            }
            PMGzVO resultVO = (PMGzVO)res.getData();
            if (null != resultVO) {
                if ("Y".equals(resultVO.getQuoteFlag())) {
                    return CommonResponse.error((String)"\u8be5\u7533\u8bf7\u5355\u5df2\u7ecf\u88ab\u8d22\u52a1\u7cfb\u7edf\u5f15\u7528\uff0c\u4e0d\u80fd\u64a4\u56de/\u5f03\u5ba1");
                }
                this.pushcwService.remove((Wrapper)new QueryWrapper().eq((Object)"source_id", (Object)billId));
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

