/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.salary.service.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.financeintegration.PMSalary.vo.PMGzDetailVO;
import com.ejianc.business.salary.bean.PushcwEntity;
import com.ejianc.business.salary.bean.ResendDetailEntity;
import com.ejianc.business.salary.bean.ResendEntity;
import com.ejianc.business.salary.mapper.ResendMapper;
import com.ejianc.business.salary.service.IPayrollService;
import com.ejianc.business.salary.service.IPushcwService;
import com.ejianc.business.salary.service.IResendDetailService;
import com.ejianc.business.salary.service.IResendService;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="resendService")
public class ResendServiceImpl
extends BaseServiceImpl<ResendMapper, ResendEntity>
implements IResendService {
    @Autowired
    private IPushcwService pushcwService;
    @Autowired
    private IResendDetailService resendDetailService;
    @Autowired
    private IPayrollService payrollService;

    @Override
    public List<PushcwEntity> changeToPushcw(List<ResendDetailEntity> resendDetailList) {
        if (CollectionUtils.isNotEmpty(resendDetailList)) {
            ArrayList<PushcwEntity> pushcwEntities = new ArrayList<PushcwEntity>();
            for (ResendDetailEntity resendDetailEntity : resendDetailList) {
                PushcwEntity pushcwEntity = new PushcwEntity();
                pushcwEntity.setId(resendDetailEntity.getId());
                pushcwEntity.setDetailEmployeeName(resendDetailEntity.getNewName());
                pushcwEntity.setSourceDetailId(resendDetailEntity.getId());
                pushcwEntity.setIdCard(resendDetailEntity.getNewIdCard());
                pushcwEntity.setActual(resendDetailEntity.getNewActualMny());
                pushcwEntity.setBankName(resendDetailEntity.getNewBankName());
                pushcwEntity.setBankAccount(resendDetailEntity.getNewBankCount());
                pushcwEntity.setBankAddress(resendDetailEntity.getNewBankAddress());
                pushcwEntities.add(pushcwEntity);
            }
            return pushcwEntities;
        }
        return null;
    }

    @Override
    public void changePayState(String companyIdAndMonth) {
        QueryParam param = new QueryParam();
        param.getParams().put("code", new Parameter("like", (Object)companyIdAndMonth));
        List pushcwEntities = this.pushcwService.queryList(param);
        if (CollectionUtils.isNotEmpty((Collection)pushcwEntities)) {
            Long pid = null;
            ArrayList<ResendDetailEntity> resendDetailEntities = new ArrayList<ResendDetailEntity>();
            ArrayList<PMGzDetailVO> resultList = new ArrayList<PMGzDetailVO>();
            for (PushcwEntity pushcwEntity : pushcwEntities) {
                PMGzDetailVO pmGzDetailVO = new PMGzDetailVO();
                ResendDetailEntity resendDetailEntity = (ResendDetailEntity)((Object)this.resendDetailService.selectById(pushcwEntity.getSourceDetailId()));
                resendDetailEntity.setNewAlreadyMny(pushcwEntity.getAlreadyMny());
                resendDetailEntity.setNewState(pushcwEntity.getPayState());
                pmGzDetailVO.setPmBillId(resendDetailEntity.getOldPmbillid());
                pmGzDetailVO.setIdCard(resendDetailEntity.getOldIdCard());
                pmGzDetailVO.setActualMny(pushcwEntity.getAlreadyMny());
                pmGzDetailVO.setState(pushcwEntity.getPayState());
                resendDetailEntities.add(resendDetailEntity);
                resultList.add(pmGzDetailVO);
                pid = resendDetailEntity.getPid();
            }
            this.resendDetailService.saveOrUpdateBatch(resendDetailEntities);
            this.payrollService.updateActualMnyByResultList(resultList);
            ResendEntity entity = (ResendEntity)((Object)this.selectById(pid));
            BigDecimal newAlreadyMny = entity.getResendDetailList().stream().map(ResendDetailEntity::getNewAlreadyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            entity.setAlreadySumMny(newAlreadyMny);
            entity.setLeftSumMny(entity.getActualSumMny().subtract(newAlreadyMny));
            this.saveOrUpdate((Object)entity, false);
        }
    }
}

