/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.salary.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.desktop.api.IIdmUserApi;
import com.ejianc.business.desktop.api.ISalaryReportApi;
import com.ejianc.business.desktop.vo.idmUser.SalaryUserVO;
import com.ejianc.business.hr.api.IBaseUserApi;
import com.ejianc.business.hr.vo.salarySystem.SalaryUserDataVO;
import com.ejianc.business.salary.bean.CompanyEntity;
import com.ejianc.business.salary.bean.PayableDetailEntity;
import com.ejianc.business.salary.bean.RosterEntity;
import com.ejianc.business.salary.bean.RosterRecordEntity;
import com.ejianc.business.salary.mapper.RosterMapper;
import com.ejianc.business.salary.service.ICompanyService;
import com.ejianc.business.salary.service.IPayableDetailService;
import com.ejianc.business.salary.service.IPayrollPersonService;
import com.ejianc.business.salary.service.IRosterAccumulationFundService;
import com.ejianc.business.salary.service.IRosterAttendanceService;
import com.ejianc.business.salary.service.IRosterJobService;
import com.ejianc.business.salary.service.IRosterRecordService;
import com.ejianc.business.salary.service.IRosterService;
import com.ejianc.business.salary.service.IRosterSocialSecurityService;
import com.ejianc.business.salary.service.IRosterTransferService;
import com.ejianc.business.salary.util.DetailIndexExcelReaderZzyj;
import com.ejianc.business.salary.vo.PayableDetailVO;
import com.ejianc.business.salary.vo.PayrollPersonVO;
import com.ejianc.business.salary.vo.RosterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IBankApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BankVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"roster"})
public class RosterController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IRosterService service;
    @Autowired
    private IRosterJobService jobService;
    @Autowired
    private IRosterTransferService transferService;
    @Autowired
    private IRosterSocialSecurityService socialSecurityService;
    @Autowired
    private IRosterAccumulationFundService accumulationFundService;
    @Autowired
    private IRosterAttendanceService attendanceService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IRosterRecordService recordService;
    @Autowired
    private IIdmUserApi idmUserApi;
    @Autowired
    private IBaseUserApi baseUserApi;
    @Autowired
    private IBankApi bankApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ICompanyService companyService;
    @Autowired
    private IPayrollPersonService payrollPersonService;
    @Autowired
    private ISalaryReportApi salaryReportApi;
    @Autowired
    private IPayableDetailService payableDetailService;
    @Autowired
    private RosterMapper mapper;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<RosterVO> saveOrUpdate(@RequestBody RosterVO saveOrUpdateVO) {
        BillCodeParam billCodeParam;
        CommonResponse billCode;
        QueryParam queryParam;
        List companyEntities;
        Object companyOrgIds;
        RosterEntity entity = (RosterEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, RosterEntity.class));
        if (entity.getSocialCompanyId() != null && !(companyOrgIds = (companyEntities = this.companyService.queryList(queryParam = new QueryParam())).stream().map(companyEntity -> companyEntity.getOrgId()).collect(Collectors.toList())).contains(entity.getSocialCompanyId())) {
            throw new BusinessException("\u793e\u4fdd\u627f\u62c5\u516c\u53f8 \u8bf7\u9009\u62e9 \u72ec\u7acb\u5f00\u6237\u7684\u516c\u53f8\u6240\u5728\u7ec4\u7ec7\uff01");
        }
        if (!(entity.getId() != null && entity.getId() != 0L || (billCode = this.billCodeApi.generateBillCode(billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO))).isSuccess())) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        List<PayableDetailEntity> upSalary = this.service.isUpSalary(entity.getIdCard());
        if (CollectionUtils.isNotEmpty(upSalary)) {
            String ids = "";
            for (PayableDetailEntity payableDetailEntity : upSalary) {
                ids = ids + payableDetailEntity.getPayableId() + ",";
            }
            throw new BusinessException("\u672c\u5468\u671f\u5185\uff0c\u6b64\u4eba\u5df2\u4e0a\u4f20\u8fc7\u5de5\u8d44\u3002\u8bf7\u5220\u9664\u5df2\u4e0a\u4f20\u7684\u5de5\u8d44\u5355\u540e\u5728\u4fee\u6539\uff01" + ids);
        }
        this.service.saveOrUpdate((Object)entity, false);
        RosterVO vo = (RosterVO)BeanMapper.map((Object)((Object)entity), RosterVO.class);
        UserContext userContext = this.sessionManager.getUserContext();
        RosterRecordEntity map = (RosterRecordEntity)((Object)BeanMapper.map((Object)((Object)entity), RosterRecordEntity.class));
        map.setId(null);
        map.setUpdateUserName(userContext.getUserName());
        map.setUpdateTime(new Date());
        this.recordService.saveOrUpdate((Object)map);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/updateBankInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> updateBankInfo(@RequestBody RosterVO saveOrUpdateVO) {
        RosterEntity entity = (RosterEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, RosterEntity.class));
        RosterEntity rosterEntity = (RosterEntity)((Object)this.service.selectById(entity.getId()));
        rosterEntity.setBankId(entity.getBankId());
        rosterEntity.setBankCode(entity.getBankCode());
        rosterEntity.setBankName(entity.getBankName());
        rosterEntity.setBankAccount(entity.getBankAccount());
        rosterEntity.setBankAddress(entity.getBankAddress());
        this.service.saveOrUpdate((Object)rosterEntity, false);
        return CommonResponse.success((String)"\u4fee\u6539\u94f6\u884c\u8d26\u6237\u76f8\u5173\u4fe1\u606f\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RosterVO> queryDetail(Long id) {
        RosterEntity entity = (RosterEntity)((Object)this.service.selectById(id));
        QueryParam param = new QueryParam();
        param.getParams().put("idCard", new Parameter("eq", (Object)entity.getIdCard()));
        entity.setRosterJobList(this.jobService.queryList(param));
        entity.setRosterSocialSecurityList(this.socialSecurityService.queryList(param));
        entity.setRosterAccumulationFundList(this.accumulationFundService.queryList(param));
        entity.setRosterAttendanceList(this.attendanceService.queryList(param));
        entity.setRosterTransferList(this.transferService.queryList(param));
        RosterVO vo = (RosterVO)BeanMapper.map((Object)((Object)entity), RosterVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RosterVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (RosterVO rosterVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<RosterVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("userCode");
        fuzzyFields.add("userName");
        fuzzyFields.add("orgName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("hrState", new Parameter("eq", (Object)1));
        List collect1 = ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(OrgVO::getCode).collect(Collectors.toList());
        String join = String.join((CharSequence)"','", collect1);
        param.getParams().put("", new Parameter("sql", (Object)("(org_code in ('" + join + "') or id_card in (SELECT id_card FROM `ejc_salary_roster_job` where valid_flag = '\u4efb' and department_code in ('" + join + "')))")));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RosterVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("userCode");
        fuzzyFields.add("userName");
        fuzzyFields.add("orgName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("hrState", new Parameter("eq", (Object)1));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List collect1 = ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(OrgVO::getCode).collect(Collectors.toList());
        String join = String.join((CharSequence)"','", collect1);
        param.getParams().put("", new Parameter("sql", (Object)("(org_code in ('" + join + "') or id_card in (SELECT id_card FROM `ejc_salary_roster_job` where valid_flag = '\u4efb' and department_code in ('" + join + "')))")));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Roster-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refRosterData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<RosterVO>> refRosterData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("userCode");
        fuzzyFields.add("userName");
        fuzzyFields.add("orgName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RosterVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/pmUserSync"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<JSONObject>> pmUserSync(HttpServletRequest request) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        SimpleDateFormat simpleDateFormat1 = new SimpleDateFormat("yyyyMMdd");
        String today = simpleDateFormat1.format(calendar.getTime());
        calendar.add(5, -1);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String format = simpleDateFormat.format(calendar.getTime());
        CommonResponse listCommonResponse = this.idmUserApi.syncUserDataByTime(format);
        if (listCommonResponse.getCode() == 0) {
            List data = (List)listCommonResponse.getData();
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                int i = 1;
                for (SalaryUserVO datum : data) {
                    RosterEntity rosterEntity;
                    ++i;
                    QueryParam param = new QueryParam();
                    param.getParams().put("idCard", new Parameter("eq", (Object)datum.getIdCard()));
                    List rosterEntities = this.service.queryList(param);
                    if (rosterEntities != null && rosterEntities.size() > 0) {
                        this.logger.info("\u6570\u636e\u89e3\u6790\u5f00\u53d1---\u6267\u884c\u4fee\u6539---,{}", (Object)i);
                        rosterEntity = (RosterEntity)((Object)rosterEntities.get(0));
                        rosterEntity.setUserId(datum.getId());
                        rosterEntity.setUserName(datum.getUserName());
                        rosterEntity.setUserCode(datum.getUserCode());
                        rosterEntity.setMobilePhone(datum.getUserMobile());
                        rosterEntity.setEmployeeCode(datum.getEmployeeCode());
                        rosterEntity.setOrgId(datum.getOrgId());
                        rosterEntity.setOrgCode(datum.getOrgCode());
                        rosterEntity.setOrgName(datum.getOrgName());
                        rosterEntity.setDepartmentId(datum.getDeptId());
                        rosterEntity.setDepartmentCode(datum.getDeptCode());
                        rosterEntity.setDepartmentName(datum.getDeptName());
                        rosterEntity.setSyncDay(Long.parseLong(today));
                        rosterEntity.setHrState(datum.getUserState());
                        this.service.saveOrUpdate((Object)rosterEntity);
                        continue;
                    }
                    this.logger.info("\u6570\u636e\u89e3\u6790\u5f00\u53d1---\u6267\u884c\u65b0\u589e---,{}", (Object)i);
                    rosterEntity = new RosterEntity();
                    rosterEntity.setIdCard(datum.getIdCard());
                    rosterEntity.setUserId(datum.getId());
                    rosterEntity.setUserName(datum.getUserName());
                    rosterEntity.setUserCode(datum.getUserCode());
                    rosterEntity.setMobilePhone(datum.getUserMobile());
                    rosterEntity.setEmployeeCode(datum.getEmployeeCode());
                    rosterEntity.setOrgId(datum.getOrgId());
                    rosterEntity.setOrgCode(datum.getOrgCode());
                    rosterEntity.setOrgName(datum.getOrgName());
                    rosterEntity.setDepartmentId(datum.getDeptId());
                    rosterEntity.setDepartmentCode(datum.getDeptCode());
                    rosterEntity.setDepartmentName(datum.getDeptName());
                    rosterEntity.setSyncDay(Long.parseLong(today));
                    rosterEntity.setHrState(datum.getUserState());
                    rosterEntity.setIsOnlySocial("\u5426");
                    this.service.saveOrUpdate((Object)rosterEntity);
                }
            }
        } else {
            return CommonResponse.error((String)"\u6267\u884c\u5931\u8d25\uff01");
        }
        return CommonResponse.success((String)"\u6267\u884c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/pmUserSyncAll"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<JSONObject>> pmUserSyncAll(HttpServletRequest request) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        SimpleDateFormat simpleDateFormat1 = new SimpleDateFormat("yyyyMMdd");
        String today = simpleDateFormat1.format(calendar.getTime());
        calendar.add(5, -1500);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String format = simpleDateFormat.format(calendar.getTime());
        CommonResponse listCommonResponse = this.idmUserApi.syncUserDataByTime(format);
        if (listCommonResponse.getCode() == 0) {
            List data = (List)listCommonResponse.getData();
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                int i = 1;
                for (SalaryUserVO datum : data) {
                    RosterEntity rosterEntity;
                    ++i;
                    QueryParam param = new QueryParam();
                    param.getParams().put("idCard", new Parameter("eq", (Object)datum.getIdCard()));
                    List rosterEntities = this.service.queryList(param);
                    if (rosterEntities != null && rosterEntities.size() > 0) {
                        this.logger.info("\u6570\u636e\u89e3\u6790\u5f00\u53d1---\u6267\u884c\u4fee\u6539---,{}", (Object)i);
                        rosterEntity = (RosterEntity)((Object)rosterEntities.get(0));
                        rosterEntity.setUserId(datum.getId());
                        rosterEntity.setUserName(datum.getUserName());
                        rosterEntity.setUserCode(datum.getUserCode());
                        rosterEntity.setMobilePhone(datum.getUserMobile());
                        rosterEntity.setEmployeeCode(datum.getEmployeeCode());
                        rosterEntity.setOrgId(datum.getOrgId());
                        rosterEntity.setOrgCode(datum.getOrgCode());
                        rosterEntity.setOrgName(datum.getOrgName());
                        rosterEntity.setDepartmentId(datum.getDeptId());
                        rosterEntity.setDepartmentCode(datum.getDeptCode());
                        rosterEntity.setDepartmentName(datum.getDeptName());
                        rosterEntity.setSyncDay(Long.parseLong(today));
                        rosterEntity.setHrState(datum.getUserState());
                        this.service.saveOrUpdate((Object)rosterEntity);
                        continue;
                    }
                    this.logger.info("\u6570\u636e\u89e3\u6790\u5f00\u53d1---\u6267\u884c\u65b0\u589e---,{}", (Object)i);
                    rosterEntity = new RosterEntity();
                    rosterEntity.setIdCard(datum.getIdCard());
                    rosterEntity.setUserId(datum.getId());
                    rosterEntity.setUserName(datum.getUserName());
                    rosterEntity.setUserCode(datum.getUserCode());
                    rosterEntity.setMobilePhone(datum.getUserMobile());
                    rosterEntity.setEmployeeCode(datum.getEmployeeCode());
                    rosterEntity.setOrgId(datum.getOrgId());
                    rosterEntity.setOrgCode(datum.getOrgCode());
                    rosterEntity.setOrgName(datum.getOrgName());
                    rosterEntity.setDepartmentId(datum.getDeptId());
                    rosterEntity.setDepartmentCode(datum.getDeptCode());
                    rosterEntity.setDepartmentName(datum.getDeptName());
                    rosterEntity.setSyncDay(Long.parseLong(today));
                    rosterEntity.setHrState(datum.getUserState());
                    rosterEntity.setIsOnlySocial("\u5426");
                    this.service.saveOrUpdate((Object)rosterEntity);
                }
            }
        } else {
            return CommonResponse.error((String)"\u6267\u884c\u5931\u8d25\uff01");
        }
        return CommonResponse.success((String)"\u6267\u884c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/hrUserSync"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<JSONObject>> hrUserSync(HttpServletRequest request) {
        CommonResponse listCommonResponse = this.baseUserApi.queryAllUserSalary(new QueryParam());
        if (listCommonResponse.getCode() == 0) {
            List data = (List)listCommonResponse.getData();
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
                List list = this.companyService.list((Wrapper)lambdaQueryWrapper);
                this.logger.info("\u6570\u636e\u89e3\u6790\u5f00\u53d1---\u83b7\u53d6\u5230\u72ec\u7acb\u5f00\u6237\u7684\u516c\u53f8\u4e2a\u6570\uff1a---,{}", (Object)list.size());
                Map companyMap = list.stream().collect(Collectors.toMap(CompanyEntity::getHrCompanyName, Function.identity(), (v1, v2) -> v2));
                int i = 1;
                for (SalaryUserDataVO datum : data) {
                    ++i;
                    QueryParam param = new QueryParam();
                    param.getParams().put("idCard", new Parameter("eq", (Object)datum.getCard()));
                    List rosterEntities = this.service.queryList(param);
                    if (rosterEntities != null && rosterEntities.size() > 0) {
                        this.logger.info("\u6570\u636e\u89e3\u6790\u5f00\u53d1---\u6267\u884c\u4fee\u6539---,{}", (Object)i);
                        RosterEntity rosterEntity = (RosterEntity)((Object)rosterEntities.get(0));
                        if (rosterEntity.getJobLevelName() != null && !rosterEntity.getJobLevelName().equals(datum.getJobLevelName())) {
                            RosterRecordEntity map = (RosterRecordEntity)((Object)BeanMapper.map((Object)((Object)rosterEntity), RosterRecordEntity.class));
                            map.setId(null);
                            this.recordService.saveOrUpdate((Object)map);
                        }
                        rosterEntity.setPostName(datum.getPostName());
                        rosterEntity.setJobLevelName(datum.getJobLevelName());
                        rosterEntity.setSexName(datum.getSexName());
                        rosterEntity.setUserTypeName(datum.getUserTypeName());
                        rosterEntity.setResidencyTypeName(datum.getResidencyTypeName());
                        rosterEntity.setEducationName(datum.getEducationName());
                        rosterEntity.setTitleName(datum.getTitleName());
                        rosterEntity.setSocialDepartmentCode(datum.getSocialDepartmentCode());
                        rosterEntity.setSocialDepartmentName(datum.getSocialDepartmentName());
                        rosterEntity.setWorkYear(datum.getWorkYear() + "");
                        rosterEntity.setSourceType(datum.getSourceType());
                        rosterEntity.setAge(datum.getAge());
                        rosterEntity.setCanWorkOut(datum.getCanWorkOut());
                        if (rosterEntity.getSocialCompanyCode() == null && companyMap.containsKey(datum.getSocialDepartmentName())) {
                            CompanyEntity companyEntity = (CompanyEntity)((Object)companyMap.get(datum.getSocialDepartmentName()));
                            rosterEntity.setSocialCompanyId(companyEntity.getOrgId());
                            rosterEntity.setSocialCompanyCode(companyEntity.getOrgCode());
                            rosterEntity.setCompanyName(companyEntity.getOrgName());
                        }
                        this.service.saveOrUpdate((Object)rosterEntity);
                        continue;
                    }
                    this.logger.error("\u6570\u636e\u89e3\u6790\u5f00\u53d1---\u4eba\u5458\u4e0d\u5b58\u5728---,{}", (Object)datum.getCard());
                }
            }
        } else {
            return CommonResponse.error((String)"\u6267\u884c\u5931\u8d25\uff01");
        }
        return CommonResponse.success((String)"\u6267\u884c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/downloadInfo"})
    @ResponseBody
    public void downloadInfo(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"RosterBankInfo-import.xlsx", (String)"\u94f6\u884c\u8d26\u6237\u8c03\u6574\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportInfo(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<RosterVO> successList = new ArrayList<RosterVO>();
        ArrayList<RosterVO> errorList = new ArrayList<RosterVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List<List<String>> result = DetailIndexExcelReaderZzyj.readExcel(mf);
        if (result != null && result.size() > 0) {
            ArrayList<String> idCardList = new ArrayList<String>();
            for (int i = 1; i < result.size(); ++i) {
                List<String> datas = result.get(i);
                idCardList.add(datas.get(1).trim());
            }
            Map<Object, Object> map = new HashMap();
            LambdaQueryWrapper lambdaQueryWrapper1 = new LambdaQueryWrapper();
            lambdaQueryWrapper1.in(RosterEntity::getIdCard, idCardList);
            lambdaQueryWrapper1.isNotNull(RosterEntity::getIdCard);
            List rosterEntityList = this.service.list((Wrapper)lambdaQueryWrapper1);
            map = rosterEntityList.stream().collect(Collectors.toMap(p -> p.getIdCard(), Function.identity()));
            this.logger.info("\u4eba\u5458map: {}", (Object)JSONObject.toJSONString(map));
            for (int i = 1; i < result.size(); ++i) {
                RosterEntity rosterEntity;
                RosterVO detailVO;
                List<String> datas;
                block19: {
                    datas = result.get(i);
                    detailVO = new RosterVO();
                    detailVO.setId(Long.valueOf(IdWorker.getId()));
                    rosterEntity = null;
                    try {
                        String idCard = datas.get(1).trim();
                        detailVO.setIdCard(idCard);
                        if (ObjectUtils.isEmpty((Object)map.get(idCard))) {
                            throw new Exception("\u6ca1\u6709\u8be5\u4eba\u5458\u4fe1\u606f\uff01");
                        }
                        rosterEntity = (RosterEntity)((Object)map.get(idCard));
                        String userName = datas.get(0).trim();
                        if (userName == null || !userName.equals(rosterEntity.getUserName())) {
                            throw new Exception("\u4eba\u5458\u8eab\u4efd\u8bc1\u53f7\u3001\u59d3\u540d\u4e0d\u5339\u914d\uff01");
                        }
                        detailVO.setUserName(userName);
                        detailVO.setUserId(rosterEntity.getUserId());
                        detailVO.setUserCode(rosterEntity.getUserCode());
                        rosterEntity.setUserName(userName);
                        rosterEntity.setUserId(rosterEntity.getUserId());
                        rosterEntity.setUserCode(rosterEntity.getUserCode());
                        rosterEntity.setIdCard(idCard);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("\u4eba\u5458\u540d\u79f0\u3001\u8eab\u4efd\u8bc1\u53f7\u9519\u8bef\uff01");
                        errorList.add(detailVO);
                        continue;
                    }
                    try {
                        String bankName = datas.get(2);
                        if (!StringUtils.isNotBlank((CharSequence)bankName)) {
                            throw new Exception("\u5f00\u6237\u884c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                        }
                        detailVO.setBankName(bankName);
                        rosterEntity.setBankName(bankName);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("\u5f00\u6237\u884c\u540d\u79f0\u9519\u8bef\uff01");
                        errorList.add(detailVO);
                        continue;
                    }
                    try {
                        String bankCode = datas.get(3);
                        if (!StringUtils.isNotBlank((CharSequence)bankCode)) break block19;
                        CommonResponse listCommonResponse = this.bankApi.queryListByCode(bankCode);
                        if (listCommonResponse != null && listCommonResponse.getCode() == 0) {
                            List data = (List)listCommonResponse.getData();
                            if (CollectionUtils.isNotEmpty((Collection)data)) {
                                BankVO bankVO = (BankVO)data.get(0);
                                detailVO.setBankId(bankVO.getId());
                                detailVO.setBankName(bankVO.getName());
                                detailVO.setBankCode(bankVO.getCode());
                                detailVO.setBankAddress(bankVO.getAddress());
                                rosterEntity.setBankId(bankVO.getId());
                                rosterEntity.setBankName(bankVO.getName());
                                rosterEntity.setBankCode(bankVO.getCode());
                                rosterEntity.setBankAddress(bankVO.getAddress());
                                break block19;
                            }
                            throw new Exception("\u8054\u884c\u53f7\u8f93\u5165\u9519\u8bef\uff01");
                        }
                        throw new Exception("\u67e5\u8be2\u94f6\u884c\u4fe1\u606f\u5f02\u5e38\uff01");
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("\u8054\u884c\u53f7\u9519\u8bef\uff01");
                        errorList.add(detailVO);
                        continue;
                    }
                }
                try {
                    String bankAccount = datas.get(4);
                    if (!StringUtils.isNotBlank((CharSequence)bankAccount)) {
                        throw new Exception("\u94f6\u884c\u8d26\u6237\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    detailVO.setBankAccount(bankAccount);
                    rosterEntity.setBankAccount(bankAccount);
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u94f6\u884c\u8d26\u6237\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                detailVO.setBankAddress(datas.get(5));
                rosterEntity.setBankAddress(datas.get(5));
                this.service.saveOrUpdate((Object)rosterEntity);
                detailVO.setRowState("add");
                successList.add(detailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/queryIdByIdCard"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Long> queryIdByIdCard(String idCard) {
        Long id = null;
        QueryParam param = new QueryParam();
        param.getParams().put("idCard", new Parameter("eq", (Object)idCard));
        List rosterEntities = this.service.queryList(param);
        if (CollectionUtils.isNotEmpty((Collection)rosterEntities)) {
            id = ((RosterEntity)((Object)rosterEntities.get(0))).getId();
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", id);
    }

    @RequestMapping(value={"/getSocialOrgDifferentPersonList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<RosterVO>> getSocialOrgDifferentPersonList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("idCard");
        fuzzyFields.add("userName");
        param.getParams().put("hrState", new Parameter("eq", (Object)1));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<RosterVO> noUploadPersonList = this.service.getSocialOrgDifferentPersonList((Page<RosterVO>)page, wrapper);
        page.setRecords(noUploadPersonList);
        return CommonResponse.success((String)"\u67e5\u8be2\u4eba\u5458\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryDetailByIdCard"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RosterVO> queryDetailByIdCard(String id) {
        QueryParam param = new QueryParam();
        param.getParams().put("idCard", new Parameter("eq", (Object)id));
        param.getOrderMap().put("createTime", "desc");
        List rosterEntities = this.service.queryList(param);
        if (CollectionUtils.isNotEmpty((Collection)rosterEntities)) {
            List<PayableDetailVO> payableDetailEntities;
            RosterEntity rosterEntity = (RosterEntity)((Object)rosterEntities.get(0));
            RosterVO vo = (RosterVO)BeanMapper.map((Object)((Object)rosterEntity), RosterVO.class);
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
            List<PayrollPersonVO> payrollPersonEntities = this.mapper.queryPayrollPersonData(wrapper);
            if (CollectionUtils.isNotEmpty(payrollPersonEntities)) {
                vo.setPayrollPersonList(payrollPersonEntities);
                vo.setTotalUpload(Integer.valueOf(payrollPersonEntities.size()));
                vo.setTotalUploadMny(payrollPersonEntities.stream().map(PayrollPersonVO::getActualMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                vo.setTotalLeftMny(payrollPersonEntities.stream().map(PayrollPersonVO::getLeftMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                vo.setTotalLeft(Long.valueOf(payrollPersonEntities.stream().filter(s -> s.getLeftMny().compareTo(BigDecimal.ZERO) > 0).count()));
            }
            if (CollectionUtils.isNotEmpty(payableDetailEntities = this.mapper.queryPayableDetailData(wrapper))) {
                vo.setPayableDetailList(payableDetailEntities);
            }
            return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u5931\u8d25\uff01");
    }
}

