package com.ejianc.business.salary.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.financeintegration.PMSalary.vo.PMGzDetailVO;
import com.ejianc.business.salary.bean.*;
import com.ejianc.business.salary.service.IPayrollService;
import com.ejianc.business.salary.service.IPushcwService;
import com.ejianc.business.salary.service.IResendDetailService;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.salary.mapper.ResendMapper;
import com.ejianc.business.salary.service.IResendService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 工资重发单
 * 
 * @author generator
 * 
 */
@Service("resendService")
public class ResendServiceImpl extends BaseServiceImpl<ResendMapper, ResendEntity> implements IResendService{
    @Autowired
    private IPushcwService pushcwService;
    @Autowired
    private IResendDetailService resendDetailService;
    @Autowired
    private IPayrollService payrollService;
    @Override
    public List<PushcwEntity> changeToPushcw(List<ResendDetailEntity> resendDetailList) {
        if (CollectionUtils.isNotEmpty(resendDetailList)){
            List<PushcwEntity> pushcwEntities = new ArrayList<>();
            for (ResendDetailEntity resendDetailEntity : resendDetailList) {
                PushcwEntity pushcwEntity = new PushcwEntity();
                pushcwEntity.setId(resendDetailEntity.getId());
//                pushcwEntity.setDetailEmployeeId(resendDetailEntity.get);
                pushcwEntity.setDetailEmployeeName(resendDetailEntity.getNewName());
                pushcwEntity.setSourceDetailId(resendDetailEntity.getId());
//                pushcwEntity.setDetailEmployeeCode(resendDetailEntity.getNew);
                pushcwEntity.setIdCard(resendDetailEntity.getNewIdCard());
                pushcwEntity.setActual(resendDetailEntity.getNewActualMny());
                pushcwEntity.setBankName(resendDetailEntity.getNewBankName());
                pushcwEntity.setBankAccount(resendDetailEntity.getNewBankCount());
                pushcwEntity.setBankAddress(resendDetailEntity.getNewBankAddress());
                pushcwEntities.add(pushcwEntity);
            }
            return pushcwEntities;
        }
        return null;
    }

    @Override
    public void changePayState(String companyIdAndMonth) {
        QueryParam param = new QueryParam();
        param.getParams().put("code", new Parameter(QueryParam.LIKE, companyIdAndMonth));
        List<PushcwEntity> pushcwEntities = pushcwService.queryList(param);
        if (CollectionUtils.isNotEmpty(pushcwEntities)){
            Long pid = null;
            //重发子表数据更新
            ArrayList<ResendDetailEntity> resendDetailEntities = new ArrayList<>();
            List<PMGzDetailVO> resultList = new ArrayList<>();
                //为了方便，先更新push表中的原始数据，再通过原始数据更新工资单数据
            for (PushcwEntity pushcwEntity : pushcwEntities) {
                PMGzDetailVO pmGzDetailVO = new PMGzDetailVO();

                ResendDetailEntity resendDetailEntity = resendDetailService.selectById(pushcwEntity.getSourceDetailId());
                resendDetailEntity.setNewAlreadyMny(pushcwEntity.getAlreadyMny());
                resendDetailEntity.setNewState(pushcwEntity.getPayState());

                pmGzDetailVO.setPmBillId(resendDetailEntity.getOldPmbillid());
                pmGzDetailVO.setIdCard(resendDetailEntity.getOldIdCard());
                pmGzDetailVO.setActualMny(pushcwEntity.getAlreadyMny());
                pmGzDetailVO.setState(pushcwEntity.getPayState());

                resendDetailEntities.add(resendDetailEntity);
                resultList.add(pmGzDetailVO);
                pid =resendDetailEntity.getPid();
            }

            resendDetailService.saveOrUpdateBatch(resendDetailEntities);
            payrollService.updateActualMnyByResultList(resultList);



            //更新主表金额
            ResendEntity entity = this.selectById(pid);
            BigDecimal newAlreadyMny = entity.getResendDetailList().stream().
                    map(ResendDetailEntity::getNewAlreadyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            entity.setAlreadySumMny(newAlreadyMny);
            entity.setLeftSumMny(entity.getActualSumMny().subtract(newAlreadyMny));
            this.saveOrUpdate(entity, false);
        }
    }
}
