/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.salary.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.financeintegration.PMSalary.vo.PMGzDetailVO;
import com.ejianc.business.salary.bean.PayrollEntity;
import com.ejianc.business.salary.bean.PushcwEntity;
import com.ejianc.business.salary.mapper.PayrollMapper;
import com.ejianc.business.salary.service.IPayrollService;
import com.ejianc.business.salary.service.IPushcwService;
import com.ejianc.business.salary.service.IResendService;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="payrollService")
public class PayrollServiceImpl
extends BaseServiceImpl<PayrollMapper, PayrollEntity>
implements IPayrollService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPushcwService pushcwService;
    @Autowired
    private IResendService resendService;

    @Override
    public List<PushcwEntity> getActualMny(Date month, Long companyId) {
        return ((PayrollMapper)this.baseMapper).getActualMny(month, companyId);
    }

    @Override
    public List<PushcwEntity> getAcActualMny(Date month, Long companyId) {
        return ((PayrollMapper)this.baseMapper).getAcActualMny(month, companyId);
    }

    @Override
    public List<PushcwEntity> getIdCardActualMny(Date month, Long companyId) {
        return ((PayrollMapper)this.baseMapper).getIdCardActualMny(month, companyId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void handMQMessage(String salaryPayApplyResultMsg) {
        this.logger.info("profinance\u5904\u7406\u4e2d\u95f4\u5e93\u5de5\u8d44\u652f\u4ed8-\u4fee\u6539\u652f\u4ed8\u72b6\u6001\u7533\u8bf7\u5b9a\u65f6\u4efb\u52a1---SalaryPayApplyServiceImpl--handMQMessage--begin\uff01");
        this.logger.info("\u4ece\u6d88\u606f\u961f\u5217\u4e2d\u83b7\u53d6\u5230\u5f85\u5904\u7406\u7684\u5de5\u8d44\u652f\u4ed8\u7533\u8bf7\u4ed8\u6b3e\u7ed3\u679c\uff1a{}", (Object)salaryPayApplyResultMsg);
        if (StringUtils.isNotBlank((CharSequence)salaryPayApplyResultMsg)) {
            List resultList = JSONObject.parseArray((String)salaryPayApplyResultMsg, PMGzDetailVO.class);
            this.logger.info("\u63a5\u6536\u4e00\u5efa\u8d22\u52a1\u7cfb\u7edf\u7684\u5de5\u8d44\u652f\u4ed8\u4ed8\u6b3e\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)resultList));
            if (CollectionUtils.isNotEmpty((Collection)resultList)) {
                this.updateActualMnyByResultList(resultList);
            }
        }
        this.logger.info("profinance\u5904\u7406\u4e2d\u95f4\u5e93\u5de5\u8d44\u652f\u4ed8-\u4fee\u6539\u652f\u4ed8\u72b6\u6001\u5b9a\u65f6\u4efb\u52a1---SalaryPayApplyServiceImpl--handMQMessage--end\uff01");
    }

    @Override
    public void updateActualMnyDetail(String companyIdAndMonth) {
        ((PayrollMapper)this.baseMapper).updateActualMnyDetail(companyIdAndMonth + "%");
    }

    @Override
    public void updateActualMny(String companyIdAndMonth) {
        ((PayrollMapper)this.baseMapper).updateActualMny(companyIdAndMonth);
    }

    public static void main(String[] args) {
        String s = "2025/08/25 18:51:23";
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Date date = null;
        try {
            date = fmt.parse(s);
        }
        catch (ParseException e) {
            System.out.println("\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38\uff01");
        }
    }

    @Override
    public void updateActualMnyByResultList(List<PMGzDetailVO> resultList) {
        ArrayList<String> companyIdAndMonthList = new ArrayList<String>();
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        this.logger.info("\u85aa\u8d44\u4ed8\u6b3e\u7ed3\u679c\u6838\u9500resultList\uff1a{}", (Object)resultList.size());
        for (PMGzDetailVO pmGzDetailVO : resultList) {
            QueryParam param = new QueryParam();
            param.getParams().put("code", new Parameter("eq", (Object)pmGzDetailVO.getPmBillId()));
            param.getParams().put("id_card", new Parameter("eq", (Object)pmGzDetailVO.getIdCard()));
            List pushcwEntityList = this.pushcwService.queryList(param);
            if (CollectionUtil.isNotEmpty((Collection)pushcwEntityList)) {
                if ("2".equals(pmGzDetailVO.getState())) {
                    ((PushcwEntity)((Object)pushcwEntityList.get(0))).setAlreadyMny(pmGzDetailVO.getActualMny());
                } else {
                    ((PushcwEntity)((Object)pushcwEntityList.get(0))).setAlreadyMny(BigDecimal.ZERO);
                }
                ((PushcwEntity)((Object)pushcwEntityList.get(0))).setPayState(pmGzDetailVO.getState());
                Date date = null;
                try {
                    this.logger.info("\u85aa\u8d44\u4ed8\u6b3e\u7ed3\u679c\u6838\u9500getIdCard\uff1a{},{}", (Object)pmGzDetailVO.getIdCard(), (Object)pmGzDetailVO.getUpdateTime());
                    date = fmt.parse(pmGzDetailVO.getUpdateTime());
                    ((PushcwEntity)((Object)pushcwEntityList.get(0))).setStateUpdateTime(date);
                }
                catch (ParseException e) {
                    this.logger.error("\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38\uff01{}", (Object)pmGzDetailVO.getUpdateTime());
                    throw new RuntimeException(e);
                }
                this.pushcwService.updateById(pushcwEntityList.get(0));
                companyIdAndMonthList.add(pmGzDetailVO.getPmBillId().substring(0, pmGzDetailVO.getPmBillId().lastIndexOf("-")));
                continue;
            }
            this.logger.info("\u85aa\u8d44\u4ed8\u6b3e\u7ed3\u679c\u6838\u9500\u4fe1\u606f\u4e3a\u7a7a\uff0cid_card\uff1a{}", (Object)pmGzDetailVO.getIdCard());
        }
        List collect = companyIdAndMonthList.stream().distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect)) {
            for (String s : collect) {
                if (s.substring(s.indexOf("-") + 1, s.length()).length() > 6) {
                    this.resendService.changePayState(s);
                    continue;
                }
                this.updateActualMnyDetail(s);
                this.updateActualMny(s);
            }
        }
    }
}

