package com.ejianc.business.salary.controller;

import java.io.Serializable;

import com.ejianc.business.salary.bean.OfflinePayDetailEntity;
import com.ejianc.business.salary.bean.ResendDetailEntity;
import com.ejianc.business.salary.bean.ResendEntity;
import com.ejianc.business.salary.service.IOfflinePayDetailService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.salary.bean.OfflinePayEntity;
import com.ejianc.business.salary.service.IOfflinePayService;
import com.ejianc.business.salary.vo.OfflinePayVO;

/**
 * 线下支付状态变更
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("offlinePay")
public class OfflinePayController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IOfflinePayService service;
    @Autowired
    private IOfflinePayDetailService resendDetailService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OfflinePayVO> saveOrUpdate(@RequestBody OfflinePayVO saveOrUpdateVO) {
    	OfflinePayEntity entity = BeanMapper.map(saveOrUpdateVO, OfflinePayEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        //计算公司id，并处理子表是否重复发放
        if(CollectionUtils.isNotEmpty(entity.getOfflinePayDetailList())){
            String oldPmbillid = null;
            for (OfflinePayDetailEntity resendDetailEntity : entity.getOfflinePayDetailList()) {
                if (!"del".equals(resendDetailEntity.getRowState())){

                    //查找是否重发过
                    QueryParam param = new QueryParam();
                    param.getParams().put("oldId",new Parameter(QueryParam.EQ,resendDetailEntity.getOldId()));
                    List<OfflinePayDetailEntity> resendDetailEntities = resendDetailService.queryList(param);
                    if (CollectionUtils.isNotEmpty(resendDetailEntities)){
                        for (OfflinePayDetailEntity detailEntity : resendDetailEntities) {
                            if (entity.getId() == null || entity.getId() == 0) {
                                //发放失败才可以新增
                                if (!(detailEntity.getNewState() != null && "3".equals(detailEntity.getNewState()))) {
                                    throw new BusinessException("已经做过重发！"+detailEntity.getNewName());
                                }
                            }else {
                                //发放失败才可以新增
                                if ((!detailEntity.getPid().equals(resendDetailEntity.getPid())) &&  !(detailEntity.getNewState() != null && "3".equals(detailEntity.getNewState()))) {
                                    throw new BusinessException("已经做过重发！"+detailEntity.getNewName());
                                }
                            }
                        }
                    }

                    oldPmbillid = resendDetailEntity.getOldPmbillid();
                }
            }
            if (oldPmbillid != null) {
                entity.setCompanyId(Long.parseLong(oldPmbillid.substring(0, oldPmbillid.indexOf("-"))));
            }else {
                throw new BusinessException("请选择明细");
            }
        }else {
            throw new BusinessException("请选择明细");
        }


        service.saveOrUpdate(entity, false);


        //计算主表总金额
        BigDecimal bigDecimal = celcAmount(entity.getId());
        entity.setActualSumMny(bigDecimal);
        entity.setAlreadySumMny(BigDecimal.ZERO);
        entity.setLeftSumMny(bigDecimal);
        service.saveOrUpdate(entity, false);

    	OfflinePayVO vo = BeanMapper.map(entity, OfflinePayVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OfflinePayVO> queryDetail(Long id) {
    	OfflinePayEntity entity = service.selectById(id);
    	OfflinePayVO vo = BeanMapper.map(entity, OfflinePayVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OfflinePayVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (OfflinePayVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(OfflinePayVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OfflinePayVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("acSet");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<OfflinePayEntity> page = service.queryPage(param,false);
        IPage<OfflinePayVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), OfflinePayVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<OfflinePayEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("OfflinePay-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refOfflinePayData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OfflinePayVO>> refOfflinePayData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<OfflinePayEntity> page = service.queryPage(param,false);
        IPage<OfflinePayVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OfflinePayVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }



    public BigDecimal celcAmount(Long id) {
        OfflinePayEntity entity = service.selectById(id);
        if (CollectionUtils.isNotEmpty(entity.getOfflinePayDetailList())){
            return entity.getOfflinePayDetailList().stream().map(OfflinePayDetailEntity::getNewActualMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return BigDecimal.ZERO;
    }
}
