package com.ejianc.business.salary.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.desktop.vo.ReportDataVO;
import com.ejianc.business.salary.bean.PayableDetailEntity;
import com.ejianc.business.salary.vo.PayableDetailVO;
import com.ejianc.business.salary.vo.PayrollPersonVO;
import com.ejianc.business.salary.vo.RosterVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.salary.bean.RosterEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 人员花名册
 * 
 * @author generator
 * 
 */
@Mapper
public interface RosterMapper extends BaseCrudMapper<RosterEntity> {
    List<RosterVO> getSocialOrgDifferentPersonList(Page<RosterVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper);


    //判断此人是否已经上传过工资
    List<PayableDetailEntity> isUpSalary(String idCard);



    List<PayrollPersonVO> queryPayrollPersonData(@Param(Constants.WRAPPER) QueryWrapper param);
    List<PayableDetailVO> queryPayableDetailData(@Param(Constants.WRAPPER) QueryWrapper param);

}
