package com.ejianc.business.salary.consumer;

import com.alibaba.fastjson.JSON;
import com.ejianc.business.financeintegration.PMSalary.vo.PMGzVO;
import com.ejianc.business.salary.service.IPayrollService;
import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.framework.mq.consumer.BaseConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.core.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 消息中心基础消息拉取监听类
 */
@Component
public class SalaryListener extends BaseConsumer {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPayrollService payrollService;


    @Override
    protected void doConsumeMsg(MqMessage mqMessage) {
        try {
            //拿到消息队列中的数据，进行处理
            logger.info("监听从消息队列中拿到工资支付付款结果消息：{}", JSON.toJSONString(mqMessage.getBody()));
            payrollService.handMQMessage(JSON.toJSONString(mqMessage.getBody()));
        } catch (Exception e) {
            logger.error("监听消息异常: ", e);
        }
    }

    @Override
    protected String[] getQueueNames() {
        return new String[]{PMGzVO.GZ_PAY_RESULT_MESSAGE};
    }

    @Override
    public void onMessage(Message message) {

    }

    @Override
    public void containerAckMode(AcknowledgeMode mode) {

    }
}
