/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.salary.service.impl;

import com.ejianc.business.salary.bean.PayableDetailEntity;
import com.ejianc.business.salary.bean.PayableEntity;
import com.ejianc.business.salary.service.IPayableDetailService;
import com.ejianc.business.salary.service.IPayableService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="payable")
public class PayableBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IPayableService payableService;
    @Autowired
    private IPayableDetailService payableDetailService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        PayableEntity payableEntity = (PayableEntity)((Object)this.payableService.selectById(billId));
        if (payableEntity.getPayableType() == 1 && CollectionUtils.isNotEmpty(payableEntity.getPayableDetailList())) {
            for (PayableDetailEntity payableDetailEntity : payableEntity.getPayableDetailList()) {
                if (!payableEntity.getOrgId().equals(payableDetailEntity.getDetailOrgId())) continue;
                BigDecimal sbGjjPersonMoney = this.payableService.getSbGjjPersonMoney(payableDetailEntity.getIdCard());
                if (sbGjjPersonMoney == null) {
                    sbGjjPersonMoney = BigDecimal.ZERO;
                }
                if (sbGjjPersonMoney.multiply(new BigDecimal(1.2)).compareTo(payableDetailEntity.getYfSalaryMny()) <= 0) continue;
                return CommonResponse.error((String)(payableDetailEntity.getDetailEmployeeName() + "\u7684\u5e94\u53d1\u5de5\u8d44(" + payableDetailEntity.getYfSalaryMny() + ")\u5e94\u5927\u4e8e\u793e\u4fdd\u516c\u79ef\u91d1\u4e2a\u4eba\u90e8\u5206(" + sbGjjPersonMoney + ")1.2\u500d\uff01"));
            }
        }
        if (CollectionUtils.isNotEmpty(payableEntity.getPayableDetailList())) {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("orgId", new Parameter("eq", (Object)payableEntity.getOrgId()));
            queryParam.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
            queryParam.getParams().put("collectStatus", new Parameter("eq", (Object)0));
            List payableEntities = this.payableService.queryList(queryParam);
            if (CollectionUtils.isNotEmpty((Collection)payableEntities)) {
                List collect = payableEntities.stream().map(s -> s.getId()).collect(Collectors.toList());
                QueryParam queryParam1 = new QueryParam();
                queryParam1.getParams().put("payableId", new Parameter("in", collect));
                List payableDetailEntities = this.payableDetailService.queryList(queryParam1);
                List idCardList = payableDetailEntities.stream().map(s -> s.getIdCard()).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(payableEntity.getPayableDetailList())) {
                    for (PayableDetailEntity payableDetailEntity : payableEntity.getPayableDetailList()) {
                        if (!idCardList.contains(payableDetailEntity.getIdCard())) continue;
                        return CommonResponse.error((String)(payableDetailEntity.getDetailEmployeeName() + "\u672c\u5468\u671f\u5185\u5df2\u4e0a\u4f20\u8fc7\u5de5\u8d44\uff01"));
                    }
                }
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        PayableEntity payableEntity = (PayableEntity)((Object)this.payableService.selectById(billId));
        if (1 == payableEntity.getCollectStatus()) {
            return CommonResponse.error((String)"\u5df2\u6c47\u603b\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u5f03\u5ba1");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

