package com.ejianc.business.salary.mapper;

import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.salary.bean.RosterSocialSecurityEntity;
import org.apache.ibatis.annotations.Update;

/**
 * 人员花名册-社保
 * 
 * @author generator
 * 
 */
@Mapper
public interface RosterSocialSecurityMapper extends BaseCrudMapper<RosterSocialSecurityEntity> {

    @Update("update ejc_salary_roster_social_security set data_state = '停用' where data_state = '启用' and dr= 0 " +
            "and id_card in (\n" +
            "select id_card from ejc_salary_roster where dr = 0 and social_department_name = #{socialDepartmentName})")
    void updateSocialSecurityState(String socialDepartmentName);
    @Update(" update ejc_salary_roster_social_security set data_state = '停用' where data_state = '启用' and id_card in (SELECT id_card FROM `ejc_salary_roster` where hr_state = 0) and create_time < DATE_ADD(CURDATE(), INTERVAL -DAY(CURDATE()) + 1 DAY) \n")
    void updateSocialSecurityStateLz();
}
