package com.ejianc.business.salary.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.salary.bean.RosterEntity;
import com.ejianc.business.salary.vo.PayableDetailVO;
import com.ejianc.business.salary.vo.RosterVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.salary.bean.PayableEntity;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 应发工资上传
 * 
 * @author generator
 * 
 */
public interface IPayableService extends IBaseService<PayableEntity> {
    List<PayableDetailVO> getDetailByOrg(Date month, List<Long> orgIds);

    List<PayableDetailVO> getDetail(Date month);

    List<RosterVO> getUserByOrgCode(List<String> orgCode1,List<String> orgCode2,Integer month);

    BigDecimal getSbGjjPersonMoney(String idCard);

    //根据组织自动生成主表
    PayableEntity autoCreatePayable(Long orgId);

    //根据人员清单自动生成子表
    CommonResponse<Boolean> autoCreatePayableDetail(List<RosterEntity> rosterEntities,List<Long> zzyjOrgIds,int payableType);

    //未发放人员清单
    List<RosterVO> getNoUploadPersonList(Page<RosterVO> page, QueryWrapper wrapper);


    List<Long> zzyjOrgIds();
    Boolean isZzyjOrg(Long orgId);
}
