package com.ejianc.business.salary.service.impl;

import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.salary.mapper.LockMapper;
import com.ejianc.business.salary.bean.LockEntity;
import com.ejianc.business.salary.service.ILockService;

import java.util.Date;
import java.util.List;

/**
 * 状态锁记录
 * 
 * @author generator
 * 
 */
@Service("lockService")
public class LockServiceImpl extends BaseServiceImpl<LockMapper, LockEntity> implements ILockService{
    @Autowired
    private SessionManager sessionManager;

    @Override
    public void openTheLock() {
        QueryParam param = new QueryParam();
        param.getParams().put("state", new Parameter(QueryParam.EQ, "开启"));
        List<LockEntity> lockEntities = this.queryList(param);
        if (CollectionUtils.isNotEmpty(lockEntities)){
            throw new BusinessException("当前状态未关闭！");
        }

        UserContext userContext = sessionManager.getUserContext();
        LockEntity lockEntity = new LockEntity();
        lockEntity.setState("开启");
        lockEntity.setCreateTime(new Date());
        lockEntity.setCreateUserCode(userContext.getUserCode());

        this.saveOrUpdate(lockEntity);
    }

    @Override
    public void closeTheLock() {
        QueryParam param = new QueryParam();
        param.getParams().put("state", new Parameter(QueryParam.EQ, "开启"));
        List<LockEntity> lockEntities = this.queryList(param);
        if (CollectionUtils.isEmpty(lockEntities)){
            throw new BusinessException("当前状态未开启！");
        }

        UserContext userContext = sessionManager.getUserContext();

        for (LockEntity lockEntity : lockEntities) {
            lockEntity.setState("关闭");
            lockEntity.setUpdateTime(new Date());
            lockEntity.setUpdateUserCode(userContext.getUserCode());
            this.saveOrUpdate(lockEntity);
        }
    }
}
