package com.ejianc.business.salary.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.financeintegration.PMSalary.api.IPMSalarySystemApi;
import com.ejianc.business.salary.bean.OfflinePayDetailEntity;
import com.ejianc.business.salary.bean.OfflinePayEntity;
import com.ejianc.business.salary.service.IOfflinePayService;
import com.ejianc.business.salary.service.IPushcwService;
import com.ejianc.business.salary.service.IResendService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;
import java.util.stream.Collectors;

@Service("offlinePay") 
public class OfflinePayBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IOfflinePayService offlinePayService;

	@Autowired
	private IPMSalarySystemApi salarySystemApi;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		OfflinePayEntity offlinePayEntity = offlinePayService.selectById(billId);
		if (CollectionUtils.isNotEmpty(offlinePayEntity.getOfflinePayDetailList())){
			List<String> oldIdCollect = offlinePayEntity.getOfflinePayDetailList().stream().map(OfflinePayDetailEntity::getOldId).collect(Collectors.toList());
			if (CollectionUtils.isNotEmpty(oldIdCollect)){
				logger.info("salarySystemApi.changeSalaryDetailState--oldIdCollect--{}", JSON.toJSONString(oldIdCollect));
				CommonResponse<JSONObject> jsonObjectCommonResponse = salarySystemApi.changeSalaryDetailState(oldIdCollect);
				if (!jsonObjectCommonResponse.isSuccess()){
					return CommonResponse.error("修改状态失败--"+ jsonObjectCommonResponse.getMsg());
				}

			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("线下支付工资已经发放，不允许撤回！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
