package com.ejianc.business.salary.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.ejianc.business.salary.bean.CompanyEntity;
import com.ejianc.business.salary.bean.RosterEntity;
import com.ejianc.business.salary.service.ICompanyService;
import com.ejianc.business.salary.service.IRosterService;
import com.ejianc.business.salary.util.DetailIndexExcelReaderZzyj;
import com.ejianc.business.salary.vo.SocialSecurityChangeSdetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.salary.bean.SocialSecurityChangeAdetailEntity;
import com.ejianc.business.salary.service.ISocialSecurityChangeAdetailService;
import com.ejianc.business.salary.vo.SocialSecurityChangeAdetailVO;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/**
 * 社保公积金调整-公积金明细
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("socialSecurityChangeAdetail")
public class SocialSecurityChangeAdetailController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private ISocialSecurityChangeAdetailService service;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IRosterService rosterService;
    @Autowired
    private ICompanyService companyService;
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SocialSecurityChangeAdetailVO> saveOrUpdate(@RequestBody SocialSecurityChangeAdetailVO saveOrUpdateVO) {
    	SocialSecurityChangeAdetailEntity entity = BeanMapper.map(saveOrUpdateVO, SocialSecurityChangeAdetailEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	SocialSecurityChangeAdetailVO vo = BeanMapper.map(entity, SocialSecurityChangeAdetailVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SocialSecurityChangeAdetailVO> queryDetail(Long id) {
    	SocialSecurityChangeAdetailEntity entity = service.selectById(id);
    	SocialSecurityChangeAdetailVO vo = BeanMapper.map(entity, SocialSecurityChangeAdetailVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SocialSecurityChangeAdetailVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (SocialSecurityChangeAdetailVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(SocialSecurityChangeAdetailVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SocialSecurityChangeAdetailVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<SocialSecurityChangeAdetailEntity> page = service.queryPage(param,false);
        IPage<SocialSecurityChangeAdetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SocialSecurityChangeAdetailVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SocialSecurityChangeAdetailEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SocialSecurityChangeAdetail-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refSocialSecurityChangeAdetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SocialSecurityChangeAdetailVO>> refSocialSecurityChangeAdetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SocialSecurityChangeAdetailEntity> page = service.queryPage(param,false);
        IPage<SocialSecurityChangeAdetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SocialSecurityChangeAdetailVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadInfo")
    @ResponseBody
    public void downloadMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "SocialSecurityChangeAdetail-import.xlsx", "公积金调整导入模板");
    }
    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImportInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response
            ,@RequestParam(value = "companyId", required = true) Long companyId) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<SocialSecurityChangeAdetailVO> successList = new ArrayList<>();
        List<SocialSecurityChangeAdetailVO> errorList = new ArrayList<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        }
        else {
            List<List<String>> result = DetailIndexExcelReaderZzyj.readExcel(mf);
            if (result != null && result.size() > 0) {
                List<String> idCardList = new ArrayList<>();
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    idCardList.add(datas.get(1).trim());
                }

                //获取人员花名册档案数据
                Map<String, RosterEntity> map = new HashMap<>();
                LambdaQueryWrapper<RosterEntity> lambdaQueryWrapper1 = new LambdaQueryWrapper<>();
//                lambdaQueryWrapper1.eq(RosterEntity::getHrState, 1);
                lambdaQueryWrapper1.in(RosterEntity::getIdCard,idCardList);
                lambdaQueryWrapper1.isNotNull(RosterEntity::getIdCard);
                List<RosterEntity> rosterEntityList= rosterService.list(lambdaQueryWrapper1);
                map = rosterEntityList.stream().collect(Collectors.toMap(p -> p.getIdCard(), Function.identity()));
                logger.info("人员map: {}",JSONObject.toJSONString(map));

                //根据独立开户的公司id获取社保缴纳单位名称
                CompanyEntity companyEntity = companyService.selectById(companyId);

                HashMap<String, SocialSecurityChangeAdetailVO> stringSocialSecurityChangeAdetailVOHashMap = new HashMap<>();

                //给每行赋值
                for (int i = 0; i < result.size(); i++) {
                    SocialSecurityChangeAdetailVO detailVO;
                    List<String> datas = result.get(i);
                    String idCard = datas.get(1).trim();
                    if (stringSocialSecurityChangeAdetailVOHashMap.containsKey(idCard)){
                        detailVO = stringSocialSecurityChangeAdetailVOHashMap.get(idCard);
                    }else {
                        detailVO = new SocialSecurityChangeAdetailVO();
                        detailVO.setId(com.ejianc.support.idworker.util.IdWorker.getId());
                        try {
                            //身份证号
                            detailVO.setIdCard(idCard);
                            if (ObjectUtils.isEmpty(map.get(idCard))){
                                throw new Exception("没有该人员信息！");
                            }

                            RosterEntity rosterEntity = map.get(idCard);
                            String userName = datas.get(0).trim();
                            if (userName != null && userName.equals(rosterEntity.getUserName())){
                                detailVO.setUserName(userName);
                                detailVO.setUserId(rosterEntity.getUserId());
                                detailVO.setUserCode(rosterEntity.getUserCode());
                            }else {
                                throw new Exception("人员身份证号、姓名不匹配！");
                            }

                            //花名册中的社保缴纳单位和主表中所属公司是否一致，不一致则提醒
                            if (!companyEntity.getHrCompanyName().equals(rosterEntity.getSocialDepartmentName())){
                                throw new Exception("人员社保缴纳单位不一致！"+rosterEntity.getSocialDepartmentName());
                            }
                        }
                        catch (Exception e) {
                            detailVO.setErrorMsg(e.getMessage());
                            errorList.add(detailVO);
                            continue;
                        }
                    }



                    //基数
                        String paymentBase = datas.get(3);
                        if(StringUtils.isNotBlank(paymentBase)) {
                            BigDecimal divide = new BigDecimal(paymentBase);
                            detailVO.setPaymentBase(divide);
                        }

                    //个人公积金
                    try {
                        String money = datas.get(4);
                        if(StringUtils.isNotBlank(money)) {
                            BigDecimal divide = new BigDecimal(money);
                            if (detailVO.getPersonMoney() != null) {
                                detailVO.setPersonMoney(detailVO.getPersonMoney().add(divide));
                            }else {
                                detailVO.setPersonMoney(divide);
                            }
                        }else {
                            throw new Exception("个人公积金不能为空！");
                        }
                    } catch (Exception e) {
                        detailVO.setErrorMsg(e.getMessage());
                        errorList.add(detailVO);
                        continue;
                    }
                    //公司公积金
                    try {
                        String money = datas.get(5);
                        if(StringUtils.isNotBlank(money)) {
                            BigDecimal divide = new BigDecimal(money);
                            if (detailVO.getCompanyMoney() != null) {
                                detailVO.setCompanyMoney(detailVO.getCompanyMoney().add(divide));
                            }else {
                                detailVO.setCompanyMoney(divide);
                            }
                        }else {
                            throw new Exception("公司公积金不能为空！");
                        }
                    } catch (Exception e) {
                        detailVO.setErrorMsg(e.getMessage());
                        errorList.add(detailVO);
                        continue;
                    }


                    //detailVO.setChangeReason( datas.get(5));
                    detailVO.setRowState("add");
                    successList.add(detailVO);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

}
