/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.salary.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.salary.bean.AcSetRelateEntity;
import com.ejianc.business.salary.bean.PayableDetailEntity;
import com.ejianc.business.salary.bean.PayableEntity;
import com.ejianc.business.salary.mapper.AcSetRelateMapper;
import com.ejianc.business.salary.service.IAcSetRelateService;
import com.ejianc.business.salary.service.IPayableDetailService;
import com.ejianc.business.salary.service.IPayableService;
import com.ejianc.business.salary.service.IRosterService;
import com.ejianc.business.salary.vo.AcSetRelateVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="acSetRelateService")
public class AcSetRelateServiceImpl
extends BaseServiceImpl<AcSetRelateMapper, AcSetRelateEntity>
implements IAcSetRelateService {
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IPayableService payableService;
    @Autowired
    private IPayableDetailService payableDetailService;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IRosterService rosterService;

    @Override
    public AcSetRelateVO queryDetailByOrgId(Long orgId, Integer orgType, String month, Boolean payableBillFlag) {
        AcSetRelateEntity entity = (AcSetRelateEntity)((Object)this.getOne((Wrapper)new QueryWrapper().eq((Object)"org_id", (Object)orgId)));
        AcSetRelateVO acSetRelateVO = new AcSetRelateVO();
        if (null != entity) {
            acSetRelateVO = (AcSetRelateVO)BeanMapper.map((Object)((Object)entity), AcSetRelateVO.class);
        }
        if (null != payableBillFlag && payableBillFlag.booleanValue()) {
            CommonResponse parentByOrgId;
            QueryWrapper queryWrapper = new QueryWrapper();
            if (null == orgType) {
                CommonResponse orgIdCrs = this.iOrgApi.getOneById(orgId);
                if (!orgIdCrs.isSuccess() || null == orgIdCrs.getData()) {
                    throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
                }
                orgType = ((OrgVO)orgIdCrs.getData()).getOrgType();
            }
            if (!(parentByOrgId = this.iOrgApi.findParentByOrgId(orgId)).isSuccess() || null == parentByOrgId.getData()) {
                throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            OrgVO parentOrg = (OrgVO)parentByOrgId.getData();
            if (null != parentOrg) {
                acSetRelateVO.setParentOrgCode(parentOrg.getCode());
                acSetRelateVO.setParentOrgId(parentOrg.getId());
                acSetRelateVO.setParentOrgName(parentOrg.getName());
            }
            if (5 == orgType) {
                queryWrapper.in((Object)"org_id", (Collection)((List)this.iOrgApi.findChildrenByParentId(parentOrg.getId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            } else {
                queryWrapper.in((Object)"org_id", (Collection)((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            }
            QueryParam param = new QueryParam();
            param.getParams().put("hrState", new Parameter("eq", (Object)1));
            List collect1 = ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(OrgVO::getCode).collect(Collectors.toList());
            String join = String.join((CharSequence)"','", collect1);
            param.getParams().put("", new Parameter("sql", (Object)("(org_code in ('" + join + "') or id_card in (SELECT id_card FROM `ejc_salary_roster_job` where valid_flag = '\u4efb' and department_code in ('" + join + "')))")));
            List rosterEntities = this.rosterService.queryList(param);
            acSetRelateVO.setOrgPersonNum(Integer.valueOf(rosterEntities.size()));
            List allPayableList = this.payableService.list((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)allPayableList) && allPayableList.size() > 0) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
                List thisMonthData = allPayableList.stream().filter(e -> null != e.getMonth() && sdf.format(e.getMonth()).equals(month)).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(thisMonthData)) {
                    acSetRelateVO.setOrgBillNum(Integer.valueOf(thisMonthData.size()));
                    acSetRelateVO.setOrgBillRegisterMny(thisMonthData.stream().filter(p -> p.getPayableSumMny() != null).map(PayableEntity::getPayableSumMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                    acSetRelateVO.setOrgAllBillRegisterMny(acSetRelateVO.getOrgBillRegisterMny());
                    acSetRelateVO.setOrgBillApprovalMny(thisMonthData.stream().filter(p -> p.getPayableSumMny() != null && (p.getBillState() == 1 || p.getBillState() == 3)).map(PayableEntity::getPayableSumMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                    List payableDetailList = this.payableDetailService.list((Wrapper)new QueryWrapper().in((Object)"payable_id", (Collection)thisMonthData.stream().map(BaseEntity::getId).collect(Collectors.toList())));
                    if (CollectionUtils.isNotEmpty((Collection)payableDetailList) && payableDetailList.size() > 0) {
                        acSetRelateVO.setSalaryPersonNum(Integer.valueOf(payableDetailList.stream().filter(e -> null != e.getIdCard()).map(PayableDetailEntity::getIdCard).distinct().collect(Collectors.toList()).size()));
                        acSetRelateVO.setAllSalaryPersonNum(acSetRelateVO.getSalaryPersonNum());
                    }
                }
                ArrayList<PayableEntity> lastMonthData = new ArrayList<PayableEntity>();
                for (PayableEntity jspayableEntity : allPayableList) {
                    Date lastMonth = DateUtils.addMonths((Date)jspayableEntity.getMonth(), (int)1);
                    if (!sdf.format(lastMonth).equals(month)) continue;
                    lastMonthData.add(jspayableEntity);
                }
                if (CollectionUtils.isNotEmpty(lastMonthData)) {
                    acSetRelateVO.setLastMonthMny(lastMonthData.stream().filter(p -> p.getPayableSumMny() != null).map(PayableEntity::getPayableSumMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                    acSetRelateVO.setDifMonthMny(acSetRelateVO.getLastMonthMny());
                    if (CollectionUtils.isNotEmpty(thisMonthData)) {
                        acSetRelateVO.setDifMonthMny(ComputeUtil.safeSub((BigDecimal)acSetRelateVO.getLastMonthMny(), (BigDecimal)thisMonthData.stream().filter(p -> p.getPayableSumMny() != null).map(PayableEntity::getPayableSumMny).reduce(BigDecimal.ZERO, BigDecimal::add)));
                    }
                } else {
                    acSetRelateVO.setDifMonthMny(ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)thisMonthData.stream().filter(p -> p.getPayableSumMny() != null).map(PayableEntity::getPayableSumMny).reduce(BigDecimal.ZERO, BigDecimal::add)));
                }
            }
        }
        return acSetRelateVO;
    }
}

