/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.salary.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.salary.bean.CompanyEntity;
import com.ejianc.business.salary.bean.PayableDetailEntity;
import com.ejianc.business.salary.bean.PayableEntity;
import com.ejianc.business.salary.bean.RosterAttendanceEntity;
import com.ejianc.business.salary.bean.RosterEntity;
import com.ejianc.business.salary.mapper.PayableMapper;
import com.ejianc.business.salary.service.IAcSetRelateService;
import com.ejianc.business.salary.service.ICompanyService;
import com.ejianc.business.salary.service.IPayableDetailService;
import com.ejianc.business.salary.service.IPayableService;
import com.ejianc.business.salary.service.IRosterAttendanceService;
import com.ejianc.business.salary.vo.AcSetRelateVO;
import com.ejianc.business.salary.vo.PayableDetailVO;
import com.ejianc.business.salary.vo.PayableVO;
import com.ejianc.business.salary.vo.RosterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="payableService")
public class PayableServiceImpl
extends BaseServiceImpl<PayableMapper, PayableEntity>
implements IPayableService {
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IAcSetRelateService acSetRelateService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPayableDetailService detailService;
    @Autowired
    private IRosterAttendanceService attendanceService;
    @Autowired
    private ICompanyService companyService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    static Long zzyjOrgId = 1502571152583692289L;
    private static final String BILL_CODE = "YFGZSC_CODE";

    @Override
    public List<PayableDetailVO> getDetailByOrg(Date month, List<Long> orgIds) {
        return ((PayableMapper)this.baseMapper).getDetailByOrg(month, orgIds);
    }

    @Override
    public List<PayableDetailVO> getDetail(Date month) {
        return ((PayableMapper)this.baseMapper).getDetail(month);
    }

    @Override
    public List<RosterVO> getUserByOrgCode(List<String> orgCode1, List<String> orgCode2, Integer month) {
        return ((PayableMapper)this.baseMapper).getUserByOrgCode(orgCode1, orgCode2, month);
    }

    @Override
    public BigDecimal getSbGjjPersonMoney(String idCard) {
        return ((PayableMapper)this.baseMapper).getSbGjjPersonMoney(idCard);
    }

    @Override
    public PayableEntity autoCreatePayable(Long orgId) {
        CommonResponse orgDetail = this.iOrgApi.getOneById(orgId);
        if (orgDetail.getCode() != 0) {
            throw new BusinessException("\u6839\u636eid\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01" + orgId);
        }
        OrgVO orgVO = (OrgVO)orgDetail.getData();
        UserContext userContext = this.sessionManager.getUserContext();
        Date lastMonth = this.getLastMonth();
        PayableEntity payableEntity = new PayableEntity();
        payableEntity.setId(IdWorker.getId());
        payableEntity.setEmployeeId(userContext.getUserId());
        payableEntity.setEmployeeName(userContext.getUserName());
        payableEntity.setCorpId(orgVO.getId());
        payableEntity.setCorpCode(orgVO.getCode());
        payableEntity.setCorpName(orgVO.getName());
        payableEntity.setMonth(lastMonth);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM");
        String format = simpleDateFormat.format(lastMonth);
        payableEntity.setPayableName(format + "-" + orgVO.getName());
        payableEntity.setOrgId(orgVO.getId());
        payableEntity.setOrgCode(orgVO.getCode());
        payableEntity.setOrgName(orgVO.getName());
        payableEntity.setCollectStatus(0);
        payableEntity.setBillState(3);
        AcSetRelateVO acSetRelateVO = this.acSetRelateService.queryDetailByOrgId(orgId, orgVO.getOrgType(), format, true);
        payableEntity.setAcSet(acSetRelateVO.getAcSet());
        payableEntity.setAcSetCode(acSetRelateVO.getAcSetCode());
        payableEntity.setOrgBillNum(acSetRelateVO.getOrgBillNum() + 1);
        payableEntity.setOrgBillRegisterMny(acSetRelateVO.getOrgBillRegisterMny());
        payableEntity.setOrgBillApprovalMny(acSetRelateVO.getOrgBillApprovalMny());
        payableEntity.setLastMonthMny(acSetRelateVO.getLastMonthMny());
        payableEntity.setDifMonthMny(acSetRelateVO.getDifMonthMny());
        payableEntity.setParentOrgCode(acSetRelateVO.getParentOrgCode());
        payableEntity.setParentOrgId(acSetRelateVO.getParentOrgId());
        payableEntity.setParentOrgName(acSetRelateVO.getParentOrgName());
        payableEntity.setSalaryPersonNum(acSetRelateVO.getSalaryPersonNum());
        payableEntity.setAllSalaryPersonNum(acSetRelateVO.getAllSalaryPersonNum());
        payableEntity.setOrgPersonNum(acSetRelateVO.getOrgPersonNum());
        payableEntity.setOrgAllBillRegisterMny(acSetRelateVO.getOrgAllBillRegisterMny());
        payableEntity.setPayableSumMny(BigDecimal.ZERO);
        payableEntity.setOrgSumMny(BigDecimal.ZERO);
        BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)((BaseVO)BeanMapper.map((Object)((Object)payableEntity), PayableVO.class)));
        CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
        if (!billCode.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        payableEntity.setBillCode((String)billCode.getData());
        return payableEntity;
    }

    @Override
    public CommonResponse<Boolean> autoCreatePayableDetail(List<RosterEntity> rosterEntities, List<Long> zzyjOrgIds, int payableType) {
        Date lastMonth = this.getLastMonth();
        HashMap<Long, PayableEntity> longPayableEntityHashMap = new HashMap<Long, PayableEntity>();
        ArrayList<Object> detailListAll = new ArrayList<Object>();
        List idCardList = rosterEntities.stream().map(RosterEntity::getIdCard).collect(Collectors.toList());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMM");
        String format = simpleDateFormat.format(lastMonth);
        Map<Object, Object> attendanceMap = new HashMap();
        LambdaQueryWrapper lambdaQueryWrapper2 = new LambdaQueryWrapper();
        lambdaQueryWrapper2.in(RosterAttendanceEntity::getIdCard, idCardList);
        lambdaQueryWrapper2.eq(RosterAttendanceEntity::getMonth, (Object)format);
        List list = this.attendanceService.list((Wrapper)lambdaQueryWrapper2);
        attendanceMap = list.stream().collect(Collectors.toMap(p -> p.getIdCard(), Function.identity(), (v1, v2) -> v2));
        for (RosterEntity rosterEntity : rosterEntities) {
            BigDecimal sbGjjPersonMoney;
            PayableEntity payableEntity;
            PayableDetailVO detailVO = new PayableDetailVO();
            if (rosterEntity.getPayOrgId() != null) {
                detailVO.setDetailOrgId(rosterEntity.getPayOrgId());
                detailVO.setDetailOrgCode(rosterEntity.getPayOrgCode());
                detailVO.setDetailOrgName(rosterEntity.getPayOrgName());
            } else {
                detailVO.setDetailOrgId(rosterEntity.getOrgId());
                detailVO.setDetailOrgCode(rosterEntity.getOrgCode());
                detailVO.setDetailOrgName(rosterEntity.getOrgName());
            }
            if (!zzyjOrgIds.contains(detailVO.getDetailOrgId())) {
                this.logger.info("\u6b64\u4eba\u4e3b\u5c97\u4e0d\u5728\u8be5\u516c\u53f8\u4e0b\uff01");
                continue;
            }
            if (longPayableEntityHashMap.containsKey(rosterEntity.getPayOrgId() != null ? rosterEntity.getPayOrgId() : rosterEntity.getOrgId())) {
                payableEntity = (PayableEntity)((Object)longPayableEntityHashMap.get(rosterEntity.getPayOrgId() != null ? rosterEntity.getPayOrgId() : rosterEntity.getOrgId()));
            } else {
                payableEntity = this.autoCreatePayable(rosterEntity.getPayOrgId() != null ? rosterEntity.getPayOrgId() : rosterEntity.getOrgId());
                String s = "";
                if (payableType == 2) {
                    s = "\u81ea\u52a8\u751f\u6210\u4e3b\u5c97\u5de5\u8d44";
                } else if (payableType == 3) {
                    s = "\u4ec5\u793e\u4fdd\u4eba\u5458";
                }
                payableEntity.setPayableName(s + "-" + payableEntity.getPayableName());
                payableEntity.setPayableType(payableType);
                longPayableEntityHashMap.put(payableEntity.getOrgId(), payableEntity);
            }
            List<PayableDetailEntity> payableDetailList = payableEntity.getPayableDetailList();
            detailVO.setId(Long.valueOf(IdWorker.getId()));
            detailVO.setPayableId(payableEntity.getId());
            detailVO.setIdCard(rosterEntity.getIdCard());
            detailVO.setDetailEmployeeName(rosterEntity.getUserName());
            detailVO.setDetailEmployeeId(rosterEntity.getUserId());
            detailVO.setDetailEmployeeCode(rosterEntity.getUserCode());
            detailVO.setJobType("\u4e3b\u5c97");
            detailVO.setGzffOrgId(detailVO.getDetailOrgId());
            detailVO.setGzffOrgCode(detailVO.getDetailOrgCode());
            detailVO.setGzffOrgName(detailVO.getDetailOrgName());
            detailVO.setJob(rosterEntity.getPostName());
            detailVO.setDept(rosterEntity.getDepartmentName());
            detailVO.setJobLevel(rosterEntity.getJobLevelName());
            detailVO.setSbjnOrgName(rosterEntity.getSocialDepartmentName());
            detailVO.setSbjnOrgCode(rosterEntity.getSocialDepartmentCode());
            detailVO.setIsMove("2");
            detailVO.setSbcdCompanyId(rosterEntity.getSocialCompanyId());
            detailVO.setSbcdCompanyCode(rosterEntity.getSocialCompanyCode());
            detailVO.setSbcdCompanyName(rosterEntity.getCompanyName());
            detailVO.setDetailCollectStatus(Integer.valueOf(0));
            Map<Long, String> orgids = null;
            orgids = zzyjOrgIds.stream().collect(Collectors.toMap(p -> p, p -> p.toString(), (v1, v2) -> v2));
            if (orgids.containsKey(rosterEntity.getPayOrgId())) {
                detailVO.setSbcdOrgId(rosterEntity.getPayOrgId());
                detailVO.setSbcdOrgCode(rosterEntity.getPayOrgCode());
                detailVO.setSbcdOrgName(rosterEntity.getPayOrgName());
            } else if (orgids.containsKey(rosterEntity.getOrgId())) {
                detailVO.setSbcdOrgId(rosterEntity.getOrgId());
                detailVO.setSbcdOrgCode(rosterEntity.getOrgCode());
                detailVO.setSbcdOrgName(rosterEntity.getOrgName());
            } else {
                detailVO.setSbcdOrgId(rosterEntity.getSocialCompanyId());
                detailVO.setSbcdOrgCode(rosterEntity.getSocialCompanyCode());
                detailVO.setSbcdOrgName(rosterEntity.getCompanyName());
            }
            if (ObjectUtils.isNotEmpty((Object)attendanceMap.get(rosterEntity.getIdCard()))) {
                detailVO.setWorkDaysLastMonth(((RosterAttendanceEntity)((Object)attendanceMap.get(rosterEntity.getIdCard()))).getActualDay());
            }
            detailVO.setUnWriteOffMny(BigDecimal.ZERO);
            detailVO.setWriteOffMny(BigDecimal.ZERO);
            detailVO.setYfjsMny(BigDecimal.ZERO);
            detailVO.setYfmsMny(BigDecimal.ZERO);
            detailVO.setTaxYfmsMny(BigDecimal.ZERO);
            detailVO.setPerformanceMny(BigDecimal.ZERO);
            detailVO.setWorkYearMny(BigDecimal.ZERO);
            detailVO.setWorkTypeMny(BigDecimal.ZERO);
            detailVO.setCertificateMny(BigDecimal.ZERO);
            detailVO.setTravelMny(BigDecimal.ZERO);
            detailVO.setTrafficMny(BigDecimal.ZERO);
            detailVO.setMealMny(BigDecimal.ZERO);
            detailVO.setBenefitMny(BigDecimal.ZERO);
            detailVO.setHolidayMny(BigDecimal.ZERO);
            detailVO.setYearEndMny(BigDecimal.ZERO);
            detailVO.setOvertimeMny(BigDecimal.ZERO);
            detailVO.setAddMny(BigDecimal.ZERO);
            detailVO.setButtonMny(BigDecimal.ZERO);
            detailVO.setYfjscwMny(BigDecimal.ZERO);
            detailVO.setYfmscwMny(BigDecimal.ZERO);
            BigDecimal decimal = BigDecimal.ONE;
            if (payableType == 2) {
                decimal = new BigDecimal(1);
            }
            if ((sbGjjPersonMoney = this.getSbGjjPersonMoney(detailVO.getIdCard())) == null) {
                throw new BusinessException(rosterEntity.getUserName() + "\u6ca1\u6709\u627e\u5230\u793e\u4fdd\u6570\u636e\uff01");
            }
            detailVO.setYfSalaryMny(sbGjjPersonMoney.multiply(decimal));
            detailVO.setSalaryMny(detailVO.getYfSalaryMny());
            detailVO.setJobMny(detailVO.getYfSalaryMny());
            detailVO.setYfmsSalaryMny(ComputeUtil.safeAdd((BigDecimal)detailVO.getYfmsMny(), (BigDecimal)detailVO.getYfSalaryMny()));
            detailVO.setRowState("edit");
            payableEntity.setPayableSumMny(ComputeUtil.safeAdd((BigDecimal)payableEntity.getPayableSumMny(), (BigDecimal)detailVO.getYfSalaryMny()));
            payableDetailList.add((PayableDetailEntity)((Object)BeanMapper.map((Object)detailVO, PayableDetailEntity.class)));
            detailListAll.add(BeanMapper.map((Object)detailVO, PayableDetailEntity.class));
        }
        if (CollectionUtils.isNotEmpty(longPayableEntityHashMap.values())) {
            this.saveOrUpdateBatch(longPayableEntityHashMap.values());
        }
        if (CollectionUtils.isNotEmpty(detailListAll)) {
            this.detailService.saveOrUpdateBatch(detailListAll);
        }
        return CommonResponse.success((String)("\u64cd\u4f5c\u6210\u529f,\u5171\u751f\u6210" + longPayableEntityHashMap.values().size() + "\u4e2a\u5355\u636e\uff01"), (Object)true);
    }

    @Override
    public List<RosterVO> getNoUploadPersonList(Page<RosterVO> page, QueryWrapper wrapper) {
        return ((PayableMapper)this.baseMapper).getNoUploadPersonList(page, wrapper);
    }

    @Override
    public List<Long> zzyjOrgIds() {
        ArrayList<Long> zzyjOrgids = new ArrayList<Long>();
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.ne(CompanyEntity::getOrgId, (Object)zzyjOrgId);
        List list = this.companyService.list((Wrapper)lambdaQueryWrapper);
        List companyOrgIds = list.stream().map(CompanyEntity::getOrgId).collect(Collectors.toList());
        CommonResponse childrenByParentIds = this.iOrgApi.findChildrenByParentIds(companyOrgIds);
        CommonResponse childrenByParentIdZzyj = this.iOrgApi.findChildrenByParentId(zzyjOrgId);
        if (childrenByParentIds != null && childrenByParentIds.getCode() == 0 && childrenByParentIdZzyj != null && childrenByParentIdZzyj.getCode() == 0) {
            List data = (List)childrenByParentIds.getData();
            List dataZzyj = (List)childrenByParentIdZzyj.getData();
            if (CollectionUtils.isEmpty((Collection)data)) {
                throw new BusinessException("\u83b7\u53d6\u793e\u4fdd\u72ec\u7acb\u5f00\u6237\u516c\u53f8\u4fe1\u606f\u5931\u8d25\uff01");
            }
            HashSet h1 = new HashSet(data.stream().map(BaseVO::getId).collect(Collectors.toList()));
            HashSet h2 = new HashSet(dataZzyj.stream().map(BaseVO::getId).collect(Collectors.toList()));
            h2.removeAll(h1);
            zzyjOrgids.addAll(h2);
        }
        return zzyjOrgids;
    }

    @Override
    public Boolean isZzyjOrg(Long orgId) {
        List<Long> longs = this.zzyjOrgIds();
        if (longs.contains(orgId)) {
            return true;
        }
        return false;
    }

    public Date getLastMonth() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(2, -1);
        cal.set(5, cal.getActualMinimum(5));
        return cal.getTime();
    }
}

