/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.salary.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.financeintegration.PMSalary.api.IPMSalarySystemApi;
import com.ejianc.business.financeintegration.PMSalary.vo.PMGzDetailVO;
import com.ejianc.business.financeintegration.PMSalary.vo.PMGzVO;
import com.ejianc.business.financeintegration.PMSalary.vo.PMSbgjjgsVO;
import com.ejianc.business.salary.bean.JspayableAdjustEntity;
import com.ejianc.business.salary.bean.PayrollEntity;
import com.ejianc.business.salary.bean.PushcwEntity;
import com.ejianc.business.salary.mapper.PayrollMapper;
import com.ejianc.business.salary.service.IPayrollService;
import com.ejianc.business.salary.service.IPushcwService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="payroll")
public class PayrollBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IPayrollService payrollService;
    @Autowired
    private IPushcwService pushcwService;
    @Autowired
    private IPMSalarySystemApi salarySystemApi;
    @Autowired
    private PayrollMapper payrollMapper;
    private final String url = "/api/PMSalarySystemApply/salaryTakeEffect";
    @Autowired
    private EnvironmentTools environmentTools;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success((String)"\u6210\u529f\uff01");
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        PayrollEntity payrollEntity = (PayrollEntity)((Object)this.payrollService.selectById(billId));
        if (null == payrollEntity.getPayrollPersonList().get(0).getTotalButuiTaxMny()) {
            return CommonResponse.error((String)"\u8bf7\u5148\u5b8c\u6210\u4e2a\u7a0e\u8ba1\u7b97\u540e\u518d\u63d0\u4ea4\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse<PMGzVO> res;
        PayrollEntity payrollEntity = (PayrollEntity)((Object)this.payrollService.selectById(billId));
        List<PushcwEntity> actualMny = this.payrollService.getActualMny(payrollEntity.getMonth(), payrollEntity.getCompanyId());
        if (CollectionUtils.isNotEmpty(actualMny)) {
            BigDecimal actualSum = BigDecimal.ZERO;
            for (PushcwEntity pushcwEntity : actualMny) {
                if (StringUtils.isBlank((CharSequence)pushcwEntity.getAcSetCode())) {
                    return CommonResponse.error((String)("\u8d26\u5957\u7f16\u53f7\u4e3a\u7a7a\uff01\u7ec4\u7ec7\u540d\u79f0\uff1a" + pushcwEntity.getOrgName()));
                }
                if (StringUtils.isBlank((CharSequence)pushcwEntity.getBankName()) || StringUtils.isBlank((CharSequence)pushcwEntity.getBankAccount())) {
                    return CommonResponse.error((String)("\u94f6\u884c\u4fe1\u606f\u4e3a\u7a7a\uff01\u4eba\u5458\u540d\u79f0\uff1a" + pushcwEntity.getDetailEmployeeName()));
                }
                if (pushcwEntity.getActual().compareTo(BigDecimal.ZERO) < 0) {
                    return CommonResponse.error((String)("\u5b9e\u53d1\u5c0f\u4e8e0\uff01\u4eba\u5458\u540d\u79f0\uff1a" + pushcwEntity.getDetailEmployeeName()));
                }
                pushcwEntity.setMonth(pushcwEntity.getPeriod());
                pushcwEntity.setJspayableDetailId(pushcwEntity.getId());
                pushcwEntity.setId(null);
                pushcwEntity.setSourceType("\u5de5\u8d44\u5355");
                pushcwEntity.setPayState("0");
                actualSum = actualSum.add(pushcwEntity.getActual());
            }
            if (actualSum.compareTo(payrollEntity.getActualSumMny()) != 0) {
                return CommonResponse.error((String)("\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff01\u63a8\u9001\u5230\u8d22\u52a1\u7684\u5b9e\u53d1\u91d1\u989d\u9519\u8bef\uff0c\u91d1\u989d\u4e3a\uff1a" + actualSum));
            }
            this.pushcwService.saveOrUpdateBatch(actualMny);
        }
        if (!(res = this.salaryTakeEffect(payrollEntity)).isSuccess()) {
            this.logger.error("\u8c03\u7528PM\u8d22\u52a1\u6a21\u5757\u751f\u6548\u63a5\u53e3\u5931\u8d25\uff01message-{}", (Object)res.getMsg());
            return CommonResponse.error((String)"\u8c03\u7528PM\u8d22\u52a1\u6a21\u5757\u751f\u6548\u63a5\u53e3\u5931\u8d25");
        }
        return CommonResponse.success();
    }

    private CommonResponse<PMGzVO> salaryTakeEffect(PayrollEntity payrollEntity) {
        PMSbgjjgsVO pmSalaryPayApplyVO;
        this.logger.info("\u8c03\u7528\u8d22\u52a1\u7684\u751f\u6548\u63a5\u53e3---ejc-profinance\u9879\u76ee---SalaryPayApplyBpmServiceImpl\u7c7b---salaryTakeEffect\u65b9\u6cd5---begin\uff0c\u85aa\u8d44\u5de5\u8d44\u5355ID-{}", (Object)payrollEntity.getId());
        List<PushcwEntity> acActualMny = this.payrollService.getAcActualMny(payrollEntity.getMonth(), payrollEntity.getCompanyId());
        List<PushcwEntity> idCardActualMny = this.payrollService.getIdCardActualMny(payrollEntity.getMonth(), payrollEntity.getCompanyId());
        if (CollectionUtils.isEmpty(acActualMny) || CollectionUtils.isEmpty(idCardActualMny)) {
            this.logger.error("\u6839\u636e\u5de5\u8d44\u5355ID-{}\uff0c\u67e5\u8be2\u4e0d\u5230\u5de5\u8d44\u6570\u636e\uff0c\u65e0\u6cd5\u8c03\u7528\u751f\u6548\u63a5\u53e3", (Object)payrollEntity.getId());
            return CommonResponse.error((String)("\u6839\u636e\u5de5\u8d44\u5355ID-\u3010" + payrollEntity.getId() + "\u3011\u67e5\u8be2\u4e0d\u5230\u5de5\u8d44\u652f\u4ed8\u7533\u8bf7\u6570\u636e\uff0c\u65e0\u6cd5\u8c03\u7528\u751f\u6548\u63a5\u53e3"));
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
        ArrayList<PMGzVO> pmGzVOS = new ArrayList<PMGzVO>();
        ArrayList<PMGzDetailVO> pmGzDetailVOS = new ArrayList<PMGzDetailVO>();
        for (PushcwEntity pushcwEntity : acActualMny) {
            PMGzVO pmSalaryPayApplyVO2 = new PMGzVO();
            pmSalaryPayApplyVO2.setId(IdWorker.getId() + "");
            pmSalaryPayApplyVO2.setAcCode(pushcwEntity.getAcSetCode());
            pmSalaryPayApplyVO2.setAcName(pushcwEntity.getAcSet());
            pmSalaryPayApplyVO2.setYearMonth(sdf.format(pushcwEntity.getMonth()));
            pmSalaryPayApplyVO2.setPmBillId(pushcwEntity.getCode());
            pmSalaryPayApplyVO2.setActualMny(pushcwEntity.getActual());
            pmSalaryPayApplyVO2.setQuoteFlag("N");
            pmGzVOS.add(pmSalaryPayApplyVO2);
        }
        for (PushcwEntity pushcwEntity : idCardActualMny) {
            PMGzDetailVO pmSalaryPayApplyVO2 = new PMGzDetailVO();
            pmSalaryPayApplyVO2.setId(IdWorker.getId() + "");
            pmSalaryPayApplyVO2.setName(pushcwEntity.getDetailEmployeeName());
            pmSalaryPayApplyVO2.setIdCard(pushcwEntity.getIdCard());
            pmSalaryPayApplyVO2.setBankName(pushcwEntity.getBankName());
            pmSalaryPayApplyVO2.setBankCount(pushcwEntity.getBankAccount());
            pmSalaryPayApplyVO2.setBankAddress(pushcwEntity.getBankAddress());
            pmSalaryPayApplyVO2.setPmBillId(pushcwEntity.getCode());
            pmSalaryPayApplyVO2.setActualMny(pushcwEntity.getActual());
            pmSalaryPayApplyVO2.setState("0");
            pmGzDetailVOS.add(pmSalaryPayApplyVO2);
        }
        ((PMGzVO)pmGzVOS.get(0)).setDetailList(pmGzDetailVOS);
        this.logger.info("\u5f00\u59cb\u8c03\u7528PM\u5de5\u8d44\u652f\u4ed8\u7533\u8bf7\u751f\u6548\u63a5\u53e3\uff0c\u63a5\u53e3\u53c2\u6570VO-{}", (Object)pmGzVOS.size());
        CommonResponse res = this.salarySystemApi.salaryTakeEffect(pmGzVOS);
        this.logger.info("\u8c03\u7528PM\u8d44\u91d1\u7684\u751f\u6548\u63a5\u53e3----SalaryPayApplyBpmServiceImpl\u7c7b---salaryTakeEffect\u65b9\u6cd5---end\uff0c\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c-{}", (Object)JSONObject.toJSONString((Object)res));
        if (!res.isSuccess()) {
            return CommonResponse.error((String)("\u5de5\u8d44\u4fe1\u606f\u63a8\u9001\u4e2d\u95f4\u8868\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + res.getMsg()));
        }
        ArrayList<PMSbgjjgsVO> pmSbgjj = new ArrayList<PMSbgjjgsVO>();
        List<JspayableAdjustEntity> sbGjj = this.payrollMapper.getSbGjj(payrollEntity.getMonth(), payrollEntity.getCompanyId());
        for (JspayableAdjustEntity jspayableAdjustEntity : sbGjj) {
            pmSalaryPayApplyVO = new PMSbgjjgsVO();
            PMSbgjjgsVO pmSalaryPayApplyVOGjj = new PMSbgjjgsVO();
            pmSalaryPayApplyVO.setId(IdWorker.getId() + "");
            pmSalaryPayApplyVO.setAcCode(jspayableAdjustEntity.getAcSetCode());
            pmSalaryPayApplyVO.setAcName(jspayableAdjustEntity.getAcSet());
            pmSalaryPayApplyVO.setYearMonth(sdf.format(payrollEntity.getMonth()));
            pmSalaryPayApplyVO.setPersonMny(ComputeUtil.safeAdd((BigDecimal)jspayableAdjustEntity.getPersonEndowmentMny(), (BigDecimal[])new BigDecimal[]{jspayableAdjustEntity.getPersonMedicalMny(), jspayableAdjustEntity.getPersonUnemploymentMny()}));
            pmSalaryPayApplyVO.setCompanyMny(ComputeUtil.safeAdd((BigDecimal)jspayableAdjustEntity.getCompanyBirthMny(), (BigDecimal[])new BigDecimal[]{jspayableAdjustEntity.getCompanyEndowmentMny(), jspayableAdjustEntity.getCompanyInjureMny(), jspayableAdjustEntity.getCompanyMedicalMny(), jspayableAdjustEntity.getCompanyUnemploymentMny()}));
            pmSalaryPayApplyVO.setCompanyId(payrollEntity.getCompanyId() + "");
            pmSalaryPayApplyVO.setType("0");
            pmSalaryPayApplyVO.setQuoteFlag("N");
            pmSbgjj.add(pmSalaryPayApplyVO);
            pmSalaryPayApplyVOGjj.setId(IdWorker.getId() + "");
            pmSalaryPayApplyVOGjj.setAcCode(jspayableAdjustEntity.getAcSetCode());
            pmSalaryPayApplyVOGjj.setAcName(jspayableAdjustEntity.getAcSet());
            pmSalaryPayApplyVOGjj.setYearMonth(sdf.format(payrollEntity.getMonth()));
            pmSalaryPayApplyVOGjj.setPersonMny(jspayableAdjustEntity.getPersonHouseMny());
            pmSalaryPayApplyVOGjj.setCompanyMny(jspayableAdjustEntity.getCompanyHouseMny());
            pmSalaryPayApplyVOGjj.setCompanyId(payrollEntity.getCompanyId() + "");
            pmSalaryPayApplyVOGjj.setType("1");
            pmSalaryPayApplyVOGjj.setQuoteFlag("N");
            pmSbgjj.add(pmSalaryPayApplyVOGjj);
        }
        if (payrollEntity.getCompanyId().equals(909757582997033029L)) {
            List<JspayableAdjustEntity> gs = this.payrollMapper.getGs(payrollEntity.getMonth(), payrollEntity.getCompanyId());
            Iterator iterator = gs.iterator();
            while (iterator.hasNext()) {
                JspayableAdjustEntity pushcwEntity2 = (JspayableAdjustEntity)((Object)iterator.next());
                PMSbgjjgsVO pmSalaryPayApplyVO3 = new PMSbgjjgsVO();
                pmSalaryPayApplyVO3.setId(IdWorker.getId() + "");
                pmSalaryPayApplyVO3.setAcCode(pushcwEntity2.getAcSetCode());
                pmSalaryPayApplyVO3.setAcName(pushcwEntity2.getAcSet());
                pmSalaryPayApplyVO3.setYearMonth(sdf.format(payrollEntity.getMonth()));
                pmSalaryPayApplyVO3.setPersonMny(pushcwEntity2.getCompanyHouseMny());
                pmSalaryPayApplyVO3.setCompanyId(payrollEntity.getCompanyId() + "");
                pmSalaryPayApplyVO3.setType("2");
                pmSalaryPayApplyVO3.setQuoteFlag("N");
                pmSbgjj.add(pmSalaryPayApplyVO3);
            }
        }
        for (JspayableAdjustEntity jspayableAdjustEntity : sbGjj) {
            pmSalaryPayApplyVO = new PMSbgjjgsVO();
            pmSalaryPayApplyVO.setId(IdWorker.getId() + "");
            pmSalaryPayApplyVO.setAcCode(jspayableAdjustEntity.getAcSetCode());
            pmSalaryPayApplyVO.setAcName(jspayableAdjustEntity.getAcSet());
            pmSalaryPayApplyVO.setYearMonth(sdf.format(payrollEntity.getMonth()));
            pmSalaryPayApplyVO.setPersonMny(jspayableAdjustEntity.getCriticalIllnessMny());
            pmSalaryPayApplyVO.setCompanyId(payrollEntity.getCompanyId() + "");
            pmSalaryPayApplyVO.setType("3");
            pmSalaryPayApplyVO.setQuoteFlag("N");
            pmSbgjj.add(pmSalaryPayApplyVO);
        }
        this.logger.info("pmSbgjj\uff0c\u63a5\u53e3\u53c2\u6570VO-{}", (Object)JSONObject.toJSONString(pmSbgjj));
        CommonResponse res1 = this.salarySystemApi.sbTakeEffect(pmSbgjj);
        this.logger.info("\u8c03\u7528PM\u8d44\u91d1\u7684\u751f\u6548\u63a5\u53e3----SalaryPayApplyBpmServiceImpl\u7c7b---sbTakeEffect---end\uff0c\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c-{}", (Object)JSONObject.toJSONString((Object)res1, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        if (!res1.isSuccess()) {
            return CommonResponse.error((String)("\u793e\u4fdd\u516c\u79ef\u91d1\u4e2a\u7a0e\u63a8\u9001\u4e2d\u95f4\u8868\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + res1.getMsg()));
        }
        return res;
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        List<PushcwEntity> acActualMny;
        PayrollEntity payrollEntity = (PayrollEntity)((Object)this.payrollService.selectById(billId));
        if ((BillStateEnum.COMMITED_STATE.getBillStateCode().equals(payrollEntity.getBillState()) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(payrollEntity.getBillState())) && null != payrollEntity && CollectionUtils.isNotEmpty(acActualMny = this.payrollService.getAcActualMny(payrollEntity.getMonth(), payrollEntity.getCompanyId()))) {
            PMGzVO pmSalaryPayApplyVO = new PMGzVO();
            pmSalaryPayApplyVO.setId(IdWorker.getId() + "");
            pmSalaryPayApplyVO.setPmBillId(acActualMny.get(0).getCode());
            CommonResponse res = this.salarySystemApi.salaryAbandonOrClose(pmSalaryPayApplyVO);
            this.logger.info("\u8c03\u7528PM\u5de5\u8d44\u652f\u4ed8\u7684\u5f03\u5ba1\u63a5\u53e3---ejc-profinance\u9879\u76ee---bpmBackCheck\u65b9\u6cd5---end\uff0c\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c-{}", (Object)JSONObject.toJSONString((Object)res, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
            if (!res.isSuccess()) {
                return CommonResponse.error((String)("\u5de5\u8d44\u652f\u4ed8\u7533\u8bf7\u67e5\u8be2\u8d22\u52a1\u7cfb\u7edf\u4e2d\u95f4\u8868\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + res.getMsg()));
            }
            PMGzVO resultVO = (PMGzVO)res.getData();
            if (null != resultVO) {
                if ("Y".equals(resultVO.getQuoteFlag())) {
                    return CommonResponse.error((String)"\u8be5\u7533\u8bf7\u5355\u5df2\u7ecf\u88ab\u8d22\u52a1\u7cfb\u7edf\u5f15\u7528\uff0c\u4e0d\u80fd\u64a4\u56de/\u5f03\u5ba1");
                }
                this.pushcwService.remove((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"period", (Object)payrollEntity.getMonth())).eq((Object)"company_id", (Object)payrollEntity.getCompanyId()));
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

