package com.ejianc.business.salary.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.salary.bean.OfflinePayDetailEntity;
/**
 * 线下支付状态变更
 * 
 * @author generator
 * 
 */
 @TableName("ejc_salary_offline_pay")
public class OfflinePayEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="ac_id")
    private Long acId; // 账套id
    @TableField(value="ac_set")
    private String acSet; // 账套
    @TableField(value="ac_set_code")
    private String acSetCode; // 账套编码
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="month")
    private Date month; // 月份
    @TableField(value="actual_sum_mny")
    private BigDecimal actualSumMny; // 累计实发工资
    @TableField(value="already_sum_mny")
    private BigDecimal alreadySumMny; // 累计已发工资
    @TableField(value="left_sum_mny")
    private BigDecimal leftSumMny; // 累计剩余可发工资
    @TableField(value="company_id")
    private Long companyId; // 汇总单所属公司id
    @TableField(value="company_name")
    private String companyName; // 汇总单所属公司
    @TableField(value="company_org_id")
    private Long companyOrgId; // 所属公司的组织id
    @TableField(value="old_pmBillId")
    private String oldPmbillid; // 单据编号财务
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="offlinePayDetailService")
    private List<OfflinePayDetailEntity> offlinePayDetailList = new ArrayList<>(); // 线下支付-明细
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getAcId() {
        return acId;
    }

    public void setAcId(Long acId) {
        this.acId = acId;
    }
    public String getAcSet() {
        return acSet;
    }

    public void setAcSet(String acSet) {
        this.acSet = acSet;
    }
    public String getAcSetCode() {
        return acSetCode;
    }

    public void setAcSetCode(String acSetCode) {
        this.acSetCode = acSetCode;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getMonth() {
        return month;
    }

    public void setMonth(Date month) {
        this.month = month;
    }
    public BigDecimal getActualSumMny() {
        return actualSumMny;
    }

    public void setActualSumMny(BigDecimal actualSumMny) {
        this.actualSumMny = actualSumMny;
    }
    public BigDecimal getAlreadySumMny() {
        return alreadySumMny;
    }

    public void setAlreadySumMny(BigDecimal alreadySumMny) {
        this.alreadySumMny = alreadySumMny;
    }
    public BigDecimal getLeftSumMny() {
        return leftSumMny;
    }

    public void setLeftSumMny(BigDecimal leftSumMny) {
        this.leftSumMny = leftSumMny;
    }
    public Long getCompanyId() {
        return companyId;
    }

    public void setCompanyId(Long companyId) {
        this.companyId = companyId;
    }
    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }
    public Long getCompanyOrgId() {
        return companyOrgId;
    }

    public void setCompanyOrgId(Long companyOrgId) {
        this.companyOrgId = companyOrgId;
    }
    public String getOldPmbillid() {
        return oldPmbillid;
    }

    public void setOldPmbillid(String oldPmbillid) {
        this.oldPmbillid = oldPmbillid;
    }
    

    public List<OfflinePayDetailEntity> getOfflinePayDetailList() {
        return offlinePayDetailList;
    }

    public void setOfflinePayDetailList(List<OfflinePayDetailEntity> offlinePayDetailList) {
        this.offlinePayDetailList = offlinePayDetailList;
    }
}
