package com.ejianc.business.salary.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.financeintegration.PMPayApply.api.IPMSalaryPayApplyApi;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMSalaryPayApplyDetailVO;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMSalaryPayApplyVO;
import com.ejianc.business.financeintegration.PMSalary.api.IPMSalarySystemApi;
import com.ejianc.business.financeintegration.PMSalary.vo.PMGzDetailVO;
import com.ejianc.business.financeintegration.PMSalary.vo.PMGzVO;
import com.ejianc.business.financeintegration.PMSalary.vo.PMSbgjjgsVO;
import com.ejianc.business.salary.bean.JspayableAdjustEntity;
import com.ejianc.business.salary.bean.PayrollEntity;
import com.ejianc.business.salary.bean.PushcwEntity;
import com.ejianc.business.salary.bean.TaxDetailEntity;
import com.ejianc.business.salary.mapper.PayrollMapper;
import com.ejianc.business.salary.service.IPayrollService;
import com.ejianc.business.salary.service.IPushcwService;
import com.ejianc.business.salary.vo.SourceDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.HttpTookit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("payroll") 
public class PayrollBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IPayrollService payrollService;
	@Autowired
	private IPushcwService pushcwService;

	@Autowired
	private IPMSalarySystemApi salarySystemApi;

	@Autowired
	private PayrollMapper payrollMapper;

	private final String url = "/api/PMSalarySystemApply/salaryTakeEffect";

	@Autowired
	private EnvironmentTools environmentTools;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success("成功！");
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		PayrollEntity payrollEntity = payrollService.selectById(billId);
		if (null == payrollEntity.getPayrollPersonList().get(0).getTotalButuiTaxMny()){
			return CommonResponse.error("请先完成个税计算后再提交！");
		}

		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//推送生成 实付明细表
		PayrollEntity payrollEntity = payrollService.selectById(billId);
		List<PushcwEntity> actualMny = payrollService.getActualMny(payrollEntity.getMonth(), payrollEntity.getCompanyId());
		if (CollectionUtils.isNotEmpty(actualMny)){
			BigDecimal actualSum = BigDecimal.ZERO;
			//校验字段为空
			for (PushcwEntity pushcwEntity : actualMny) {
				if (StringUtils.isBlank(pushcwEntity.getAcSetCode())){
					return CommonResponse.error("账套编号为空！组织名称："+pushcwEntity.getOrgName());
				}
				if (StringUtils.isBlank(pushcwEntity.getBankName())  || StringUtils.isBlank(pushcwEntity.getBankAccount())){
					return CommonResponse.error("银行信息为空！人员名称："+pushcwEntity.getDetailEmployeeName());
				}
				if (pushcwEntity.getActual().compareTo(BigDecimal.ZERO) < 0){
					return CommonResponse.error("实发小于0！人员名称："+pushcwEntity.getDetailEmployeeName());
				}

				pushcwEntity.setMonth(pushcwEntity.getPeriod());
				pushcwEntity.setJspayableDetailId(pushcwEntity.getId());
				pushcwEntity.setId(null);
				pushcwEntity.setSourceType("工资单");
				pushcwEntity.setPayState("0");

				actualSum = actualSum.add(pushcwEntity.getActual());
			}
			if (actualSum.compareTo(payrollEntity.getActualSumMny()) != 0){
				return CommonResponse.error("请联系开发人员！推送到财务的实发金额错误，金额为："+actualSum);
			}
			pushcwService.saveOrUpdateBatch(actualMny);
		}

		return CommonResponse.success();
	}



	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return bpmBackCheck(billId, state, billTypeCode);
	}

	private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
		// 查询当前申请单是否是当前所属合同下的申请单中的最新的一个，如果不是，不允许撤回
		PayrollEntity payrollEntity = payrollService.selectById(billId);


		if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(payrollEntity.getBillState()) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(payrollEntity.getBillState())){

			//判断当前申请单是否在中间表中被引用，如果被引用，则不可撤回
			if (null != payrollEntity){
				List<PushcwEntity> acActualMny = payrollService.getAcActualMny(payrollEntity.getMonth(), payrollEntity.getCompanyId());
				if (CollectionUtils.isNotEmpty(acActualMny)) {
					PMGzVO pmSalaryPayApplyVO = new PMGzVO();
					pmSalaryPayApplyVO.setId(IdWorker.getId()+"");
					pmSalaryPayApplyVO.setPmBillId(acActualMny.get(0).getCode());
					CommonResponse<PMGzVO> res = salarySystemApi.salaryAbandonOrClose(pmSalaryPayApplyVO);
					logger.info("调用PM工资支付的弃审接口---ejc-profinance项目---bpmBackCheck方法---end，接口返回结果-{}", JSONObject.toJSONString(res, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
					if (!res.isSuccess()) {
						return CommonResponse.error("工资支付申请查询财务系统中间表失败，失败原因：" + res.getMsg());
					} else {
						PMGzVO resultVO = res.getData();
						if (null != resultVO) {
							if ("Y".equals(resultVO.getQuoteFlag())) {
								return CommonResponse.error("该申请单已经被财务系统引用，不能撤回/弃审");
							} else {
								//删除实付明细表的数据
								pushcwService.remove(new QueryWrapper<PushcwEntity>()
										.eq("period", payrollEntity.getMonth())
										.eq("company_id",payrollEntity.getCompanyId())
								);
							}
						}
					}
				}
			}
		}

		payrollEntity.setIsPushCw(0);//否。没有推送财务
		payrollService.updateById(payrollEntity);
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		return CommonResponse.success();
	}

}
