/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.salary.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.salary.bean.TaxModifyEntity;
import com.ejianc.business.salary.service.ITaxDetailService;
import com.ejianc.business.salary.service.ITaxModifyService;
import com.ejianc.business.salary.service.ITaxService;
import com.ejianc.business.salary.vo.TaxModifySaveVO;
import com.ejianc.business.salary.vo.TaxModifyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"taxModify"})
public class TaxModifyController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private ITaxModifyService service;
    @Autowired
    private ITaxService taxService;
    @Autowired
    private ITaxDetailService taxDetailService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TaxModifyVO> saveOrUpdate(@RequestBody TaxModifyVO saveOrUpdateVO) {
        TaxModifyEntity entity = (TaxModifyEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, TaxModifyEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        TaxModifyVO vo = (TaxModifyVO)BeanMapper.map((Object)((Object)entity), TaxModifyVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<TaxModifyVO> queryDetail(Long id) {
        TaxModifyEntity entity = (TaxModifyEntity)((Object)this.service.selectById(id));
        TaxModifyVO vo = (TaxModifyVO)BeanMapper.map((Object)((Object)entity), TaxModifyVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TaxModifyVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (TaxModifyVO taxModifyVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<TaxModifyVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TaxModifyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("TaxModify-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refTaxModifyData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<TaxModifyVO>> refTaxModifyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TaxModifyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryDetailByTaxDetailId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<TaxModifyVO>> queryDetailByTaxDetailId(Long taxDetailId) {
        List entityList = this.service.list((Wrapper)new QueryWrapper().eq((Object)"tax_bill_detail_id", (Object)taxDetailId));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", CollectionUtils.isNotEmpty((Collection)entityList) ? BeanMapper.mapList((Iterable)entityList, TaxModifyVO.class) : new ArrayList());
    }

    @RequestMapping(value={"/saveOrUpdateBatchData"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TaxModifySaveVO> saveOrUpdateBatchData(@RequestBody TaxModifySaveVO saveOrUpdateVO) {
        List taxModifyVOList = saveOrUpdateVO.getDetailList();
        if (CollectionUtils.isNotEmpty((Collection)taxModifyVOList)) {
            for (TaxModifyVO taxModifyVO : taxModifyVOList) {
                if (null != taxModifyVO.getId() && null != taxModifyVO.getRowState() && "del".equals(taxModifyVO.getRowState())) {
                    this.service.remove((Wrapper)new LambdaQueryWrapper().eq(BaseEntity::getId, (Object)taxModifyVO.getId()));
                    continue;
                }
                this.service.saveOrUpdate(BeanMapper.map((Object)taxModifyVO, TaxModifyEntity.class), false);
            }
        } else {
            throw new BusinessException("\u5b50\u8868\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        this.taxDetailService.update((Wrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"id", (Object)((TaxModifyVO)taxModifyVOList.get(0)).getTaxBillDetailId())).set((Object)"is_adjust", (Object)"1"));
        return CommonResponse.success((String)"\u6279\u91cf\u65b0\u589e\u6216\u8005\u4fee\u6539\u6210\u529f\uff01", (Object)saveOrUpdateVO);
    }

    @RequestMapping(value={"/taxModifyApportion"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> taxModifyApportion(Long taxId) {
        this.service.taxModifyApportion(taxId);
        return CommonResponse.success((String)"\u4e2a\u7a0e\u8d39\u7528\u5206\u644a\u6210\u529f\uff01");
    }
}

