package com.ejianc.business.salary.controller.warn;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.salary.bean.LockEntity;
import com.ejianc.business.salary.service.ILockService;
import com.ejianc.business.salary.service.IPayableService;
import com.ejianc.business.salary.vo.RosterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


@RestController
@RequestMapping(value = "/payableWarn/")
public class PayableWarnController {
//       * * * 26 * ?            {"dispatchCode":"WARNING000088"}
   //    dispatchWarningHandler
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPayableService service;
    @Autowired
    private ILockService lockService;
    @Autowired
    private IWarnCenterApi warnCenterApi;
    @Autowired
    private IOrgApi iOrgApi;

    //static  String  PC_URL = "/ejc-bid-frontend/#/payableNoUpload?id=";
    static  String  PC_URL = "/ejc-salary-frontend/#/payableUpload";

    @PostMapping(value = "execute")
    public CommonResponse<String> execute(@RequestBody JSONArray jsonParam) {


        logger.info("接收到 Task 参数：{}", jsonParam);
        List<EarlyWarnTransVO> warnList = new ArrayList<>();
        String warnCode = null;

        //非开启状态不推送
        QueryParam paramLock = new QueryParam();
        paramLock.getParams().put("state", new Parameter(QueryParam.EQ, "开启"));
        List<LockEntity> lockEntities = lockService.queryList(paramLock);


        for (int i = 0; i < jsonParam.size(); i++) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            if (CollectionUtils.isNotEmpty(lockEntities)) {
                // 1、根据租户合同纬度，查询合同
                // 2、根据合同的单据所属组织，找到对应的预警设置，也就是这条合同适用于那个设置
                // 3、根据预警设置判断该合同数据属于哪个等级
                // 4、符合等级，则拼接预警数据，并保存到 list
                // 5、发送数据
                QueryParam param = new QueryParam();
                Page<RosterVO> page = new Page<>(1, -1);
                QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);
                List<RosterVO> noUploadPersonList = service.getNoUploadPersonList(page, wrapper);
                Map<Long, List<RosterVO>> collect = noUploadPersonList.stream().collect(Collectors.groupingBy(RosterVO::getOrgId));
                if (CollectionUtils.isNotEmpty(collect.keySet())) {
                    for (Long orgId : collect.keySet()) {
                        List<RosterVO> rosterVOS = collect.get(orgId);
                        JSONObject orgSet = null;
                        JSONObject defaultSet = null;
                        OrgVO orgVO = iOrgApi.getOneById(orgId).getData();
                        if (orgVO == null) {
                            continue;
                        }
                        String innerCode = orgVO.getInnerCode();
                        String[] parentIds = innerCode.split("\\|");
                        /**
                         * 如果当前组织没查到配置，则找其直接上级的配置，
                         * 再找不到，再找其上级，以此类推，
                         * 直至上级为空，还没找到则用默认配置，
                         * 默认配置为空，则不预警
                         * 使用当前组织的 innerCode 进行父级查找
                         * */
                        logger.info("parentIds______" + innerCode);
                        for (int i1 = parentIds.length - 1; i1 >= 0; i1--) {
                            /** 反向查找 */
                            Long pOrgId = Long.parseLong(parentIds[i1]);
                            for (int j = 0; j < orgSettings.size(); j++) {
                                JSONObject set = orgSettings.getJSONObject(j);
                                if (pOrgId.equals(set.getLong("orgId"))) {
                                    orgSet = set;
                                    break;
                                }
                            }
                            if (orgSet != null) {
                                break;
                            }
                        }
                        /** 查找默认的 */
                        for (int i1 = 0; i1 < orgSettings.size(); i1++) {
                            JSONObject set = orgSettings.getJSONObject(i1);
                            if (set.getBoolean("default")) {
                                defaultSet = set;
                                break;
                            }
                        }
                        if (orgSet == null) {
                            /** 使用默认配置 */
                            orgSet = defaultSet;
                        }
                        if (orgSet != null && ListUtil.isNotEmpty(orgSet.getJSONArray("warningSetings"))) {

                            JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                            boolean high = false;
                            boolean meddle = false;
                            boolean low = false;
                            JSONObject useSetHigh = null;
                            JSONObject useSetMeddle = null;
                            JSONObject useSetLow = null;

                            Date now = new Date();
                            for (int i1 = 0; i1 < warningSettings.size(); i1++) {
                                JSONObject set = warningSettings.getJSONObject(i1);
                                if ("高".equals(set.getString("warningLevel"))) {
                                    high = true;
                                    useSetHigh = set;
                                }

                            }

                            if (high || meddle || low) {
                                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                                vo.setBillName(rosterVOS.get(0).getOrgName() + "存在未上传工资人员");
                                vo.setPcTitle("应发工资上传");
                                vo.setPcUrl(PC_URL);
                                vo.setOrgId(orgId);
                                //发送消息，根据角色和组织找人，指定找人组织，多个以半角逗号分割
                                vo.setSendOrgId(orgId + "");
                                vo.setOrgName(rosterVOS.get(0).getOrgName());
                                vo.setSourceId("");
                                vo.setTenantId(tenantId);
                                vo.setWarnSetId(orgSet.getLong("warnId"));
                                vo.setEarlywarnName(orgSet.getString("warnName"));
                                vo.setWarnType(orgSet.getString("warnType"));
                                String tmpContent = orgSet.getString("warningContentTemplate");
                                String nameString = rosterVOS.stream().map(r -> "'" + r.getUserName() + "'").collect(Collectors.joining(","));

                                if (high) {
                                    vo.setWarnLevel("高");
                                    vo.setWarnSetParamId(useSetHigh.getLong("id"));
                                    vo.setEarlywarnContent(
                                            tmpContent.replaceAll("#num#", rosterVOS.size() + "")
                                                    .replaceAll("#list#", nameString).replaceAll("#orgName#", rosterVOS.get(0).getOrgName())
                                    );
                                } else if (meddle) {
                                    vo.setWarnLevel("中");
                                    vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                                    vo.setEarlywarnContent(
                                            tmpContent.replaceAll("#num#", rosterVOS.size() + "")
                                                    .replaceAll("#list#", nameString).replaceAll("#orgName#", rosterVOS.get(0).getOrgName())
                                    );
                                } else {
                                    vo.setWarnLevel("低");
                                    vo.setWarnSetParamId(useSetLow.getLong("id"));
                                    vo.setEarlywarnContent(
                                            tmpContent.replaceAll("#num#", rosterVOS.size() + "")
                                                    .replaceAll("#list#", nameString).replaceAll("#orgName#", rosterVOS.get(0).getOrgName())
                                    );
                                }
                                warnList.add(vo);
                            }
                        }
                    }
                }
            }
        }
        return sendWarnToTask(warnList,warnCode);
    }

    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, String warnCode) {
        CommonResponse<String> warnResp = warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
        if (!warnResp.isSuccess()) {
            logger.error("回调预警任务服务失败，{}", warnResp.getMsg());
            return CommonResponse.error("回调预警任务服务失败" + warnResp.getMsg());
        }
        return CommonResponse.success("任务接受处理成功！");
    }



//
//
//        logger.info("接收到Task参数：{}", jsonParam);
//        String warnCode = null;
//        if (jsonParam.size() > 0) {
//            JSONObject o = jsonParam.getJSONObject(0);
//            Long tenantId = o.getLong("tenantId");
//            warnCode = o.getString("warnCode");
//            JSONArray settings = o.getJSONArray("settings");
//            JSONObject orgSet = null;
//            JSONObject defaultSet = null;
//
//            /** 查找默认的 */
//            for (int i1 = 0; i1 < settings.size(); i1++) {
//                JSONObject set = settings.getJSONObject(i1);
//                if (set.getBoolean("default")) {
//                    defaultSet = set;
//                    break;
//                }
//            }
//            if (orgSet == null) {
//                /** 使用默认配置 */
//                orgSet = defaultSet;
//            }
//            if (orgSet != null && ListUtil.isNotEmpty(orgSet.getJSONArray("warningSetings"))) {
//
//                JSONArray warningSetings = orgSet.getJSONArray("warningSetings");
//                JSONObject billParams = warningSetings.getJSONObject(0);
//                String parameterValue = billParams.getString("parameterValue");
//
//                Integer day = 15;
//                if (StringUtils.isNotEmpty(parameterValue)) {
//                    day = Integer.valueOf(parameterValue);
//                }
//
//                List<EnrollEntity> enrollEntityList = new ArrayList<>();
//                Date now = new Date();
//                List<EnrollEntity> enrollEntities = enrollService.selectEnrollListIsSummary();
//                for (EnrollEntity entity : enrollEntities) {
//                    //如果当前时间-开标日期 > 15天  则将该项目放入列表
//                    if ((now.getTime() - entity.getBiddingDate().getTime()) / (1000 * 60 * 60 * 24) >= day) {
//                        enrollEntityList.add(entity);
//                    }
//                }
//
//
//                if (CollectionUtils.isEmpty(enrollEntityList)) {
//                    logger.error("执行完成，未发现有匹配规则的项目信息！");
//                    return sendWarnToTask(new ArrayList<>(), warnCode);
//                }
//
//                return sendWarnToTask(transToWarnVO(enrollEntityList, orgSet,billParams, day), warnCode);
//            }else {
//                return CommonResponse.error("获取参数失败！");
//            }
//        }
//        return CommonResponse.error("获取参数失败！");
//    }
//
//
//    /**
//     * 调用预警中心API发送预警消息
//     *
//     * @param warnList 预警消息列表
//     * @param warnCode 预警设置Id
//     * @return
//     */
//    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, String warnCode) {
//        CommonResponse<String> warnResp = warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
//        if(!warnResp.isSuccess()) {
//            logger.error("回调预警任务服务失败，{}", warnResp.getMsg());
//            return CommonResponse.error("回调预警任务服务失败" + warnResp.getMsg());
//        }
//
//        return CommonResponse.success("任务接受处理成功！");
//    }
//
//    /**
//     * 将查询出来的业务数据列表按照预警模板转换为预警消息列表
//     *
//     * @param result 业务数据列表
//     * @param orgSet 默认预警设置信息
//     * @return
//     */
//    private List<EarlyWarnTransVO> transToWarnVO(List<EnrollEntity> result, JSONObject orgSet,JSONObject billParams,Integer day) {
//        List<EarlyWarnTransVO> resp = new ArrayList<>();
//        String tmpContent = null;
//        for(EnrollEntity m : result) {
//            EarlyWarnTransVO vo = new EarlyWarnTransVO();
//            //预警显示 单据名称
//            vo.setBillName((null != orgSet.get("moduleName") ? orgSet.get("moduleName").toString() + " - " : "")  + m.getEngineeringName());
//            //单据详情页页签 名称
//            vo.setPcTitle("投标报名");
//            //
//            vo.setPcUrl(PC_URL +m.getId());
//            //组织Id
//            vo.setOrgId(m.getOrgId());
//
//            //发送消息，根据角色和组织找人，指定找人组织，多个以半角逗号分割
//            vo.setSendOrgId(m.getOrgId()+"");
//            //组织名称
//            vo.setOrgName(m.getOrgName());
//            //单据Id
//            vo.setSourceId(m.getBillCode());
//            //单据所属租户Id
//            vo.setTenantId(999999L);
//            //预警等级
//            vo.setWarnLevel(billParams.getString("warningLevel"));
//
//            vo.setWarnSetParamId(billParams.getLong("id"));
//            //预警设置Id
//            vo.setWarnSetId(orgSet.getLong("warnId"));
//            //预警设置名称
//            vo.setEarlywarnName(orgSet.getString("warnName"));
//
//            vo.setWarnType(orgSet.getString("warnType"));
//
//            //预警内容模板
//            tmpContent = orgSet.getString("warningContentTemplate");
//            //预警内容
//            vo.setEarlywarnContent(
//                    tmpContent.replaceAll("#projectName#", m.getEngineeringName())
//                            .replaceAll("#day#", day.toString())
//            );
//
//            resp.add(vo);
//        }
//
//        logger.info("发送预警参数：{}", JSON.toJSONString(resp));
//        return resp;
//    }

}