package com.ejianc.business.salary.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.salary.bean.*;
import com.ejianc.business.salary.service.*;
import com.ejianc.business.salary.vo.AcSetRelateVO;
import com.ejianc.business.salary.vo.PayableDetailVO;
import com.ejianc.business.salary.vo.PayableVO;
import com.ejianc.business.salary.vo.RosterVO;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.salary.mapper.PayableMapper;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 应发工资上传
 * 
 * @author generator
 * 
 */
@Service("payableService")
public class PayableServiceImpl extends BaseServiceImpl<PayableMapper, PayableEntity> implements IPayableService{
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IAcSetRelateService acSetRelateService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPayableDetailService detailService;
    @Autowired
    private IRosterAttendanceService attendanceService;
    @Autowired
    private ICompanyService companyService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    static Long zzyjOrgId = 1502571152583692289L;


    private static final String BILL_CODE = "YFGZSC_CODE";//此处需要根据实际修改

    @Override
    public List<PayableDetailVO> getDetailByOrg(Date month, List<Long> orgIds) {
        return baseMapper.getDetailByOrg(month,orgIds);
    }

    @Override
    public List<PayableDetailVO> getDetail(Date month) {
        return baseMapper.getDetail(month);
    }

    @Override
    public List<RosterVO> getUserByOrgCode(List<String> orgCode1,List<String> orgCode2,Integer month) {
        return baseMapper.getUserByOrgCode(orgCode1,orgCode2,month);
    }

    @Override
    public BigDecimal getSbGjjPersonMoney(String idCard) {
        return baseMapper.getSbGjjPersonMoney(idCard);
    }

    @Override
    public PayableEntity autoCreatePayable(Long orgId) {
        CommonResponse<OrgVO> orgDetail = iOrgApi.getOneById(orgId);
        if (orgDetail.getCode() != 0){
            throw  new BusinessException("根据id查询组织信息失败！"+orgId);
        }
        OrgVO orgVO = orgDetail.getData();

        UserContext userContext = sessionManager.getUserContext();
        Date lastMonth = getLastMonth();
        PayableEntity payableEntity = new PayableEntity();
        payableEntity.setId(com.ejianc.support.idworker.util.IdWorker.getId());


        payableEntity.setEmployeeId(userContext.getUserId());
        payableEntity.setEmployeeName(userContext.getUserName());
        payableEntity.setCorpId(orgVO.getId());
        payableEntity.setCorpCode(orgVO.getCode());
        payableEntity.setCorpName(orgVO.getName());
        payableEntity.setMonth(lastMonth);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM");
        String format = simpleDateFormat.format(lastMonth);
        payableEntity.setPayableName(format+ "-"+orgVO.getName());
        //payableEntity.setPayableType(2);//工资单类型（1正常上传2自动生成3无社保公积金）
        payableEntity.setOrgId(orgVO.getId());
        payableEntity.setOrgCode(orgVO.getCode());
        payableEntity.setOrgName(orgVO.getName());
        payableEntity.setCollectStatus(0);
        payableEntity.setBillState(3);


        AcSetRelateVO acSetRelateVO = acSetRelateService.queryDetailByOrgId(orgId, orgVO.getOrgType(), format, true);

        payableEntity.setAcSet(acSetRelateVO.getAcSet());
        payableEntity.setAcSetCode(acSetRelateVO.getAcSetCode());
        payableEntity.setOrgBillNum(acSetRelateVO.getOrgBillNum()+1);
        payableEntity.setOrgBillRegisterMny(acSetRelateVO.getOrgBillRegisterMny());
        payableEntity.setOrgBillApprovalMny(acSetRelateVO.getOrgBillApprovalMny());
        payableEntity.setLastMonthMny(acSetRelateVO.getLastMonthMny());
        payableEntity.setDifMonthMny(acSetRelateVO.getDifMonthMny());
        payableEntity.setParentOrgCode(acSetRelateVO.getParentOrgCode());
        payableEntity.setParentOrgId(acSetRelateVO.getParentOrgId());
        payableEntity.setParentOrgName(acSetRelateVO.getParentOrgName());
        payableEntity.setSalaryPersonNum(acSetRelateVO.getSalaryPersonNum());
        payableEntity.setAllSalaryPersonNum(acSetRelateVO.getAllSalaryPersonNum());
        payableEntity.setOrgPersonNum(acSetRelateVO.getOrgPersonNum());
        payableEntity.setOrgAllBillRegisterMny(acSetRelateVO.getOrgAllBillRegisterMny());

        payableEntity.setPayableSumMny(BigDecimal.ZERO);
        payableEntity.setOrgSumMny(BigDecimal.ZERO);

        BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(), BeanMapper.map(payableEntity,PayableVO.class));
        CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
        if(billCode.isSuccess()) {
            payableEntity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
        }else{
            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        }
        return   payableEntity ;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public CommonResponse<Boolean> autoCreatePayableDetail(List<RosterEntity> rosterEntities,List<Long> zzyjOrgIds,int payableType) {
        Date lastMonth = getLastMonth();
        //主表map
        HashMap<Long, PayableEntity> longPayableEntityHashMap = new HashMap<>();
        List<PayableDetailEntity> detailListAll = new ArrayList<>();

        //获取人员花名册考勤数据
        List<String> idCardList = rosterEntities.stream().map(RosterEntity::getIdCard).collect(Collectors.toList());

        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMM");
        String format = simpleDateFormat.format(lastMonth);
        Map<String, RosterAttendanceEntity> attendanceMap = new HashMap<>();
        LambdaQueryWrapper<RosterAttendanceEntity> lambdaQueryWrapper2 = new LambdaQueryWrapper<>();
        lambdaQueryWrapper2.in(RosterAttendanceEntity::getIdCard,idCardList);
        lambdaQueryWrapper2.eq(RosterAttendanceEntity::getMonth,format);
        List<RosterAttendanceEntity> list = attendanceService.list(lambdaQueryWrapper2);
        attendanceMap = list.stream().collect(Collectors.toMap(p -> p.getIdCard(), Function.identity(),(v1, v2) -> v2));

        for (RosterEntity rosterEntity:rosterEntities) {
            PayableDetailVO detailVO = new PayableDetailVO();
            //主岗
            if (rosterEntity.getPayOrgId() != null) {//手动主岗的
                detailVO.setDetailOrgId(rosterEntity.getPayOrgId());//
                detailVO.setDetailOrgCode(rosterEntity.getPayOrgCode());
                detailVO.setDetailOrgName(rosterEntity.getPayOrgName());
            } else {
                detailVO.setDetailOrgId(rosterEntity.getOrgId());
                detailVO.setDetailOrgCode(rosterEntity.getOrgCode());
                detailVO.setDetailOrgName(rosterEntity.getOrgName());
            }
            //主岗不属于该公司的组织，则不生成
            if (!zzyjOrgIds.contains(detailVO.getDetailOrgId())){
                logger.info("此人主岗不在该公司下！");
                continue;
            }
            PayableEntity payableEntity;
            if (longPayableEntityHashMap.containsKey(rosterEntity.getPayOrgId() != null?rosterEntity.getPayOrgId():rosterEntity.getOrgId())){
                payableEntity = longPayableEntityHashMap.get(rosterEntity.getPayOrgId() != null?rosterEntity.getPayOrgId():rosterEntity.getOrgId());
            }else {
                payableEntity = this.autoCreatePayable(rosterEntity.getPayOrgId() != null ? rosterEntity.getPayOrgId() : rosterEntity.getOrgId());
                String s = "";
                if (payableType == 2){
                    s= "自动生成主岗工资";
                }else if (payableType == 3){
                    s = "仅社保人员";
                }
                payableEntity.setPayableName(s+"-"+payableEntity.getPayableName());
                payableEntity.setPayableType(payableType);//工资单类型（1正常上传2自动生成3无社保公积金）
                longPayableEntityHashMap.put(payableEntity.getOrgId(),payableEntity);
            }
            List<PayableDetailEntity> payableDetailList = payableEntity.getPayableDetailList();


            detailVO.setId(com.ejianc.support.idworker.util.IdWorker.getId());
            detailVO.setPayableId(payableEntity.getId());

            detailVO.setIdCard(rosterEntity.getIdCard());
            detailVO.setDetailEmployeeName(rosterEntity.getUserName());
            detailVO.setDetailEmployeeId(rosterEntity.getUserId());
            detailVO.setDetailEmployeeCode(rosterEntity.getUserCode());
            detailVO.setJobType("主岗");

            detailVO.setGzffOrgId(detailVO.getDetailOrgId());
            detailVO.setGzffOrgCode(detailVO.getDetailOrgCode());
            detailVO.setGzffOrgName(detailVO.getDetailOrgName());

            detailVO.setJob(rosterEntity.getPostName());
            detailVO.setDept(rosterEntity.getDepartmentName());
            detailVO.setJobLevel(rosterEntity.getJobLevelName());
            detailVO.setSbjnOrgName(rosterEntity.getSocialDepartmentName());
            detailVO.setSbjnOrgCode(rosterEntity.getSocialDepartmentCode());
            detailVO.setIsMove("2");//1-是 2-否

            detailVO.setSbcdCompanyId(rosterEntity.getSocialCompanyId());//社保承担公司
            detailVO.setSbcdCompanyCode(rosterEntity.getSocialCompanyCode());//社保承担公司
            detailVO.setSbcdCompanyName(rosterEntity.getCompanyName());//社保承担公司
            detailVO.setDetailCollectStatus(0);//未汇总


            Map<Long, String> orgids = null;
            //if (zzyjOrgId.equals(rosterEntity.getSocialCompanyId())) {
                orgids = zzyjOrgIds.stream().collect(Collectors.toMap(p -> p, p -> p.toString(), (v1, v2) -> v2));
//            } else {
//                CommonResponse<List<OrgVO>> childrenByParentId = iOrgApi.findChildrenByParentId(rosterEntity.getSocialCompanyId());
//                if (childrenByParentId != null && childrenByParentId.getCode() == 0) {
//                    List<OrgVO> data = childrenByParentId.getData();
//                    if (CollectionUtils.isEmpty(data)) {
//                        throw new BusinessException("获取社保独立开户公司信息失败！");
//                    }
//                    orgids = data.stream().collect(Collectors.toMap(OrgVO::getId, OrgVO::getInnerCode, (v1, v2) -> v2));
//                }
//            }
            if (orgids.containsKey(rosterEntity.getPayOrgId())) {//手动主岗的
                detailVO.setSbcdOrgId(rosterEntity.getPayOrgId());//社保承担单位
                detailVO.setSbcdOrgCode(rosterEntity.getPayOrgCode());
                detailVO.setSbcdOrgName(rosterEntity.getPayOrgName());
            } else if (orgids.containsKey(rosterEntity.getOrgId())) {//
                detailVO.setSbcdOrgId(rosterEntity.getOrgId());//社保承担单位
                detailVO.setSbcdOrgCode(rosterEntity.getOrgCode());
                detailVO.setSbcdOrgName(rosterEntity.getOrgName());
            } else {
                detailVO.setSbcdOrgId(rosterEntity.getSocialCompanyId());//社保承担单位
                detailVO.setSbcdOrgCode(rosterEntity.getSocialCompanyCode());
                detailVO.setSbcdOrgName(rosterEntity.getCompanyName());
            }


            //考勤天数
            if (ObjectUtils.isNotEmpty(attendanceMap.get(rosterEntity.getIdCard()))) {
                detailVO.setWorkDaysLastMonth(attendanceMap.get(rosterEntity.getIdCard()).getActualDay());
            }


            detailVO.setUnWriteOffMny(BigDecimal.ZERO);
            detailVO.setWriteOffMny(BigDecimal.ZERO);
            detailVO.setYfjsMny(BigDecimal.ZERO);
            detailVO.setYfmsMny(BigDecimal.ZERO);
            detailVO.setTaxYfmsMny(BigDecimal.ZERO);

            detailVO.setPerformanceMny(BigDecimal.ZERO);
            detailVO.setWorkYearMny(BigDecimal.ZERO);
            detailVO.setWorkTypeMny(BigDecimal.ZERO);
            detailVO.setCertificateMny(BigDecimal.ZERO);
            detailVO.setTravelMny(BigDecimal.ZERO);
            detailVO.setTrafficMny(BigDecimal.ZERO);
            detailVO.setMealMny(BigDecimal.ZERO);
            detailVO.setBenefitMny(BigDecimal.ZERO);
            detailVO.setHolidayMny(BigDecimal.ZERO);
            detailVO.setYearEndMny(BigDecimal.ZERO);
            detailVO.setOvertimeMny(BigDecimal.ZERO);
            detailVO.setAddMny(BigDecimal.ZERO);
            detailVO.setButtonMny(BigDecimal.ZERO);
            detailVO.setYfjscwMny(BigDecimal.ZERO);
            detailVO.setYfmscwMny(BigDecimal.ZERO);

            //仅社保，则应发工资=社保
            BigDecimal decimal = BigDecimal.ONE;
            if (payableType == 2){
                decimal = new BigDecimal(1);//6月20号又从1.2倍改成了1倍
            }
            BigDecimal sbGjjPersonMoney = this.getSbGjjPersonMoney(detailVO.getIdCard());
            if (sbGjjPersonMoney == null){
                throw new BusinessException(rosterEntity.getUserName()+"没有找到社保数据！");
            }
            detailVO.setYfSalaryMny(
                    sbGjjPersonMoney.multiply(decimal));
            detailVO.setSalaryMny(detailVO.getYfSalaryMny());
            detailVO.setJobMny(detailVO.getYfSalaryMny());

            detailVO.setYfmsSalaryMny(ComputeUtil.safeAdd(detailVO.getYfmsMny(), detailVO.getYfSalaryMny()));//应发+免税
            detailVO.setRowState("edit");

            payableEntity.setPayableSumMny(ComputeUtil.safeAdd(payableEntity.getPayableSumMny(),detailVO.getYfSalaryMny()));

            payableDetailList.add(BeanMapper.map(detailVO,PayableDetailEntity.class));
            detailListAll.add(BeanMapper.map(detailVO,PayableDetailEntity.class));
        }
        if (CollectionUtils.isNotEmpty(longPayableEntityHashMap.values())) {
            this.saveOrUpdateBatch(longPayableEntityHashMap.values());
        }
        if (CollectionUtils.isNotEmpty(detailListAll)) {
            detailService.saveOrUpdateBatch(detailListAll);
        }

        return CommonResponse.success("操作成功,共生成"+longPayableEntityHashMap.values().size()+"个单据！",true);
    }

    @Override
    public List<RosterVO> getNoUploadPersonList(Page<RosterVO> page, QueryWrapper wrapper) {
        return baseMapper.getNoUploadPersonList(page,wrapper);
    }

    @Override
    public List<Long> zzyjOrgIds() {
        List<Long> zzyjOrgids = new ArrayList<>();
        LambdaQueryWrapper<CompanyEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.ne(CompanyEntity::getOrgId, zzyjOrgId);
        List<CompanyEntity> list = companyService.list(lambdaQueryWrapper);
        List<Long> companyOrgIds = list.stream().map(CompanyEntity::getOrgId).collect(Collectors.toList());

        CommonResponse<List<OrgVO>> childrenByParentIds = iOrgApi.findChildrenByParentIds(companyOrgIds);
        CommonResponse<List<OrgVO>> childrenByParentIdZzyj = iOrgApi.findChildrenByParentId(zzyjOrgId);
        if (childrenByParentIds != null && childrenByParentIds.getCode() == 0 && childrenByParentIdZzyj != null && childrenByParentIdZzyj.getCode() == 0){
            List<OrgVO> data = childrenByParentIds.getData();
            List<OrgVO> dataZzyj = childrenByParentIdZzyj.getData();
            if (CollectionUtils.isEmpty(data)){
                throw new BusinessException("获取社保独立开户公司信息失败！");
            }
            HashSet h1 = new HashSet(data.stream().map(OrgVO::getId).collect(Collectors.toList()));
            HashSet h2 = new HashSet(dataZzyj.stream().map(OrgVO::getId).collect(Collectors.toList()));
            h2.removeAll(h1);
            zzyjOrgids.addAll(h2);
        }
        return zzyjOrgids;
    }

    @Override
    public Boolean isZzyjOrg(Long orgId) {
        List<Long> longs = this.zzyjOrgIds();
        if (longs.contains(orgId)){
            return true;
        }else {
            return false;
        }
    }


    public Date getLastMonth(){
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(Calendar.MONTH, -1);
        cal.set(Calendar.DAY_OF_MONTH,
                cal.getActualMinimum(Calendar.DAY_OF_MONTH));
        return  cal.getTime();
    }


}
