package com.ejianc.business.salary.controller;

import java.io.Serializable;

import com.ejianc.business.hr.api.IBaseUserApi;
import com.ejianc.business.hr.vo.salarySystem.SalaryJobDataVO;
import com.ejianc.business.hr.vo.salarySystem.SalaryTransferDataVO;
import com.ejianc.business.salary.bean.RosterJobEntity;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.salary.bean.RosterTransferEntity;
import com.ejianc.business.salary.service.IRosterTransferService;
import com.ejianc.business.salary.vo.RosterTransferVO;

/**
 * 人员花名册-异动
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("rosterTransfer")
public class RosterTransferController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBaseUserApi baseUserApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IRosterTransferService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RosterTransferVO> saveOrUpdate(@RequestBody RosterTransferVO saveOrUpdateVO) {
    	RosterTransferEntity entity = BeanMapper.map(saveOrUpdateVO, RosterTransferEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	RosterTransferVO vo = BeanMapper.map(entity, RosterTransferVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RosterTransferVO> queryDetail(Long id) {
    	RosterTransferEntity entity = service.selectById(id);
    	RosterTransferVO vo = BeanMapper.map(entity, RosterTransferVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RosterTransferVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (RosterTransferVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(RosterTransferVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<RosterTransferVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<RosterTransferEntity> page = service.queryPage(param,false);
        IPage<RosterTransferVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), RosterTransferVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<RosterTransferEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("RosterTransfer-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refRosterTransferData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<RosterTransferVO>> refRosterTransferData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<RosterTransferEntity> page = service.queryPage(param,false);
        IPage<RosterTransferVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), RosterTransferVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }




    /**
     * 人力异动数据同步
     * @param request
     * @return
     */

    @RequestMapping(value = "/hrTranceferSync", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<JSONObject>> hrTranceferSync(HttpServletRequest request) {
        Calendar calendar=Calendar.getInstance();
        calendar.setTime(new Date());
        SimpleDateFormat simpleDateFormat1=new SimpleDateFormat("yyyyMMdd");
        String today = simpleDateFormat1.format(calendar.getTime());
        SimpleDateFormat simpleDateFormat=new SimpleDateFormat("yyyy-MM-dd");

        CommonResponse<List<SalaryTransferDataVO>> listCommonResponse = baseUserApi.queryAllTransferSalary(new QueryParam());
        if (listCommonResponse.getCode() == 0){
            List<SalaryTransferDataVO> data = listCommonResponse.getData();
            if (CollectionUtils.isNotEmpty(data)){
                int i = 1;
                for (SalaryTransferDataVO datum : data) {
                    i++;
                    QueryParam param = new QueryParam();
                    param.getParams().put("hrId", new Parameter(QueryParam.EQ, datum.getHrId()));
                    param.getParams().put("idCard", new Parameter(QueryParam.EQ, datum.getCard()));
                    List<RosterTransferEntity> rosterEntities = service.queryList(param);
                    if (rosterEntities != null && rosterEntities.size()>0){
                        //修改
                        logger.info("数据解析开发---异动修改---,{}",i);
                        RosterTransferEntity rosterEntity = rosterEntities.get(0);
                        rosterEntity.setPostName(datum.getPostName());
                        rosterEntity.setOrgCode(datum.getOrgCode());
                        rosterEntity.setOrgName(datum.getOrgName());
                        rosterEntity.setDepartmentCode(datum.getDepartmentCode());
                        rosterEntity.setDepartmentName(datum.getDepartmentName());
                        if (datum.getStartTime() != null) {
                            rosterEntity.setStartTime(datum.getStartTime());
                        }
                        if (datum.getEndTime() != null) {
                            rosterEntity.setEndTime(datum.getEndTime());
                        }

                        rosterEntity.setEmployeeCode(datum.getEmployeeCode());
                        rosterEntity.setIdCard(datum.getCard());
                        rosterEntity.setSyncDay(Long.parseLong(today));//同步时间
                        rosterEntity.setHrId(datum.getHrId());//人力主键

                        service.saveOrUpdate(rosterEntity);
                    }else {
                        logger.info("数据解析开发---异动新增---,{}",datum.getHrId());
                        RosterTransferEntity rosterEntity = new RosterTransferEntity();
                        rosterEntity.setPostName(datum.getPostName());
                        rosterEntity.setOrgCode(datum.getOrgCode());
                        rosterEntity.setOrgName(datum.getOrgName());
                        rosterEntity.setDepartmentCode(datum.getDepartmentCode());
                        rosterEntity.setDepartmentName(datum.getDepartmentName());
                        if (datum.getStartTime() != null) {
                            rosterEntity.setStartTime(datum.getStartTime());
                        }
                        if (datum.getEndTime() != null) {
                            rosterEntity.setEndTime(datum.getEndTime());
                        }

                        rosterEntity.setEmployeeCode(datum.getEmployeeCode());
                        rosterEntity.setIdCard(datum.getCard());
                        rosterEntity.setSyncDay(Long.parseLong(today));//同步时间
                        rosterEntity.setHrId(datum.getHrId());//人力主键

                        service.saveOrUpdate(rosterEntity);

                    }
                }
            }
        }else {
            return CommonResponse.error("执行失败！");
        }

        return CommonResponse.success("执行成功！");
    }
}
