package com.ejianc.business.salary.service.impl;

import com.ejianc.business.salary.bean.PayableDetailEntity;
import com.ejianc.business.salary.bean.PayableEntity;
import com.ejianc.business.salary.service.IPayableDetailService;
import com.ejianc.business.salary.service.IPayableService;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@Service("payable") 
public class PayableBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IPayableService payableService;
	@Autowired
	private IPayableDetailService payableDetailService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//检验是否满足2倍要求
		PayableEntity payableEntity = payableService.selectById(billId);
		//仅校验正常上传的工资单
		if (payableEntity.getPayableType() == 1 && CollectionUtils.isNotEmpty(payableEntity.getPayableDetailList())){

			for (PayableDetailEntity payableDetailEntity : payableEntity.getPayableDetailList()) {
				//如果是主岗上传工资，则应发工资校验是否大于社保两倍
				if (payableEntity.getOrgId().equals(payableDetailEntity.getDetailOrgId())) {
					BigDecimal sbGjjPersonMoney = payableService.getSbGjjPersonMoney(payableDetailEntity.getIdCard());
					if (sbGjjPersonMoney == null){
						//return CommonResponse.error(payableDetailEntity.getDetailEmployeeName()+"的社保公积金个人部分为空！");
						//没有社保公积金的直接按0处理 -- 25-05-13
						sbGjjPersonMoney = BigDecimal.ZERO;
					}
					if (sbGjjPersonMoney.multiply(new BigDecimal(1.2)).compareTo( payableDetailEntity.getYfSalaryMny()) > 0){
						return CommonResponse.error(payableDetailEntity.getDetailEmployeeName()+"的应发工资("+  payableDetailEntity.getYfSalaryMny() +")应大于社保公积金个人部分("+sbGjjPersonMoney+")1.2倍！");
					}
				}
			}
		}

		//检验工资单下的人员，是否在该组织下重复制单
		if(CollectionUtils.isNotEmpty(payableEntity.getPayableDetailList())){
			QueryParam queryParam = new QueryParam();
			queryParam.getParams().put("orgId", new Parameter(QueryParam.EQ, payableEntity.getOrgId()));
			queryParam.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1,3)));
			queryParam.getParams().put("collectStatus", new Parameter(QueryParam.EQ, 0));
			List<PayableEntity> payableEntities = payableService.queryList(queryParam);
			if(CollectionUtils.isNotEmpty(payableEntities)){
				List<Long> collect = payableEntities.stream().map(s -> s.getId()).collect(Collectors.toList());
				QueryParam queryParam1 = new QueryParam();
				queryParam1.getParams().put("payableId", new Parameter(QueryParam.IN, collect));
				List<PayableDetailEntity> payableDetailEntities = payableDetailService.queryList(queryParam1);
				List<String> idCardList = payableDetailEntities.stream().map(s -> s.getIdCard()).collect(Collectors.toList());
				if (CollectionUtils.isNotEmpty(payableEntity.getPayableDetailList())){
					for (PayableDetailEntity payableDetailEntity : payableEntity.getPayableDetailList()) {
						if (idCardList.contains(payableDetailEntity.getIdCard())) {
							return CommonResponse.error(payableDetailEntity.getDetailEmployeeName()+"本周期内已上传过工资！");
						}
					}
				}
			}
		}
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		PayableEntity payableEntity = payableService.selectById(billId);
		if(1==payableEntity.getCollectStatus()){
			return CommonResponse.error("已汇总的单据不允许弃审");
		}else{
			return CommonResponse.success();
		}
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
