/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.salary.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.financeintegration.PMSalary.api.IPMSalarySystemApi;
import com.ejianc.business.financeintegration.PMSalary.vo.PMGzDetailVO;
import com.ejianc.business.financeintegration.PMSalary.vo.PMGzVO;
import com.ejianc.business.financeintegration.PMSalary.vo.PMSbgjjgsVO;
import com.ejianc.business.salary.bean.JspayableAdjustEntity;
import com.ejianc.business.salary.bean.PayrollEntity;
import com.ejianc.business.salary.bean.PushcwEntity;
import com.ejianc.business.salary.mapper.PayrollMapper;
import com.ejianc.business.salary.service.IPayrollService;
import com.ejianc.business.salary.service.IPushcwService;
import com.ejianc.business.salary.service.IResendService;
import com.ejianc.business.salary.util.RedisUtil;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="payrollService")
public class PayrollServiceImpl
extends BaseServiceImpl<PayrollMapper, PayrollEntity>
implements IPayrollService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPushcwService pushcwService;
    @Autowired
    private IResendService resendService;
    @Autowired
    private IPMSalarySystemApi salarySystemApi;
    @Autowired
    private JedisPool jedisPool;
    private final String OPERATE = "PM_SALARY_PUSH";
    private long retryInterval = 60000L;
    private final int maxRetryTime = 10;

    @Override
    public List<PushcwEntity> getActualMny(Date month, Long companyId) {
        return ((PayrollMapper)this.baseMapper).getActualMny(month, companyId);
    }

    @Override
    public List<PushcwEntity> getAcActualMny(Date month, Long companyId) {
        return ((PayrollMapper)this.baseMapper).getAcActualMny(month, companyId);
    }

    @Override
    public List<PushcwEntity> getIdCardActualMny(Date month, Long companyId) {
        return ((PayrollMapper)this.baseMapper).getIdCardActualMny(month, companyId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void handMQMessage(String salaryPayApplyResultMsg) {
        this.logger.info("profinance\u5904\u7406\u4e2d\u95f4\u5e93\u5de5\u8d44\u652f\u4ed8-\u4fee\u6539\u652f\u4ed8\u72b6\u6001\u7533\u8bf7\u5b9a\u65f6\u4efb\u52a1---SalaryPayApplyServiceImpl--handMQMessage--begin\uff01");
        this.logger.info("\u4ece\u6d88\u606f\u961f\u5217\u4e2d\u83b7\u53d6\u5230\u5f85\u5904\u7406\u7684\u5de5\u8d44\u652f\u4ed8\u7533\u8bf7\u4ed8\u6b3e\u7ed3\u679c\uff1a{}", (Object)salaryPayApplyResultMsg);
        if (StringUtils.isNotBlank((CharSequence)salaryPayApplyResultMsg)) {
            List resultList = JSONObject.parseArray((String)salaryPayApplyResultMsg, PMGzDetailVO.class);
            this.logger.info("\u63a5\u6536\u4e00\u5efa\u8d22\u52a1\u7cfb\u7edf\u7684\u5de5\u8d44\u652f\u4ed8\u4ed8\u6b3e\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)resultList));
            if (CollectionUtils.isNotEmpty((Collection)resultList)) {
                this.updateActualMnyByResultList(resultList);
            }
        }
        this.logger.info("profinance\u5904\u7406\u4e2d\u95f4\u5e93\u5de5\u8d44\u652f\u4ed8-\u4fee\u6539\u652f\u4ed8\u72b6\u6001\u5b9a\u65f6\u4efb\u52a1---SalaryPayApplyServiceImpl--handMQMessage--end\uff01");
    }

    @Override
    public void updateActualMnyDetail(String companyIdAndMonth) {
        ((PayrollMapper)this.baseMapper).updateActualMnyDetail(companyIdAndMonth + "%");
    }

    @Override
    public void updateActualMny(String companyIdAndMonth) {
        ((PayrollMapper)this.baseMapper).updateActualMny(companyIdAndMonth);
    }

    public static void main(String[] args) {
        String s = "909757582997033029-20250819151717-A01001";
        if (s.substring(s.indexOf("-") + 1, s.length()).length() > 6) {
            System.out.println(s);
        }
    }

    @Override
    public void updateActualMnyByResultList(List<PMGzDetailVO> resultList) {
        ArrayList<String> companyIdAndMonthList = new ArrayList<String>();
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        this.logger.info("\u85aa\u8d44\u4ed8\u6b3e\u7ed3\u679c\u6838\u9500resultList\uff1a{}", (Object)resultList.size());
        for (PMGzDetailVO pmGzDetailVO : resultList) {
            QueryParam param = new QueryParam();
            param.getParams().put("code", new Parameter("eq", (Object)pmGzDetailVO.getPmBillId()));
            param.getParams().put("id_card", new Parameter("eq", (Object)pmGzDetailVO.getIdCard()));
            List pushcwEntityList = this.pushcwService.queryList(param);
            if (CollectionUtil.isNotEmpty((Collection)pushcwEntityList)) {
                if ("2".equals(pmGzDetailVO.getState())) {
                    ((PushcwEntity)((Object)pushcwEntityList.get(0))).setAlreadyMny(pmGzDetailVO.getActualMny());
                } else {
                    ((PushcwEntity)((Object)pushcwEntityList.get(0))).setAlreadyMny(BigDecimal.ZERO);
                }
                ((PushcwEntity)((Object)pushcwEntityList.get(0))).setPayState(pmGzDetailVO.getState());
                Date date = null;
                try {
                    this.logger.info("\u85aa\u8d44\u4ed8\u6b3e\u7ed3\u679c\u6838\u9500getIdCard\uff1a{},{}", (Object)pmGzDetailVO.getIdCard(), (Object)pmGzDetailVO.getUpdateTime());
                    date = fmt.parse(pmGzDetailVO.getUpdateTime());
                    ((PushcwEntity)((Object)pushcwEntityList.get(0))).setStateUpdateTime(date);
                }
                catch (ParseException e) {
                    this.logger.error("\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38\uff01{}", (Object)pmGzDetailVO.getUpdateTime());
                    throw new RuntimeException(e);
                }
                this.pushcwService.updateById(pushcwEntityList.get(0));
                companyIdAndMonthList.add(pmGzDetailVO.getPmBillId().substring(0, pmGzDetailVO.getPmBillId().lastIndexOf("-")));
                continue;
            }
            this.logger.info("\u85aa\u8d44\u4ed8\u6b3e\u7ed3\u679c\u6838\u9500\u4fe1\u606f\u4e3a\u7a7a\uff0cid_card\uff1a{}", (Object)pmGzDetailVO.getIdCard());
        }
        List collect = companyIdAndMonthList.stream().distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect)) {
            for (String s : collect) {
                if (s.substring(s.indexOf("-") + 1, s.length()).length() > 6) {
                    this.logger.info("\u5de5\u8d44\u6838\u9500--\u91cd\u53d1\u5355\uff1a{}", (Object)s);
                    this.resendService.changePayState(s);
                    continue;
                }
                this.updateActualMnyDetail(s);
                this.updateActualMny(s);
            }
        }
    }

    @Override
    public CommonResponse<String> salaryTakeEffect(Long billId) {
        PayrollEntity payrollEntity = (PayrollEntity)((Object)this.selectById(billId));
        Jedis jedis = null;
        String key = null;
        boolean lock = false;
        key = this.getLockKey(payrollEntity.getId() + "");
        lock = this.getLock(key, jedis = this.jedisPool.getResource());
        if (!lock) {
            this.logger.error("\u83b7\u53d6\u9501\u5931\u8d25\uff01");
            return CommonResponse.error((String)"\u83b7\u53d6\u9501\u5931\u8d25\uff01\u6570\u636e\u6b63\u5728\u63a8\u9001\u4e2d\uff01");
        }
        if (payrollEntity.getIsPushCw() == 1) {
            this.logger.error("\u8be5\u5355\u636e\u5df2\u7ecf\u63a8\u9001\u8fc7\uff01");
            return CommonResponse.error((String)"\u8be5\u5355\u636e\u5df2\u7ecf\u63a8\u9001\u8fc7\uff01");
        }
        CommonResponse<PMGzVO> res = this.salaryTakeEffect(payrollEntity);
        if (!res.isSuccess()) {
            this.logger.error("\u8c03\u7528PM\u8d22\u52a1\u6a21\u5757\u751f\u6548\u63a5\u53e3\u5931\u8d25\uff01message-{}", (Object)res.getMsg());
            RedisUtil.unLock(jedis, false, key, "PM_SALARY_PUSH");
            this.logger.info("redisKey-{}\u8fdb\u884cRedis\u9501\u91ca\u653e", (Object)key);
            return CommonResponse.error((String)"\u8c03\u7528PM\u8d22\u52a1\u6a21\u5757\u751f\u6548\u63a5\u53e3\u5931\u8d25");
        }
        payrollEntity.setIsPushCw(1);
        this.updateById((Object)payrollEntity);
        RedisUtil.unLock(jedis, false, key, "PM_SALARY_PUSH");
        this.logger.info("redisKey-{}\u8fdb\u884cRedis\u9501\u91ca\u653e", (Object)key);
        return CommonResponse.success((String)"\u5de5\u8d44\u63a8\u9001\u5230\u8d22\u52a1\u6a21\u5757\u6210\u529f\uff01");
    }

    private CommonResponse<PMGzVO> salaryTakeEffect(PayrollEntity payrollEntity) {
        PMGzVO pmSalaryPayApplyVO;
        this.logger.info("\u8c03\u7528\u8d22\u52a1\u7684\u751f\u6548\u63a5\u53e3---ejc-profinance\u9879\u76ee---SalaryPayApplyBpmServiceImpl\u7c7b---salaryTakeEffect\u65b9\u6cd5---begin\uff0c\u85aa\u8d44\u5de5\u8d44\u5355ID-{}", (Object)payrollEntity.getId());
        List<PushcwEntity> acActualMny = this.getAcActualMny(payrollEntity.getMonth(), payrollEntity.getCompanyId());
        List<PushcwEntity> idCardActualMny = this.getIdCardActualMny(payrollEntity.getMonth(), payrollEntity.getCompanyId());
        if (CollectionUtils.isEmpty(acActualMny) || CollectionUtils.isEmpty(idCardActualMny)) {
            this.logger.error("\u6839\u636e\u5de5\u8d44\u5355ID-{}\uff0c\u67e5\u8be2\u4e0d\u5230\u5de5\u8d44\u6570\u636e\uff0c\u65e0\u6cd5\u8c03\u7528\u751f\u6548\u63a5\u53e3", (Object)payrollEntity.getId());
            return CommonResponse.error((String)("\u6839\u636e\u5de5\u8d44\u5355ID-\u3010" + payrollEntity.getId() + "\u3011\u67e5\u8be2\u4e0d\u5230\u5de5\u8d44\u652f\u4ed8\u7533\u8bf7\u6570\u636e\uff0c\u65e0\u6cd5\u8c03\u7528\u751f\u6548\u63a5\u53e3"));
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
        ArrayList<PMGzVO> pmGzVOS = new ArrayList<PMGzVO>();
        ArrayList<PMGzVO> pmGzDetailVOS = new ArrayList<PMGzVO>();
        for (PushcwEntity pushcwEntity : acActualMny) {
            pmSalaryPayApplyVO = new PMGzVO();
            pmSalaryPayApplyVO.setId(IdWorker.getId() + "");
            pmSalaryPayApplyVO.setAcCode(pushcwEntity.getAcSetCode());
            pmSalaryPayApplyVO.setAcName(pushcwEntity.getAcSet());
            pmSalaryPayApplyVO.setYearMonth(sdf.format(pushcwEntity.getMonth()));
            pmSalaryPayApplyVO.setPmBillId(pushcwEntity.getCode());
            pmSalaryPayApplyVO.setActualMny(pushcwEntity.getActual());
            pmSalaryPayApplyVO.setQuoteFlag("N");
            pmGzVOS.add(pmSalaryPayApplyVO);
        }
        for (PushcwEntity pushcwEntity : idCardActualMny) {
            pmSalaryPayApplyVO = new PMGzDetailVO();
            pmSalaryPayApplyVO.setId(IdWorker.getId() + "");
            pmSalaryPayApplyVO.setName(pushcwEntity.getDetailEmployeeName());
            pmSalaryPayApplyVO.setIdCard(pushcwEntity.getIdCard());
            pmSalaryPayApplyVO.setBankName(pushcwEntity.getBankName());
            pmSalaryPayApplyVO.setBankCount(pushcwEntity.getBankAccount());
            pmSalaryPayApplyVO.setBankAddress(pushcwEntity.getBankAddress());
            pmSalaryPayApplyVO.setPmBillId(pushcwEntity.getCode());
            pmSalaryPayApplyVO.setActualMny(pushcwEntity.getActual());
            pmSalaryPayApplyVO.setState("0");
            pmGzDetailVOS.add(pmSalaryPayApplyVO);
        }
        ((PMGzVO)pmGzVOS.get(0)).setDetailList(pmGzDetailVOS);
        this.logger.info("\u5f00\u59cb\u8c03\u7528PM\u5de5\u8d44\u652f\u4ed8\u7533\u8bf7\u751f\u6548\u63a5\u53e3\uff0c\u63a5\u53e3\u53c2\u6570VO-{}", (Object)pmGzVOS.size());
        CommonResponse res = this.salarySystemApi.salaryTakeEffect(pmGzVOS);
        this.logger.info("\u8c03\u7528PM\u8d44\u91d1\u7684\u751f\u6548\u63a5\u53e3----SalaryPayApplyBpmServiceImpl\u7c7b---salaryTakeEffect\u65b9\u6cd5---end\uff0c\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c-{}", (Object)JSONObject.toJSONString((Object)res));
        if (!res.isSuccess()) {
            return CommonResponse.error((String)("\u5de5\u8d44\u4fe1\u606f\u63a8\u9001\u4e2d\u95f4\u8868\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + res.getMsg()));
        }
        if (payrollEntity.getCompanyId().equals(909757582997033029L)) {
            ArrayList<PMSbgjjgsVO> pmSbgjj = new ArrayList<PMSbgjjgsVO>();
            List<JspayableAdjustEntity> sbGjj = ((PayrollMapper)this.baseMapper).getSbGjj(payrollEntity.getMonth(), payrollEntity.getCompanyId());
            for (JspayableAdjustEntity jspayableAdjustEntity : sbGjj) {
                PMSbgjjgsVO pmSalaryPayApplyVO3 = new PMSbgjjgsVO();
                PMSbgjjgsVO pmSalaryPayApplyVOGjj = new PMSbgjjgsVO();
                pmSalaryPayApplyVO3.setId(IdWorker.getId() + "");
                pmSalaryPayApplyVO3.setAcCode(jspayableAdjustEntity.getAcSetCode());
                pmSalaryPayApplyVO3.setAcName(jspayableAdjustEntity.getAcSet());
                pmSalaryPayApplyVO3.setYearMonth(sdf.format(payrollEntity.getMonth()));
                pmSalaryPayApplyVO3.setPersonMny(ComputeUtil.safeAdd((BigDecimal)jspayableAdjustEntity.getPersonEndowmentMny(), (BigDecimal[])new BigDecimal[]{jspayableAdjustEntity.getPersonMedicalMny(), jspayableAdjustEntity.getPersonUnemploymentMny()}));
                pmSalaryPayApplyVO3.setCompanyMny(ComputeUtil.safeAdd((BigDecimal)jspayableAdjustEntity.getCompanyBirthMny(), (BigDecimal[])new BigDecimal[]{jspayableAdjustEntity.getCompanyEndowmentMny(), jspayableAdjustEntity.getCompanyInjureMny(), jspayableAdjustEntity.getCompanyMedicalMny(), jspayableAdjustEntity.getCompanyUnemploymentMny()}));
                pmSalaryPayApplyVO3.setCompanyId(payrollEntity.getCompanyId() + "");
                pmSalaryPayApplyVO3.setType("0");
                pmSalaryPayApplyVO3.setQuoteFlag("N");
                pmSbgjj.add(pmSalaryPayApplyVO3);
                pmSalaryPayApplyVOGjj.setId(IdWorker.getId() + "");
                pmSalaryPayApplyVOGjj.setAcCode(jspayableAdjustEntity.getAcSetCode());
                pmSalaryPayApplyVOGjj.setAcName(jspayableAdjustEntity.getAcSet());
                pmSalaryPayApplyVOGjj.setYearMonth(sdf.format(payrollEntity.getMonth()));
                pmSalaryPayApplyVOGjj.setPersonMny(jspayableAdjustEntity.getPersonHouseMny());
                pmSalaryPayApplyVOGjj.setCompanyMny(jspayableAdjustEntity.getCompanyHouseMny());
                pmSalaryPayApplyVOGjj.setCompanyId(payrollEntity.getCompanyId() + "");
                pmSalaryPayApplyVOGjj.setType("1");
                pmSalaryPayApplyVOGjj.setQuoteFlag("N");
                pmSbgjj.add(pmSalaryPayApplyVOGjj);
            }
            List<JspayableAdjustEntity> gs = ((PayrollMapper)this.baseMapper).getGs(payrollEntity.getMonth(), payrollEntity.getCompanyId());
            for (JspayableAdjustEntity pushcwEntity : gs) {
                PMSbgjjgsVO pmSalaryPayApplyVO2 = new PMSbgjjgsVO();
                pmSalaryPayApplyVO2.setId(IdWorker.getId() + "");
                pmSalaryPayApplyVO2.setAcCode(pushcwEntity.getAcSetCode());
                pmSalaryPayApplyVO2.setAcName(pushcwEntity.getAcSet());
                pmSalaryPayApplyVO2.setYearMonth(sdf.format(payrollEntity.getMonth()));
                pmSalaryPayApplyVO2.setPersonMny(pushcwEntity.getCompanyHouseMny());
                pmSalaryPayApplyVO2.setCompanyId(payrollEntity.getCompanyId() + "");
                pmSalaryPayApplyVO2.setType("2");
                pmSalaryPayApplyVO2.setQuoteFlag("N");
                pmSbgjj.add(pmSalaryPayApplyVO2);
            }
            for (JspayableAdjustEntity pushcwEntity : sbGjj) {
                PMSbgjjgsVO pmSalaryPayApplyVO2 = new PMSbgjjgsVO();
                pmSalaryPayApplyVO2.setId(IdWorker.getId() + "");
                pmSalaryPayApplyVO2.setAcCode(pushcwEntity.getAcSetCode());
                pmSalaryPayApplyVO2.setAcName(pushcwEntity.getAcSet());
                pmSalaryPayApplyVO2.setYearMonth(sdf.format(payrollEntity.getMonth()));
                pmSalaryPayApplyVO2.setPersonMny(pushcwEntity.getCriticalIllnessMny());
                pmSalaryPayApplyVO2.setCompanyId(payrollEntity.getCompanyId() + "");
                pmSalaryPayApplyVO2.setType("3");
                pmSalaryPayApplyVO2.setQuoteFlag("N");
                pmSbgjj.add(pmSalaryPayApplyVO2);
            }
            this.logger.info("pmSbgjj\uff0c\u63a5\u53e3\u53c2\u6570VO-{}", (Object)JSONObject.toJSONString(pmSbgjj));
            CommonResponse commonResponse = this.salarySystemApi.sbTakeEffect(pmSbgjj);
            this.logger.info("\u8c03\u7528PM\u8d44\u91d1\u7684\u751f\u6548\u63a5\u53e3----SalaryPayApplyBpmServiceImpl\u7c7b---sbTakeEffect---end\uff0c\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c-{}", (Object)JSONObject.toJSONString((Object)commonResponse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
            if (!commonResponse.isSuccess()) {
                return CommonResponse.error((String)("\u793e\u4fdd\u516c\u79ef\u91d1\u4e2a\u7a0e\u63a8\u9001\u4e2d\u95f4\u8868\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + commonResponse.getMsg()));
            }
        }
        return res;
    }

    private String getLockKey(String id) {
        this.logger.info("\u5904\u7406\u85aa\u8d44\u7cfb\u7edf\u6570\u636e-{}\u524d\u52a0\u9501", (Object)id);
        String redisKey = "SALARY\u2014\u2014PAYROLL::" + id;
        this.logger.info("\u5bf9\u63a8\u9001\u8d22\u52a1\u64cd\u4f5c\u6dfb\u52a0Redis\u9501\uff0credisKey-{}", (Object)redisKey);
        return redisKey;
    }

    private Boolean getLock(String key, Jedis jedis) {
        this.logger.info("\u4ecejedisPool\u83b7\u53d6jedis\u5bf9\u8c61\uff0cjedis\u5bf9\u8c61-{}", (Object)jedis);
        try {
            return RedisTool.tryLock((Jedis)jedis, (String)key, (String)"PM_SALARY_PUSH", (int)600);
        }
        catch (Exception e) {
            this.logger.info("\u6839\u636e\u952e-{}\u83b7\u53d6reids\u9501\u5f02\u5e38", (Object)key, (Object)e);
            return false;
        }
    }
}

