package com.ejianc.business.salary.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.salary.vo.PayableDetailVO;
import com.ejianc.business.salary.vo.RosterVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.salary.bean.PayableEntity;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 应发工资上传
 * 
 * @author generator
 * 
 */
@Mapper
public interface PayableMapper extends BaseCrudMapper<PayableEntity> {

    List<PayableDetailVO> getDetailByOrg(@Param("month") Date month,@Param("orgIds") List<Long> orgIds);

    List<PayableDetailVO> getDetail(@Param("month") Date month);

    List<RosterVO> getUserByOrgCode(List<String> orgCode1,List<String> orgCode2,Integer month);


    @Select("SELECT SUM(a.person_money) as money from (\n" +
            "SELECT person_money FROM `ejc_salary_roster_accumulation_fund`\n" +
            "where dr = 0 and data_state = '启用' and id_card = #{idCard}\n" +
            "UNION\n" +
            "SELECT IFNULL(person_annuity_money,0)+IFNULL(person_medical_money,0)+IFNULL(person_unemployment_money,0)+IFNULL(critical_illness_mny,0) person_money FROM `ejc_salary_roster_social_security`\n" +
            "where dr = 0 and data_state = '启用' and id_card = #{idCard}\n" +
            ") as a")
    BigDecimal getSbGjjPersonMoney(String idCard);


    List<RosterVO> getNoUploadPersonList(Page<RosterVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper);
}
