package com.ejianc.business.salary.service.impl;

import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.salary.mapper.RosterSocialSecurityMapper;
import com.ejianc.business.salary.bean.RosterSocialSecurityEntity;
import com.ejianc.business.salary.service.IRosterSocialSecurityService;

import java.util.Date;
import java.util.List;

/**
 * 人员花名册-社保
 * 
 * @author generator
 * 
 */
@Service("rosterSocialSecurityService")
public class RosterSocialSecurityServiceImpl extends BaseServiceImpl<RosterSocialSecurityMapper, RosterSocialSecurityEntity> implements IRosterSocialSecurityService{

    @Override
    public void updateSocialSecurity(List<RosterSocialSecurityEntity> entities) {
        for (RosterSocialSecurityEntity entity : entities) {
            QueryParam param = new QueryParam();
            param.getParams().put("idCard", new Parameter(QueryParam.EQ, entity.getIdCard()));
            param.getParams().put("dataState", new Parameter(QueryParam.EQ, "启用"));
            List<RosterSocialSecurityEntity> rosterSocialSecurityEntities = this.queryList(param);

            if (CollectionUtils.isNotEmpty(rosterSocialSecurityEntities)){
                for (RosterSocialSecurityEntity rosterSocialSecurityEntity : rosterSocialSecurityEntities) {
                    rosterSocialSecurityEntity.setDataState("停用");
                    rosterSocialSecurityEntity.setEndTime(new Date());
                }
            }

            entity.setId(null);
            entity.setDataState("启用");
            entity.setStartTime(new Date());
            rosterSocialSecurityEntities.add(entity);
            this.saveOrUpdateBatch(rosterSocialSecurityEntities);
        }
    }

    @Override
    public void updateSocialSecurityState(String socialDepartmentName) {
        if ("郑州一建集团有限公司".equals(socialDepartmentName)){
            //从人力系统离职的时候，社保缴纳单位会变成空的，这时候需要把离职的这部分人启用状态改变。
            // 要不然这个部分人的启用状态永远为启用（通过社保缴纳单位无法关闭）
            baseMapper.updateSocialSecurityStateLz();
        }
        baseMapper.updateSocialSecurityState(socialDepartmentName);
    }

}
