package com.ejianc.business.salary.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMSalaryPayApplyDetailVO;
import com.ejianc.business.financeintegration.PMSalary.api.IPMSalarySystemApi;
import com.ejianc.business.financeintegration.PMSalary.vo.PMGzDetailVO;
import com.ejianc.business.financeintegration.PMSalary.vo.PMGzVO;
import com.ejianc.business.financeintegration.PMSalary.vo.PMSbgjjgsVO;
import com.ejianc.business.profinance.vo.SalaryPayApplyDetailVO;
import com.ejianc.business.salary.bean.JspayableAdjustEntity;
import com.ejianc.business.salary.bean.PushcwEntity;
import com.ejianc.business.salary.dto.PayrollActualMnyDTO;
import com.ejianc.business.salary.service.IPushcwService;
import com.ejianc.business.salary.service.IResendService;
import com.ejianc.business.salary.util.RedisUtil;
import com.ejianc.business.salary.vo.PushcwVO;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.salary.mapper.PayrollMapper;
import com.ejianc.business.salary.bean.PayrollEntity;
import com.ejianc.business.salary.service.IPayrollService;
import org.springframework.transaction.annotation.Transactional;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.text.DateFormat;
/**
 * 工资单-主实体
 * 
 * @author generator
 * 
 */
@Service("payrollService")
public class PayrollServiceImpl extends BaseServiceImpl<PayrollMapper, PayrollEntity> implements IPayrollService{

    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPushcwService pushcwService;
    @Autowired
    private IResendService resendService;
    @Autowired
    private IPMSalarySystemApi salarySystemApi;
    @Autowired
    private JedisPool jedisPool;

    private final String OPERATE = "PM_SALARY_PUSH";

    private long retryInterval = 60000;

    private final int maxRetryTime = 10;
    @Override
    public List<PushcwEntity> getActualMny(Date month, Long companyId) {
        return baseMapper.getActualMny(month,companyId);
    }

    @Override
    public List<PushcwEntity> getAcActualMny(Date month, Long companyId) {
        return baseMapper.getAcActualMny(month,companyId);
    }

    @Override
    public List<PushcwEntity> getIdCardActualMny(Date month, Long companyId) {
        return baseMapper.getIdCardActualMny(month,companyId);
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void handMQMessage(String salaryPayApplyResultMsg) {
        /*
            处理中间库定时任务推送的工资支付数据
            1.修改cwPush表中的明细实付数据
            2.修改payroll-detail表中的实付，已付，剩余可付金额
            2.修改payroll表中的实付，已付，剩余可付金额
         */
        logger.info("profinance处理中间库工资支付-修改支付状态申请定时任务---SalaryPayApplyServiceImpl--handMQMessage--begin！");
        logger.info("从消息队列中获取到待处理的工资支付申请付款结果：{}", salaryPayApplyResultMsg);
        if (StringUtils.isNotBlank(salaryPayApplyResultMsg)){
            List<PMGzDetailVO> resultList = JSONObject.parseArray(salaryPayApplyResultMsg, PMGzDetailVO.class);
            logger.info("接收一建财务系统的工资支付付款结果：{}", JSONObject.toJSONString(resultList));

            if (CollectionUtils.isNotEmpty(resultList)){
                updateActualMnyByResultList(resultList);
            }
        }
        logger.info("profinance处理中间库工资支付-修改支付状态定时任务---SalaryPayApplyServiceImpl--handMQMessage--end！");
    }

    @Override
    public void updateActualMnyDetail(String companyIdAndMonth) {
        baseMapper.updateActualMnyDetail(companyIdAndMonth+"-%");
    }

    @Override
    public void updateActualMny(String companyIdAndMonth) {
        baseMapper.updateActualMny(companyIdAndMonth);
    }



    public static void main(String[] args) {
        String s = "909757582997033029-20250819151717-A01001";
        if (s.substring(s.indexOf("-") + 1, s.length()).length() > 6){
            System.out.println(s);
        }
    }
    @Override
    public void updateActualMnyByResultList(List<PMGzDetailVO> resultList) {
        List<String> companyIdAndMonthList = new ArrayList<>();

        DateFormat fmt =new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

        logger.info("薪资付款结果核销resultList：{}",resultList.size());
        for (PMGzDetailVO pmGzDetailVO : resultList) {
            QueryParam param = new QueryParam();
            param.getParams().put("code", new Parameter(QueryParam.EQ, pmGzDetailVO.getPmBillId()));
            param.getParams().put("id_card", new Parameter(QueryParam.EQ, pmGzDetailVO.getIdCard()));
            List<PushcwEntity> pushcwEntityList = pushcwService.queryList(param);

            if (CollectionUtil.isNotEmpty(pushcwEntityList)){
                //logger.info("薪资付款结果核销pushcwEntityList：{}",pushcwEntityList.get(0).getId());
                if ("2".equals(pmGzDetailVO.getState())){
                    //已支付
                    pushcwEntityList.get(0).setAlreadyMny(pmGzDetailVO.getActualMny());
                }else {
                    pushcwEntityList.get(0).setAlreadyMny(BigDecimal.ZERO);
                }
                pushcwEntityList.get(0).setPayState(pmGzDetailVO.getState());

                Date date = null;
                try {
                    logger.info("薪资付款结果核销getIdCard：{},{}",pmGzDetailVO.getIdCard(),pmGzDetailVO.getUpdateTime());
                    date = fmt.parse(pmGzDetailVO.getUpdateTime());
                    pushcwEntityList.get(0).setStateUpdateTime(date);
                } catch (ParseException e) {
                    logger.error("时间转换异常！{}",pmGzDetailVO.getUpdateTime());
                    throw new RuntimeException(e);
                }


                pushcwService.updateById(pushcwEntityList.get(0));

                companyIdAndMonthList.add(pmGzDetailVO.getPmBillId().substring(0,pmGzDetailVO.getPmBillId().lastIndexOf("-")));
            }else {
                logger.info("薪资付款结果核销信息为空，id_card：{}",pmGzDetailVO.getIdCard());
            }

        }
        List<String> collect = companyIdAndMonthList.stream().distinct().collect(Collectors.toList());

        if (CollectionUtils.isNotEmpty(collect)){
            for (String s : collect) {
                //区分是重发单还是工资单
                if (s.substring(s.indexOf("-") + 1, s.length()).length() > 6){
                    //重发单
                    logger.info("工资核销--重发单：{}",s);
                    resendService.changePayState(s);
                }else {
                    updateActualMnyDetail(s);//先更新子表的实付金额
                    updateActualMny(s);//在更新主表的实付金额
                }
            }
        }
    }

    @Override
    public CommonResponse<String> salaryTakeEffect(Long billId) {
        PayrollEntity payrollEntity = this.selectById(billId);

        //获取锁，防止重复点击推送----开始
        Jedis jedis = null;
        String key = null;
        boolean lock = false;
        key = getLockKey(payrollEntity.getId()+"");
        jedis = jedisPool.getResource();
        lock = getLock(key, jedis);
        //获取锁，防止重复点击推送----结束
            if (!lock) {
                logger.error("获取锁失败！");
                return CommonResponse.error("获取锁失败！数据正在推送中！");
            }

            if (payrollEntity.getIsPushCw() == 1) {
                logger.error("该单据已经推送过！");
                return CommonResponse.error("该单据已经推送过！");
            }


            CommonResponse<PMGzVO> res = salaryTakeEffect(payrollEntity);
            if (!res.isSuccess()) {
                logger.error("调用PM财务模块生效接口失败！message-{}", res.getMsg());

                //释放单据锁
                RedisUtil.unLock(jedis, false, key, OPERATE);
                logger.info("redisKey-{}进行Redis锁释放", key);
                return CommonResponse.error("调用PM财务模块生效接口失败");
            }
            payrollEntity.setIsPushCw(1);//是，已经推送财务
            this.updateById(payrollEntity);
        //释放单据锁
        RedisUtil.unLock(jedis, false, key, OPERATE);
        logger.info("redisKey-{}进行Redis锁释放", key);
        return CommonResponse.success("工资推送到财务模块成功！");






    }
    private CommonResponse<PMGzVO> salaryTakeEffect(PayrollEntity payrollEntity) {
        logger.info("调用财务的生效接口---ejc-profinance项目---SalaryPayApplyBpmServiceImpl类---salaryTakeEffect方法---begin，薪资工资单ID-{}", payrollEntity.getId());
        List<PushcwEntity> acActualMny = this.getAcActualMny(payrollEntity.getMonth(), payrollEntity.getCompanyId());
        List<PushcwEntity> idCardActualMny = this.getIdCardActualMny(payrollEntity.getMonth(), payrollEntity.getCompanyId());

        if (CollectionUtils.isEmpty(acActualMny) || CollectionUtils.isEmpty(idCardActualMny)) {
            logger.error("根据工资单ID-{}，查询不到工资数据，无法调用生效接口", payrollEntity.getId());
            return CommonResponse.error("根据工资单ID-【" + payrollEntity.getId() + "】查询不到工资支付申请数据，无法调用生效接口");
        }
//		logger.info("根据本工资单ID-{}，查询到的本工资支付申请数据-{}", payrollEntity.getId(), JSONObject.toJSONString(payrollEntity, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));

        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");

        ArrayList<PMGzVO> pmGzVOS = new ArrayList<>();
        ArrayList<PMGzDetailVO> pmGzDetailVOS = new ArrayList<>();
        for (PushcwEntity pushcwEntity : acActualMny) {
            PMGzVO pmSalaryPayApplyVO = new PMGzVO();

            pmSalaryPayApplyVO.setId(IdWorker.getId()+"");
            //账套
            pmSalaryPayApplyVO.setAcCode(pushcwEntity.getAcSetCode());
            pmSalaryPayApplyVO.setAcName(pushcwEntity.getAcSet());
            //月份，编号，金额
            pmSalaryPayApplyVO.setYearMonth(sdf.format(pushcwEntity.getMonth()));
            pmSalaryPayApplyVO.setPmBillId(pushcwEntity.getCode());
            pmSalaryPayApplyVO.setActualMny(pushcwEntity.getActual());

            pmSalaryPayApplyVO.setQuoteFlag("N");//初始引用状态 为未引用
            pmGzVOS.add(pmSalaryPayApplyVO);
        }

        for (PushcwEntity pushcwEntity : idCardActualMny) {
            PMGzDetailVO pmSalaryPayApplyVO = new PMGzDetailVO();

            pmSalaryPayApplyVO.setId(IdWorker.getId()+"");
            //姓名
            pmSalaryPayApplyVO.setName(pushcwEntity.getDetailEmployeeName());
            pmSalaryPayApplyVO.setIdCard(pushcwEntity.getIdCard());
            //银行相关
            pmSalaryPayApplyVO.setBankName(pushcwEntity.getBankName());
            pmSalaryPayApplyVO.setBankCount(pushcwEntity.getBankAccount());
            pmSalaryPayApplyVO.setBankAddress(pushcwEntity.getBankAddress());
            //编号，金额
            pmSalaryPayApplyVO.setPmBillId(pushcwEntity.getCode());
            pmSalaryPayApplyVO.setActualMny(pushcwEntity.getActual());
            pmSalaryPayApplyVO.setState("0");//默认未发放
            pmGzDetailVOS.add(pmSalaryPayApplyVO);
        }
        pmGzVOS.get(0).setDetailList(pmGzDetailVOS);


        logger.info("开始调用PM工资支付申请生效接口，接口参数VO-{}", pmGzVOS.size());
        CommonResponse<PMGzVO> res = salarySystemApi.salaryTakeEffect(pmGzVOS);
//		Map<String, String> headers = new HashMap<>();
//		HttpTookit.postByJson(environmentTools.getBaseHost() + url, JSONObject.toJSONString(pmGzVOS), headers, )
        logger.info("调用PM资金的生效接口----SalaryPayApplyBpmServiceImpl类---salaryTakeEffect方法---end，接口返回结果-{}", JSONObject.toJSONString(res));

        if (!res.isSuccess()){
            return  CommonResponse.error("工资信息推送中间表失败，失败原因：" + res.getMsg());
        }

        //只有郑州一建集团的才推送社保、个税数据到中间库 -25-11-10
        if(payrollEntity.getCompanyId().equals(909757582997033029L)) {

            /**
             * 发送社保、公积金、个税数据, 以及大病医保数据
             */
            ArrayList<PMSbgjjgsVO> pmSbgjj = new ArrayList<>();
            List<JspayableAdjustEntity> sbGjj = baseMapper.getSbGjj(payrollEntity.getMonth(), payrollEntity.getCompanyId());
            for (JspayableAdjustEntity pushcwEntity : sbGjj) {
                PMSbgjjgsVO pmSalaryPayApplyVO = new PMSbgjjgsVO();
                PMSbgjjgsVO pmSalaryPayApplyVOGjj = new PMSbgjjgsVO();
                pmSalaryPayApplyVO.setId(IdWorker.getId()+"");
                //账套
                pmSalaryPayApplyVO.setAcCode(pushcwEntity.getAcSetCode());
                pmSalaryPayApplyVO.setAcName(pushcwEntity.getAcSet());
                //月份
                pmSalaryPayApplyVO.setYearMonth(sdf.format(payrollEntity.getMonth()));
                //个人，公司，类型
                pmSalaryPayApplyVO.setPersonMny(ComputeUtil.safeAdd(pushcwEntity.getPersonEndowmentMny(),pushcwEntity.getPersonMedicalMny(),pushcwEntity.getPersonUnemploymentMny()));
                pmSalaryPayApplyVO.setCompanyMny(ComputeUtil.safeAdd(pushcwEntity.getCompanyBirthMny(),pushcwEntity.getCompanyEndowmentMny(),
                        pushcwEntity.getCompanyInjureMny(),pushcwEntity.getCompanyMedicalMny(),pushcwEntity.getCompanyUnemploymentMny()
                ));
                pmSalaryPayApplyVO.setCompanyId(payrollEntity.getCompanyId()+"");
                pmSalaryPayApplyVO.setType("0");
                pmSalaryPayApplyVO.setQuoteFlag("N");//初始引用状态 为未引用

                pmSbgjj.add(pmSalaryPayApplyVO);



                pmSalaryPayApplyVOGjj.setId(IdWorker.getId()+"");
                //账套
                pmSalaryPayApplyVOGjj.setAcCode(pushcwEntity.getAcSetCode());
                pmSalaryPayApplyVOGjj.setAcName(pushcwEntity.getAcSet());
                //月份
                pmSalaryPayApplyVOGjj.setYearMonth(sdf.format(payrollEntity.getMonth()));
                //个人，公司，类型
                pmSalaryPayApplyVOGjj.setPersonMny(pushcwEntity.getPersonHouseMny());
                pmSalaryPayApplyVOGjj.setCompanyMny(pushcwEntity.getCompanyHouseMny());
                pmSalaryPayApplyVOGjj.setCompanyId(payrollEntity.getCompanyId()+"");
                pmSalaryPayApplyVOGjj.setType("1");
                pmSalaryPayApplyVOGjj.setQuoteFlag("N");//初始引用状态 为未引用
                pmSbgjj.add(pmSalaryPayApplyVOGjj);
            }


            List<JspayableAdjustEntity> gs = baseMapper.getGs(payrollEntity.getMonth(), payrollEntity.getCompanyId());
            for (JspayableAdjustEntity pushcwEntity : gs) {
                PMSbgjjgsVO pmSalaryPayApplyVO = new PMSbgjjgsVO();
                pmSalaryPayApplyVO.setId(IdWorker.getId() + "");
                //账套
                pmSalaryPayApplyVO.setAcCode(pushcwEntity.getAcSetCode());
                pmSalaryPayApplyVO.setAcName(pushcwEntity.getAcSet());
                //月份
                pmSalaryPayApplyVO.setYearMonth(sdf.format(payrollEntity.getMonth()));
                //个人，公司，类型
                pmSalaryPayApplyVO.setPersonMny(pushcwEntity.getCompanyHouseMny());

                pmSalaryPayApplyVO.setCompanyId(payrollEntity.getCompanyId() + "");
                pmSalaryPayApplyVO.setType("2");
                pmSalaryPayApplyVO.setQuoteFlag("N");//初始引用状态 为未引用

                pmSbgjj.add(pmSalaryPayApplyVO);

            }


            //List<JspayableAdjustEntity> dbyb = payrollMapper.getDbyb(payrollEntity.getMonth(), payrollEntity.getCompanyId());
            for (JspayableAdjustEntity pushcwEntity : sbGjj) {
                PMSbgjjgsVO pmSalaryPayApplyVO = new PMSbgjjgsVO();
                pmSalaryPayApplyVO.setId(IdWorker.getId()+"");
                //账套
                pmSalaryPayApplyVO.setAcCode(pushcwEntity.getAcSetCode());
                pmSalaryPayApplyVO.setAcName(pushcwEntity.getAcSet());
                //月份
                pmSalaryPayApplyVO.setYearMonth(sdf.format(payrollEntity.getMonth()));
                //个人，公司，类型
                pmSalaryPayApplyVO.setPersonMny(pushcwEntity.getCriticalIllnessMny());

                pmSalaryPayApplyVO.setCompanyId(payrollEntity.getCompanyId()+"");
                pmSalaryPayApplyVO.setType("3");
                pmSalaryPayApplyVO.setQuoteFlag("N");//初始引用状态 为未引用

                pmSbgjj.add(pmSalaryPayApplyVO);

            }


            logger.info("pmSbgjj，接口参数VO-{}", JSONObject.toJSONString(pmSbgjj));
            CommonResponse<PMSbgjjgsVO> res1 = salarySystemApi.sbTakeEffect(pmSbgjj);
            logger.info("调用PM资金的生效接口----SalaryPayApplyBpmServiceImpl类---sbTakeEffect---end，接口返回结果-{}", JSONObject.toJSONString(res1, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
            if (!res1.isSuccess()){
                return  CommonResponse.error("社保公积金个税推送中间表失败，失败原因：" + res1.getMsg());
            }
        }
        return res;
    }




    private String getLockKey(String id) {
        logger.info("处理薪资系统数据-{}前加锁", id);
        // 根据数据维度获取锁，维度：工人工资支付申请单id
        String redisKey = "SALARY——PAYROLL::"+id;
        logger.info("对推送财务操作添加Redis锁，redisKey-{}", redisKey);
        return redisKey;
    }

    private Boolean getLock(String key, Jedis jedis) {
        logger.info("从jedisPool获取jedis对象，jedis对象-{}", jedis);
        try {
            // 在数据维度层面进行加锁
            return RedisTool.tryLock(jedis, key, OPERATE, 600);
        } catch (Exception e) {
            logger.info("根据键-{}获取reids锁异常", key, e);
            return false;
        }
    }


}
