package com.ejianc.business.sale.salesorder.api;

import com.ejianc.business.sale.salesorder.hystrix.GenerateManualshipmentHystrix;
import com.ejianc.business.sale.salesorder.hystrix.MasterDataHystrix;
import com.ejianc.business.sale.salesorder.vo.ProductiontasktransportVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.math.BigDecimal;
import java.util.List;

/**
 * @authoer:禹鹏杰
 * @createDate:2022/6/7
 * @description:分配车辆生成发货管理接口
 */
@FeignClient(name= "ejc-sale-web", url="${common.env.feign-client-url}", path="ejc-sale-web", fallback = GenerateManualshipmentHystrix.class)
public interface IGenerateManualshipmentApi {
    /**
     * @Description 分配车辆生成发货管理
     */
    @PostMapping("/api/sale/generateManualshipment/savelist")
    CommonResponse saveList(@RequestBody List<ProductiontasktransportVO> voList);
    @GetMapping(value = "/api/sale/generateManualshipment/querynetWeight")
    CommonResponse<BigDecimal> queryNetWeight(String unitdistributeId);
}
