package com.ejianc.business.sale.salesorder.api;

import com.ejianc.business.sale.salesorder.hystrix.SalesOrderHystrix;
import com.ejianc.business.sale.salesorder.vo.CloseVO;
import com.ejianc.business.sale.salesorder.vo.ProductInfoVO;
import com.ejianc.business.sale.salesorder.vo.UpdeWeighinginfoApiVO;
import com.ejianc.business.sale.salesorder.vo.WeighinginfoApiVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 中建科技项目rpc服务
 * 关闭生产任务单自动生成销售单
 * @author cJ
 *
 */
@FeignClient(name= "ejc-sale-web", url="${common.env.feign-client-url}", path="ejc-sale-web", fallback = SalesOrderHystrix.class)
public interface ISalesorderApi {

	/**
	 * @Description 自动生成销售单
	 */
	@PostMapping("/api/sale/saleorderApi/saveSaleorder")
	CommonResponse saveSaleorder(@RequestBody CloseVO closeVO);

	/**
	 * @Description 无人值守接口
	 */
	@PostMapping("/api/sale/saleorderApi/saveWeighinginfo")
	CommonResponse<String> saveWeighinginfo(@RequestBody WeighinginfoApiVO weighinginfoApiVO);

	/**
	 * @Description 提供生产任务单工程产品信息接口
	 */
	@PostMapping("/api/sale/saleorderApi/getProductInfo")
	CommonResponse<List<ProductInfoVO>> getProductInfo(@RequestParam String projectId);

	/**
	 * @Description  根据生产任务单id删除销售单 如果已签认该单据不允许删除
	 */
	@PostMapping("/api/sale/saleorderApi/delectSaleorder")
	CommonResponse delectSaleorder(@RequestParam String taskId);

	/**
	 * @Description 无人值守修改净重接口
	 */
	@PostMapping("/api/sale/saleorderApi/updateWeighinginfo")
	CommonResponse<String> updateWeighinginfo(@RequestBody UpdeWeighinginfoApiVO updeWeighinginfoApiVO);


}
