package com.ejianc.business.scene.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * 现场检查项台账
 *
 * @author generator
 */
@ApiModel("现场检查项台账")
public class CheckDetailReportVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private static Map<Integer, String> dangerLevelMap = new HashMap<>();

    static {
        //隐患等级 0、一般；1、严重；2、紧急
        dangerLevelMap.put(0, "一般");
        dangerLevelMap.put(1, "严重");
        dangerLevelMap.put(2, "紧急");
    }

    public static String getDangerLevelName(Integer dangerLevel){
        return dangerLevelMap.get(dangerLevel);
    }

    @ApiModelProperty("检查单id")
    private Long pid;
    @ApiModelProperty("检查单编号")
    private String checkCode;
    @ApiModelProperty("检查项编号")
    private String billCode;
    @ApiModelProperty("检查名称")
    private String checkName;
    @ApiModelProperty("检查日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date checkDate;

    @ApiModelProperty("检查类型 1、综合检查；2、安全检查；3、质量检查；4、进度检查；5、其他检查；")
    private Long checkType;
    @ApiModelProperty("检查类型名称")
    private String checkTypeName;

    private Integer checkLevel; // 检查级别1项目2公司
    private String checkLevelName; // 检查级别1项目2公司
    private Long checkCategoryId; // 检查项分类
    private String checkCategory; // 检查项分类

    @ApiModelProperty("检查项")
    private String checkItem;

    @ApiModelProperty("隐患等级  0、一般；1、严重；2、紧急")
    private Integer dangerLevel;

    @ApiModelProperty("隐患等级  0、一般；1、严重；2、紧急")
    private String dangerLevelName;

    @ApiModelProperty("整改人")
    private String rectificationPerson;

    @ApiModelProperty("检查项整改状态")
    private Integer isReform; // 检查项整改状态：1-待整改，2-已整改、待复查，3-整改合格， 4-整改不合格

    @ApiModelProperty("任务状态")
    private String taskState; // 任务状态

    @ApiModelProperty("整改次数")
    private Integer reformNumber;
    @ApiModelProperty("复查结果")
    private Integer reviewResult;

    @ApiModelProperty("复查结果")
    private String reviewResultName;

    @ApiModelProperty("检查人")
    private String checkPerson;

    @ApiModelProperty("要求完成日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date finishDate;

    @ApiModelProperty("整改日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date reformDate;

    @ApiModelProperty("是否逾期")
    private Integer isOverdue;
    private String part;
    private String memo;

    @ApiModelProperty("是否逾期")
    private String isOverdueName;



    @ApiModelProperty("项目名")
    private String projectName;

    private Integer checkAttr; // 检查属性 1 质量 2安全 3其他
    private String checkAttrName;// 检查属性 1 质量 2安全 3其他

    private String checkItemId; // 检查项

    @ApiModelProperty("实际复查人")
    private String actualReviewer;
    @ApiModelProperty("复查描述")
    private String reviewDescribe;
    @ApiModelProperty("整改描述")
    private String reformMsg;
    @ApiModelProperty("整改信息")
    private String reformNews;
    @ApiModelProperty("单据状态")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @ApiModelProperty("复查信息")
    private String reviewMsg; // 复查信息
    private String reviewPerson; // 复查人
    @ApiModelProperty("复检时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date reviewDate; // 复检时间


    @ApiModelProperty("整改状态排序权重值") // 1已逾期，0 整改不合格， -1 待整改， -2 待复查，-3 整改合格
    private Integer reformStateWeight;

    public String getActualReviewer() {
        return actualReviewer;
    }

    public void setActualReviewer(String actualReviewer) {
        this.actualReviewer = actualReviewer;
    }

    public Integer getReformStateWeight() {
        return reformStateWeight;
    }

    public void setReformStateWeight(Integer reformStateWeight) {
        this.reformStateWeight = reformStateWeight;
    }

    public String getDangerLevelName() {
        return dangerLevelName;
    }

    public String getReviewPerson() {
        return reviewPerson;
    }

    public void setReviewPerson(String reviewPerson) {
        this.reviewPerson = reviewPerson;
    }

    public String getPart() {
        return part;
    }

    public void setPart(String part) {
        this.part = part;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public void setDangerLevelName(String dangerLevelName) {
        this.dangerLevelName = dangerLevelName;
    }

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public String getCheckCode() {
        return checkCode;
    }

    public void setCheckCode(String checkCode) {
        this.checkCode = checkCode;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getCheckName() {
        return checkName;
    }

    public void setCheckName(String checkName) {
        this.checkName = checkName;
    }

    public Date getCheckDate() {
        return checkDate;
    }

    public void setCheckDate(Date checkDate) {
        this.checkDate = checkDate;
    }

    public Long getCheckType() {
        return checkType;
    }

    public void setCheckType(Long checkType) {
        this.checkType = checkType;
    }

    public String getCheckTypeName() {
        return checkTypeName;
    }

    public void setCheckTypeName(String checkTypeName) {
        this.checkTypeName = checkTypeName;
    }

    public Integer getCheckLevel() {
        return checkLevel;
    }

    public void setCheckLevel(Integer checkLevel) {
        this.checkLevel = checkLevel;
        if(checkLevel != null){
           this.checkLevelName = 1 == checkLevel.intValue() ? "项目" : "公司";
        }
    }

    public String getCheckLevelName() {
        return checkLevelName;
    }

    public void setCheckLevelName(String checkLevelName) {
        this.checkLevelName = checkLevelName;
    }

    public Long getCheckCategoryId() {
        return checkCategoryId;
    }

    public void setCheckCategoryId(Long checkCategoryId) {
        this.checkCategoryId = checkCategoryId;
    }

    public String getCheckCategory() {
        return checkCategory;
    }

    public void setCheckCategory(String checkCategory) {
        this.checkCategory = checkCategory;
    }

    public String getCheckItem() {
        return checkItem;
    }

    public void setCheckItem(String checkItem) {
        this.checkItem = checkItem;
    }

    public Integer getDangerLevel() {
        return dangerLevel;
    }

    public void setDangerLevel(Integer dangerLevel) {
        this.dangerLevel = dangerLevel;
        this.dangerLevelName = dangerLevelMap.get(dangerLevel);
    }

    public String getRectificationPerson() {
        return rectificationPerson;
    }

    public void setRectificationPerson(String rectificationPerson) {
        this.rectificationPerson = rectificationPerson;
    }

    public Integer getIsReform() {
        return isReform;
    }

    public void setIsReform(Integer isReform) {
        this.isReform = isReform;
    }

    public String getTaskState() {
        return taskState;
    }

    public void setTaskState(String taskState) {
        this.taskState = taskState;
    }

    public Integer getReformNumber() {
        return reformNumber;
    }

    public void setReformNumber(Integer reformNumber) {
        this.reformNumber = reformNumber;
    }

    public Integer getReviewResult() {
        return reviewResult;
    }

    public void setReviewResult(Integer reviewResult) {
        this.reviewResult = reviewResult;
        if(reviewResult != null && reviewResult.intValue() != 0){
            this.reviewResultName = 1 == reviewResult.intValue() ? "合格" : "不合格";
        }
    }

    public String getReviewResultName() {
        return reviewResultName;
    }

    public void setReviewResultName(String reviewResultName) {
        this.reviewResultName = reviewResultName;
    }

    public String getCheckPerson() {
        return checkPerson;
    }

    public void setCheckPerson(String checkPerson) {
        this.checkPerson = checkPerson;
    }

    public Date getFinishDate() {
        return finishDate;
    }

    public void setFinishDate(Date finishDate) {
        this.finishDate = finishDate;
    }

    public Date getReformDate() {
        return reformDate;
    }

    public void setReformDate(Date reformDate) {
        this.reformDate = reformDate;
    }

    public Integer getIsOverdue() {
        return isOverdue;
    }

    public void setIsOverdue(Integer isOverdue) {
        this.isOverdue = isOverdue;
        if (isOverdue != null) {
            this.isOverdueName = 1 == isOverdue.intValue() ? "是" : "否";
        }
    }

    public String getIsOverdueName() {
        return isOverdueName;
    }

    public void setIsOverdueName(String isOverdueName) {
        this.isOverdueName = isOverdueName;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Integer getCheckAttr() {
        return checkAttr;
    }

    public void setCheckAttr(Integer checkAttr) {
        this.checkAttr = checkAttr;
    }

    public String getCheckAttrName() {
        return checkAttrName;
    }

    public void setCheckAttrName(String checkAttrName) {
        this.checkAttrName = checkAttrName;
    }

    public String getCheckItemId() {
        return checkItemId;
    }

    public void setCheckItemId(String checkItemId) {
        this.checkItemId = checkItemId;
    }

    public String getReviewDescribe() {
        return reviewDescribe;
    }

    public void setReviewDescribe(String reviewDescribe) {
        this.reviewDescribe = reviewDescribe;
    }

    public String getReformMsg() {
        return reformMsg;
    }

    public void setReformMsg(String reformMsg) {
        this.reformMsg = reformMsg;
    }

    public String getReformNews() {
        return reformNews;
    }

    public void setReformNews(String reformNews) {
        this.reformNews = reformNews;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getReviewMsg() {
        return reviewMsg;
    }

    public void setReviewMsg(String reviewMsg) {
        this.reviewMsg = reviewMsg;
    }

    public Date getReviewDate() {
        return reviewDate;
    }

    public void setReviewDate(Date reviewDate) {
        this.reviewDate = reviewDate;
    }
}
