/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scene.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.scene.bean.SceneCheckDetailEntity;
import com.ejianc.business.scene.bean.SceneCheckEntity;
import com.ejianc.business.scene.service.ISceneCheckDetailService;
import com.ejianc.business.scene.service.ISceneCheckService;
import com.ejianc.business.scene.vo.SceneCheckVO;
import com.ejianc.business.scene.vo.util.ReformState;
import com.ejianc.business.scene.vo.util.ReviewState;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"review"})
@Api(value="\u5f85\u590d\u68c0", tags={"\u68c0\u67e5\u5355\u4e3b\u5b50\u8868"})
public class ReviewController {
    @Autowired
    private ISceneCheckService service;
    @Autowired
    private ISceneCheckDetailService sceneCheckDetailService;
    @Autowired
    private IOrgApi iOrgApi;

    @ApiOperation(value="\u5f85\u590d\u68c0\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SceneCheckVO> queryDetail(@RequestParam Long id) {
        SceneCheckEntity entity = (SceneCheckEntity)((Object)this.service.selectById(id));
        SceneCheckVO vo = (SceneCheckVO)BeanMapper.map((Object)((Object)entity), SceneCheckVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u5f85\u590d\u68c0\u5355\u636e")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SceneCheckVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("checkName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("reviewPerson");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getParams().put("reform_status", new Parameter("in", Arrays.asList(ReformState.REVIEW_STATE.getCode(), ReformState.REVIEW_Failed_STATE.getCode())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SceneCheckVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u63d0\u4ea4\u590d\u67e5\u4fe1\u606f")
    @RequestMapping(value={"/submitReviewNews"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SceneCheckVO> submitReviewNews(@ApiParam(name="submitReviewNews", required=true) @RequestBody SceneCheckVO submitVO) {
        boolean update;
        SceneCheckEntity entity = (SceneCheckEntity)((Object)BeanMapper.map((Object)submitVO, SceneCheckEntity.class));
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)entity.getId());
        List<SceneCheckDetailEntity> sceneCheckDetails = entity.getSceneCheckDetails();
        if (CollectionUtils.isNotEmpty(sceneCheckDetails)) {
            List reviewResults = sceneCheckDetails.stream().map(SceneCheckDetailEntity::getReviewResult).collect(Collectors.toList());
            if (reviewResults.contains(ReviewState.REVIEW_Failed_STATE.getCode())) {
                updateWrapper.set(SceneCheckEntity::getReformStatus, (Object)Integer.parseInt(ReviewState.REVIEW_Failed_STATE.getCode()));
            }
            updateWrapper.set(SceneCheckEntity::getReformStatus, (Object)Integer.parseInt(ReformState.REVIEW_Finished_STATE.getCode()));
            updateWrapper.set(SceneCheckEntity::getReviewedNum, (Object)(entity.getReviewedNum() + 1));
        }
        if (update = this.service.update((Object)entity, (Wrapper)updateWrapper)) {
            Long id = entity.getId();
            SceneCheckEntity checkenEntity = (SceneCheckEntity)((Object)this.service.selectById(id));
            SceneCheckVO vo = (SceneCheckVO)BeanMapper.map((Object)((Object)checkenEntity), SceneCheckVO.class);
            return CommonResponse.success((String)"\u63d0\u4ea4\u6210\u529f\uff01", (Object)vo);
        }
        return CommonResponse.success((String)"\u8ddf\u65b0\u5931\u8d25\uff01");
    }

    @ApiOperation(value="\u4fdd\u5b58\u590d\u67e5\u4fe1\u606f")
    @RequestMapping(value={"/saveReviewNews"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SceneCheckVO> saveReviewNews(@ApiParam(name="saveReviewNews", required=true) @RequestBody SceneCheckVO saveVO) {
        SceneCheckEntity entity = (SceneCheckEntity)((Object)BeanMapper.map((Object)saveVO, SceneCheckEntity.class));
        List<SceneCheckDetailEntity> sceneCheckDetails = entity.getSceneCheckDetails();
        if (CollectionUtils.isNotEmpty(sceneCheckDetails)) {
            sceneCheckDetails.forEach(sceneCheckDetail -> {
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.eq(BaseEntity::getId, (Object)sceneCheckDetail.getId());
                updateWrapper.set(SceneCheckDetailEntity::getReviewResult, (Object)sceneCheckDetail.getReviewResult());
                updateWrapper.set(SceneCheckDetailEntity::getReviewDescribe, (Object)sceneCheckDetail.getReviewDescribe());
                updateWrapper.set(SceneCheckDetailEntity::getReviewImgUrl, (Object)sceneCheckDetail.getReviewImgUrl());
            });
        }
        Long id = entity.getId();
        SceneCheckEntity sceneCheck = (SceneCheckEntity)((Object)this.service.selectById(id));
        SceneCheckVO vo = (SceneCheckVO)BeanMapper.map((Object)((Object)sceneCheck), SceneCheckVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }
}

