package com.ejianc.business.scene.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.scene.bean.SceneCheckDetailEntity;
import com.ejianc.business.scene.bean.SceneCheckEntity;
import com.ejianc.business.scene.bean.SceneCheckRecordEntity;
import com.ejianc.business.scene.service.ISceneCheckDetailService;
import com.ejianc.business.scene.service.ISceneCheckRecordService;
import com.ejianc.business.scene.service.ISceneCheckService;
import com.ejianc.business.scene.vo.SceneCheckVO;
import com.ejianc.business.scene.vo.util.MathUtil;
import com.ejianc.business.scene.vo.util.ReformState;
import com.ejianc.business.scene.vo.util.ReviewState;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@Controller
@RequestMapping("review")
@Api(value = "待复检", tags = {"检查单主子表"})
public class ReviewController {

    @Autowired
    private ISceneCheckService service;
    @Autowired
    private ISceneCheckDetailService sceneCheckDetailService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ISceneCheckRecordService sceneCheckRecordService;

    @ApiOperation("待复检查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SceneCheckVO> queryDetail(@RequestParam Long id) {
        SceneCheckEntity entity = service.selectById(id);
        SceneCheckVO vo = BeanMapper.map(entity, SceneCheckVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @ApiOperation("查询待复检单据")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SceneCheckVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("checkName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("reviewPerson");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        //  待复检的（待整改全部提交） 复查不合格的
        param.getParams().put("reform_status", new Parameter(QueryParam.IN, Arrays.asList(ReformState.REVIEW_STATE.getCode(), ReformState.REVIEW_Failed_STATE.getCode())));
        IPage<SceneCheckEntity> page = service.queryPage(param, false);
        IPage<SceneCheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SceneCheckVO.class));
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    @ApiOperation("提交复查信息")
    @RequestMapping(value = "/submitReviewNews", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SceneCheckVO> submitReviewNews(@ApiParam(name = "submitReviewNews", required = true) @RequestBody SceneCheckVO submitVO) {
        SceneCheckEntity entity = BeanMapper.map(submitVO, SceneCheckEntity.class);
        LambdaUpdateWrapper<SceneCheckEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(SceneCheckEntity::getId, entity.getId());
        List<SceneCheckDetailEntity> sceneCheckDetails = entity.getSceneCheckDetails();
        if (CollectionUtils.isNotEmpty(sceneCheckDetails)) {
            List<Integer> reviewResults = sceneCheckDetails.stream().map(SceneCheckDetailEntity::getReviewResult).collect(Collectors.toList());
            //提交是否复查不合格的话
            if (reviewResults.contains(ReviewState.REVIEW_Failed_STATE.getCode())) {
                //复检不合格的话，把整改状态设置为3
                updateWrapper.set(SceneCheckEntity::getReformStatus, Integer.parseInt(ReformState.REVIEW_Failed_STATE.getCode()));
            }
            //合格的个数
            int size = reviewResults.stream().filter(reviewResult -> reviewResult.equals(ReviewState.REVIEW_Finished_STATE.getCode())).collect(Collectors.toList()).size();
            //合格的数等于检查项的数 全部合格
            if (size == sceneCheckDetails.size()) {
                //全部合格的话，整改状态该为reformStatus 设置为4 全部完成
                updateWrapper.set(SceneCheckEntity::getReformStatus, Integer.parseInt(ReformState.REVIEW_Finished_STATE.getCode()));
            }
        }
        //设置已提交
        updateWrapper.set(SceneCheckEntity::getReviewStatus, 1);
        boolean update = service.update(entity, updateWrapper);
        if (update)
        {
            Long id = entity.getId();
            SceneCheckEntity checkenEntity = service.selectById(id);
            SceneCheckVO vo = BeanMapper.map(checkenEntity, SceneCheckVO.class);
            return CommonResponse.success("提交成功！", vo);
        }
        return CommonResponse.error("提交失败！");
    }





    @ApiOperation("保存复查信息")
    @RequestMapping(value = "/saveReviewNews", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SceneCheckVO> saveReviewNews(@ApiParam(name = "saveReviewNews", required = true) @RequestBody SceneCheckVO saveVO) {
        SceneCheckEntity entity = BeanMapper.map(saveVO, SceneCheckEntity.class);
        List<SceneCheckDetailEntity> sceneCheckDetails = entity.getSceneCheckDetails();
        if (CollectionUtils.isNotEmpty(sceneCheckDetails)) {
            sceneCheckDetails.forEach(sceneCheckDetail -> {
                LambdaUpdateWrapper<SceneCheckDetailEntity> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.eq(SceneCheckDetailEntity::getId, sceneCheckDetail.getId());
                //设置，复查结果，复查描述，复查图片 信息
                updateWrapper.set(SceneCheckDetailEntity::getReviewResult,sceneCheckDetail.getReviewResult());
                updateWrapper.set(SceneCheckDetailEntity::getReviewDescribe,sceneCheckDetail.getReviewDescribe());
                updateWrapper.set(SceneCheckDetailEntity::getReviewImgUrl,sceneCheckDetail.getReviewImgUrl());
                sceneCheckDetailService.update(updateWrapper);
            });
            List<Integer> reviewResults = sceneCheckDetails.stream().map(SceneCheckDetailEntity::getReviewResult).collect(Collectors.toList());
           if (CollectionUtils.isNotEmpty(reviewResults)) {
               //复检结果
               LambdaUpdateWrapper<SceneCheckEntity> revieweupdateWrapper = new LambdaUpdateWrapper<>();
               revieweupdateWrapper.set(SceneCheckEntity::getReformStatus,Integer.parseInt(ReviewState.REVIEW_Failed_STATE.getCode()));
               //设置已完成  合格的
               Integer reviewPassSize = reviewResults.stream().filter(item -> item.equals(ReviewState.REVIEW_Finished_STATE.getCode())).collect(Collectors.toList()).size();
               revieweupdateWrapper.set(SceneCheckEntity::getReviewPass,reviewPassSize);
               //以复检的(检查合格,不合格的)
               Integer size = reviewResults.stream().filter(item -> item.equals(ReviewState.REVIEW_Failed_STATE.getCode())||item.equals(ReviewState.REVIEW_Finished_STATE.getCode())).collect(Collectors.toList()).size();
               revieweupdateWrapper.set(SceneCheckEntity::getReviewedNum,size);
               revieweupdateWrapper.eq(SceneCheckEntity::getId, entity.getId());
               boolean update = service.update(revieweupdateWrapper);
           }
        }
        Long id = entity.getId();
        SceneCheckEntity sceneCheck = service.selectById(id);
        SceneCheckVO vo = BeanMapper.map(sceneCheck, SceneCheckVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }
}
