package com.ejianc.business.scene.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.scene.bean.SceneCheckDetailEntity;
import com.ejianc.business.scene.bean.SceneCheckEntity;
import com.ejianc.business.scene.service.ISceneCheckDetailService;
import com.ejianc.business.scene.service.ISceneCheckResultService;
import com.ejianc.business.scene.service.ISceneCheckService;
import com.ejianc.business.scene.vo.SceneCheckVO;
import com.ejianc.business.scene.vo.util.ReviewState;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import groovy.util.IFileNameFinder;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Controller
@RequestMapping("checkResult")
@Api(value = "检查结果", tags = {"检查单主子记录表表"})
public class SceneCheckResultController {

    @Autowired
    private ISceneCheckService service;
    @Autowired
    private ISceneCheckDetailService sceneCheckDetailService;

    @Autowired
    private IOrgApi iOrgApi;

    @ApiOperation("检查结果查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SceneCheckVO> queryDetail(@RequestParam Long id) {
        SceneCheckEntity entity = service.selectById(id);
        SceneCheckVO vo = BeanMapper.map(entity, SceneCheckVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @ApiOperation("查询检查结果列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SceneCheckVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("checkName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("reviewPerson");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        Map<String, Parameter> params = param.getParams();
        if (params.containsKey("overdueNum")) {
            String overdueNum = (String) params.get("overdueNum").getValue();
            if (overdueNum == "1") {
                param.getParams().put("overdueNum", new Parameter(QueryParam.GT, 0));
            }
            if (overdueNum == "0") {
                param.getParams().put("overdueNum", new Parameter(QueryParam.EQ, 0));
            }
        }
        IPage<SceneCheckEntity> page = service.queryPage(param, false);
        IPage<SceneCheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SceneCheckVO.class));
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

}
