package com.ejianc.business.scene.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.scene.bean.SceneCheckDetailEntity;
import com.ejianc.business.scene.bean.SceneCheckEntity;
import com.ejianc.business.scene.service.ISceneCheckDetailService;
import com.ejianc.business.scene.service.ISceneCheckService;
import com.ejianc.business.scene.vo.util.CheckItemReformState;
import com.ejianc.business.scene.vo.util.ReformState;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;

@Service("sceneCheck") 
public class SceneCheckBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private ISceneCheckService sceneCheckService;
    @Autowired
	private ISceneCheckDetailService sceneCheckDetailService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		//检查单提交时，修改复查状态为 1
		SceneCheckEntity sceneCheckEntity = new SceneCheckEntity();
		sceneCheckEntity.setId(billId);
		sceneCheckEntity.setReformStatus(Integer.valueOf(ReformState.Reform_STATE.getCode()));
		sceneCheckService.updateById(sceneCheckEntity);

		//检查单提交时，修改检查项的是否整改状态为 1
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("pid",new Parameter(QueryParam.EQ,billId));
        List<SceneCheckDetailEntity> list = sceneCheckDetailService.queryList(queryParam);
        for (SceneCheckDetailEntity sceneCheckDetail: list) {
            sceneCheckDetail.setIsReform(Integer.valueOf(CheckItemReformState.Reform_STATE.getCode()));
            LambdaUpdateWrapper<SceneCheckDetailEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(SceneCheckDetailEntity::getId,sceneCheckDetail.getId());
            updateWrapper.set(SceneCheckDetailEntity::getIsReform,CheckItemReformState.Reform_STATE.getCode());
            sceneCheckDetailService.update(updateWrapper);
        }
        return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
