package com.ejianc.business.scene.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.scene.bean.SceneCheckDetailEntity;
import com.ejianc.business.scene.bean.SceneCheckEntity;
import com.ejianc.business.scene.bean.SceneCheckRecordEntity;
import com.ejianc.business.scene.mapper.SceneCheckMapper;
import com.ejianc.business.scene.service.ISceneCheckDetailService;
import com.ejianc.business.scene.service.ISceneCheckRecordService;
import com.ejianc.business.scene.service.ISceneCheckService;
import com.ejianc.business.scene.util.CheckItemReformState;
import com.ejianc.business.scene.util.ReformState;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 检查单主表
 * 
 * @author generator
 * 
 */
@Service("sceneCheckService")
public class SceneCheckServiceImpl extends BaseServiceImpl<SceneCheckMapper, SceneCheckEntity> implements ISceneCheckService{

    @Autowired
    private ISceneCheckDetailService sceneCheckDetailService;

    @Autowired
    private ISceneCheckRecordService sceneCheckRecordService;

    /**
     *  检查单提交后的操作
     * @param billId 检查单id
     */
    @Override
    public void checkSubmitHandle(Long billId) {

        if(billId != null){
            SceneCheckEntity sceneCheckEntity = this.selectById(billId);

            //检查单提交后，修改复查状态为 1
            LambdaUpdateWrapper<SceneCheckEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(SceneCheckEntity::getId,billId);
            updateWrapper.set(SceneCheckEntity::getReformStatus,Integer.valueOf(ReformState.REFORM_STATE.getCode()));
            updateWrapper.set(SceneCheckEntity::getReviewItem,sceneCheckEntity.getSceneCheckDetails().size());
            this.update(updateWrapper);

            //检查单提交后 检查项状态改为待整改
            List<SceneCheckDetailEntity> sceneCheckDetails = sceneCheckEntity.getSceneCheckDetails();
            sceneCheckDetails.forEach(d->{
                LambdaUpdateWrapper<SceneCheckDetailEntity> wrapper = new LambdaUpdateWrapper<>();
                wrapper.eq(SceneCheckDetailEntity::getId,d.getId());
                wrapper.set(SceneCheckDetailEntity::getIsReform, CheckItemReformState.REFORM_STATE);
                sceneCheckDetailService.update(wrapper);
            });


            List<SceneCheckRecordEntity> list = new ArrayList<>();
            List<SceneCheckDetailEntity> sceneCheckDetaillist = sceneCheckEntity.getSceneCheckDetails();
            //检查单提交后，生成检查信息记录
            sceneCheckDetaillist.forEach(item->{
                SceneCheckRecordEntity sceneCheckRecord=new SceneCheckRecordEntity();
                sceneCheckRecord.setPid(item.getId());
                sceneCheckRecord.setCheckId(item.getPid());
                //设置操作状态
                sceneCheckRecord.setOperationType(1);
                sceneCheckRecord.setReviewPerson(item.getReviewPerson());
                sceneCheckRecord.setReviewDescribe(item.getReviewDescribe());
                sceneCheckRecord.setReviewResult(item.getReviewResult());
                sceneCheckRecord.setImgIds(item.getProblemImgIds());
                sceneCheckRecord.setCheckPerson(item.getCheckPerson());
                sceneCheckRecord.setCheckItem(item.getCheckItem());
                sceneCheckRecord.setRectificationPerson(item.getRectificationPerson());
                sceneCheckRecord.setRectificationDescribe(item.getReformMsg());
                list.add(sceneCheckRecord);
            });
            sceneCheckRecordService.saveBatch(list,list.size());

        }

    }
}
