package com.ejianc.business.scene.controller;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.scene.bean.SceneCheckDetailEntity;
import com.ejianc.business.scene.bean.SceneCheckEntity;
import com.ejianc.business.scene.bean.SceneCheckRecordEntity;
import com.ejianc.business.scene.service.ISceneCheckDetailService;
import com.ejianc.business.scene.service.ISceneCheckRecordService;
import com.ejianc.business.scene.service.ISceneCheckService;
import com.ejianc.business.scene.vo.SceneCheckVO;
import com.ejianc.business.scene.util.ReformState;
import com.ejianc.business.scene.util.ReviewState;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Controller
@RequestMapping("review")
@Api(value = "待复检", tags = {"检查单主子表"})
public class ReviewController {

    @Autowired
    private ISceneCheckService service;
    @Autowired
    private ISceneCheckDetailService sceneCheckDetailService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ISceneCheckRecordService sceneCheckRecordService;
    @Autowired
    private SessionManager sessionManager;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @ApiOperation("待复检查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SceneCheckVO> queryDetail(@RequestParam Long id) {
        SceneCheckEntity entity = service.selectById(id);
        SceneCheckVO vo = BeanMapper.map(entity, SceneCheckVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @ApiOperation("查询待复检单据")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SceneCheckVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("checkName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("reviewPerson");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        //  待复检的（待整改全部提交） 复查不合格的
        param.getParams().put("reform_status", new Parameter(QueryParam.IN, Arrays.asList(ReformState.REVIEW_STATE.getCode(), ReformState.REVIEW_FAILED_STATE.getCode())));
        IPage<SceneCheckEntity> page = service.queryPage(param, false);
        IPage<SceneCheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SceneCheckVO.class));
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    @ApiOperation("提交复查信息")
    @RequestMapping(value = "/submitReviewNews", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SceneCheckVO> submitReviewNews(@ApiParam(name = "submitReviewNews", required = true) @RequestBody SceneCheckVO param) {
        SceneCheckEntity entity = BeanMapper.map(param, SceneCheckEntity.class);
        LambdaUpdateWrapper<SceneCheckEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(SceneCheckEntity::getId, entity.getId());
        List<SceneCheckDetailEntity> sceneCheckDetails = entity.getSceneCheckDetails();
        if (CollectionUtils.isNotEmpty(sceneCheckDetails)) {
            List<Integer> reviewResults = sceneCheckDetails.stream().map(SceneCheckDetailEntity::getReviewResult).collect(Collectors.toList());
            //提交是否复查不合格的话
            List<SceneCheckRecordEntity> list = new ArrayList<>();
            List<SceneCheckDetailEntity> sceneCheckDetailList=null;
            if (reviewResults.contains(Integer.parseInt(ReviewState.REVIEW_FAILED_STATE.getCode()))) {
                //复检不合格的话，把整改状态设置为3
                updateWrapper.set(SceneCheckEntity::getReformStatus, Integer.parseInt(ReformState.REVIEW_FAILED_STATE.getCode()));
                sceneCheckDetailList = sceneCheckDetails.stream().filter(sceneCheckDetail -> sceneCheckDetail.getReviewResult() == Integer.parseInt(ReviewState.REVIEW_FAILED_STATE.getCode())).collect(Collectors.toList());
            }
            //合格的个数
            int size = reviewResults.stream().filter(reviewResult -> reviewResult==Integer.parseInt(ReviewState.REVIEW_FINISHED_STATE.getCode())).collect(Collectors.toList()).size();
            //合格的数等于检查项的数 全部合格
            if (size == sceneCheckDetails.size()) {
                //全部合格的话，整改状态该为reformStatus 设置为4 全部完成
                updateWrapper.set(SceneCheckEntity::getReformStatus, Integer.parseInt(ReformState.REVIEW_FINISHED_STATE.getCode()));
                //设置复检信息
                sceneCheckDetailList = sceneCheckDetails.stream().filter(sceneCheckDetail -> sceneCheckDetail.getReviewResult() == Integer.parseInt(ReviewState.REVIEW_FINISHED_STATE.getCode())).collect(Collectors.toList());
            }
            //生成复查信息
            sceneCheckDetailList.forEach(item->{
                SceneCheckRecordEntity sceneCheckRecord=new SceneCheckRecordEntity();
                sceneCheckRecord.setPid(item.getId());
                sceneCheckRecord.setCheckId(item.getPid());
                //设置操作状态
                sceneCheckRecord.setOperationType(3);
                sceneCheckRecord.setReviewPerson(item.getReviewPerson());
                sceneCheckRecord.setReviewDescribe(item.getReviewDescribe());
                sceneCheckRecord.setReviewResult(item.getReviewResult());
                sceneCheckRecord.setImgIds(item.getReviewImgIds());
                sceneCheckRecord.setCheckPerson(item.getCheckPerson());
                sceneCheckRecord.setCheckItem(item.getCheckItem());
                sceneCheckRecord.setRectificationPerson(item.getRectificationPerson());
                sceneCheckRecord.setRectificationDescribe(item.getReformMsg());
                list.add(sceneCheckRecord);
            });
            sceneCheckRecordService.saveBatch(list,list.size());

            //设置（检查结果）复查信息
            sceneCheckDetails.forEach(item->{
                LambdaUpdateWrapper<SceneCheckDetailEntity> updateReviewMsgWrapper = new LambdaUpdateWrapper<>();
                updateReviewMsgWrapper.eq(SceneCheckDetailEntity::getId, item.getId());
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String dateTime=df.format(new Date());
                String reviewDescribe="";
                if (StringUtils.isNotEmpty(item.getReviewDescribe())) {
                    reviewDescribe = item.getReviewDescribe();
                }
                updateReviewMsgWrapper.set(SceneCheckDetailEntity::getReviewMsg,item.getReviewPerson()+"-"+dateTime+"-"+reviewDescribe);
                Integer reviewResult = item.getReviewResult();
                sceneCheckDetailService.update(updateReviewMsgWrapper);
            });
        }
        //设置已提交
        updateWrapper.set(SceneCheckEntity::getReviewStatus, 1);
        boolean update = service.update(entity, updateWrapper);
        if (update) {
            Long id = entity.getId();
            SceneCheckEntity checkenEntity = service.selectById(id);
            SceneCheckVO vo = BeanMapper.map(checkenEntity, SceneCheckVO.class);
            return CommonResponse.success("提交成功！", vo);
        }
        return CommonResponse.error("提交失败！");
    }





    @ApiOperation("保存复查信息")
    @RequestMapping(value = "/saveReviewNews", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SceneCheckVO> saveReviewNews(@ApiParam(name = "saveReviewNews", required = true) @RequestBody SceneCheckVO param) {
        SceneCheckEntity entity = BeanMapper.map(param, SceneCheckEntity.class);
        List<SceneCheckDetailEntity> sceneCheckDetails = entity.getSceneCheckDetails();
        if (CollectionUtils.isNotEmpty(sceneCheckDetails)) {
            sceneCheckDetails.forEach(sceneCheckDetail -> {
                LambdaUpdateWrapper<SceneCheckDetailEntity> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.eq(SceneCheckDetailEntity::getId, sceneCheckDetail.getId());
                //设置，复查结果，复查描述，复查图片 信息
                updateWrapper.set(SceneCheckDetailEntity::getReviewResult,sceneCheckDetail.getReviewResult());
                updateWrapper.set(SceneCheckDetailEntity::getReviewDescribe,sceneCheckDetail.getReviewDescribe());
                updateWrapper.set(SceneCheckDetailEntity::getReviewImgIds,sceneCheckDetail.getReviewImgIds());
                updateWrapper.set(SceneCheckDetailEntity::getReviewImgUrl,sceneCheckDetail.getReviewImgUrl());
                //复检状态不合格的 整改状态该为3

                if (sceneCheckDetail.getReviewResult().equals(2)) {
                    updateWrapper.set(SceneCheckDetailEntity::getIsReform,4);
                }
                //设置（检查结果）复查信息
                String reviewPerson = sceneCheckDetail.getReviewPerson();
                String reviewDescribe="";
                if (StringUtils.isNotEmpty(sceneCheckDetail.getReviewDescribe()))
                {
                    reviewDescribe = sceneCheckDetail.getReviewDescribe();
                }
                updateWrapper.set(SceneCheckDetailEntity::getReviewMsg,reviewPerson+"-"+reviewDescribe);
                sceneCheckDetailService.update(updateWrapper);
            });

            //分组
            Map<Integer, List<SceneCheckDetailEntity>> reviewMap = sceneCheckDetails.stream().filter(item->item.getReviewResult()!=null).collect(Collectors.groupingBy(SceneCheckDetailEntity::getReviewResult));

            if (!reviewMap.isEmpty()) {
               //复检结果
               LambdaUpdateWrapper<SceneCheckEntity> revieweupdateWrapper = new LambdaUpdateWrapper<>();
                String code = ReviewState.REVIEW_FINISHED_STATE.getCode();
                //设置已完成  合格的
                int reviewFinished=0;
                if (reviewMap.containsKey(Integer.parseInt(ReviewState.REVIEW_FINISHED_STATE.getCode()))) {
                     reviewFinished = reviewMap.get(Integer.parseInt(ReviewState.REVIEW_FINISHED_STATE.getCode())).size();
                    revieweupdateWrapper.set(SceneCheckEntity::getReviewPass,reviewFinished);
                }
                //设置已复查（合格不合格的）
                if (reviewMap.containsKey(Integer.parseInt(ReviewState.REVIEW_FAILED_STATE.getCode()))) {
                    int reviewFailed = reviewMap.get(Integer.parseInt(ReviewState.REVIEW_FAILED_STATE.getCode())).size();
                    revieweupdateWrapper.set(SceneCheckEntity::getReviewedNum,reviewFinished+reviewFailed);
                }
                revieweupdateWrapper.eq(SceneCheckEntity::getId, entity.getId());
               boolean update = service.update(revieweupdateWrapper);
           }
        }
        Long id = entity.getId();
        SceneCheckEntity sceneCheck = service.selectById(id);
        SceneCheckVO vo = BeanMapper.map(sceneCheck, SceneCheckVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }


}
