package com.ejianc.business.scene.controller;

import cn.hutool.json.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.scene.bean.SceneCheckDetailEntity;
import com.ejianc.business.scene.bean.SceneCheckEntity;
import com.ejianc.business.scene.service.ISceneCheckDetailService;
import com.ejianc.business.scene.service.ISceneCheckService;
import com.ejianc.business.scene.util.CheckItemReformState;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@RestController
@RequestMapping(value = "/overdueWarn/")
public class OverdueWarnController {
    @Autowired
    private ISceneCheckService service;
    @Autowired
    private ISceneCheckDetailService sceneCheckDetailService;

    @PostMapping(value = "overdue")
    public CommonResponse<String> payMnyWarn(@RequestBody JSONObject jsonParam) {
        List<SceneCheckEntity> sceneChecks = service.list();
        List<Long> ids = sceneChecks.stream().map(SceneCheckEntity::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        if (CollectionUtils.isNotEmpty(ids)) {
            queryParam.getParams().put("pid", new Parameter(QueryParam.IN,ids));
            List<SceneCheckDetailEntity> sceneCheckDetailEntities = sceneCheckDetailService.queryList(queryParam,false);
            sceneCheckDetailEntities.forEach(item->{
                Integer isReform = item.getIsReform();
                boolean reformState = isReform.equals(Integer.parseInt(CheckItemReformState.REFORM_STATE.getCode()));
                boolean reformFailedState = isReform.equals(Integer.parseInt(CheckItemReformState.REFORM_FAILED_STATE.getCode()));
                ArrayList<Object> list = new ArrayList<>();
                //当前时间大于完成时间 整改状态为：待整改、复查不合格时 视为 逾期  2、任务项的最新整改日期大于要求完成日期时；  以上2个条件满足一个即为逾期
                LambdaUpdateWrapper<SceneCheckDetailEntity> updateWrapper = new LambdaUpdateWrapper<>();
                if ((new Date().getTime()>item.getFinishDate().getTime()&&(reformFailedState)||reformState)||(item.getReformDate().getTime()>item.getFinishDate().getTime())) {
                    updateWrapper.eq(SceneCheckDetailEntity::getId, item.getId());
                    //设置 是否逾期 1 逾期 0不逾期
                    updateWrapper.set(SceneCheckDetailEntity::getIsOverdue,1);
                    //设置检查结果的状态
                    if (Integer.parseInt(CheckItemReformState.REFORM_STATE.getCode())==item.getIsReform()) {
                        updateWrapper.set(SceneCheckDetailEntity::getTaskState,CheckItemReformState.REFORM_STATE.getDescription()+"-"+"逾期");
                    }
                    if (Integer.parseInt(CheckItemReformState.REVIEW_REFORM_STATE.getCode())==item.getIsReform()) {
                        updateWrapper.set(SceneCheckDetailEntity::getTaskState,CheckItemReformState.REVIEW_REFORM_STATE.getDescription()+"-"+"逾期");
                    }
                    if (Integer.parseInt(CheckItemReformState.REFORM_SUCCESS_STATE.getCode())==item.getIsReform()) {
                        updateWrapper.set(SceneCheckDetailEntity::getTaskState,CheckItemReformState.REFORM_SUCCESS_STATE.getDescription()+"-"+"逾期");
                    }
                    if (Integer.parseInt(CheckItemReformState.REFORM_FAILED_STATE.getCode())==item.getIsReform()) {
                        updateWrapper.set(SceneCheckDetailEntity::getTaskState,CheckItemReformState.REFORM_FAILED_STATE.getDescription()+"-"+"逾期");
                    }
                }
                else {
                    updateWrapper.eq(SceneCheckDetailEntity::getId, item.getId());
                    //设置 是否逾期 1 逾期 0不逾期
                    updateWrapper.set(SceneCheckDetailEntity::getIsOverdue,0);
                    //设置检查结果的状态
                    if (Integer.parseInt(CheckItemReformState.REFORM_STATE.getCode())==item.getIsReform()) {
                        updateWrapper.set(SceneCheckDetailEntity::getTaskState,CheckItemReformState.REFORM_STATE.getDescription());
                    }
                    if (Integer.parseInt(CheckItemReformState.REVIEW_REFORM_STATE.getCode())==item.getIsReform()) {
                        updateWrapper.set(SceneCheckDetailEntity::getTaskState,CheckItemReformState.REVIEW_REFORM_STATE.getDescription());
                    }
                    if (Integer.parseInt(CheckItemReformState.REFORM_SUCCESS_STATE.getCode())==item.getIsReform()) {
                        updateWrapper.set(SceneCheckDetailEntity::getTaskState,CheckItemReformState.REFORM_SUCCESS_STATE.getDescription());
                    }
                    if (Integer.parseInt(CheckItemReformState.REFORM_FAILED_STATE.getCode())==item.getIsReform()) {
                        updateWrapper.set(SceneCheckDetailEntity::getTaskState,CheckItemReformState.REFORM_FAILED_STATE.getDescription());
                    }
                }
                sceneCheckDetailService.update(updateWrapper);
            });

        }

        //再次查询 设置逾期数
        List<SceneCheckEntity> sceneCheckList = service.list();
        sceneCheckList.forEach(item->{
            //逾期状态等于1的
            QueryParam querySceneCheckDetailParam = new QueryParam();
            querySceneCheckDetailParam.getParams().put("pid", new Parameter(QueryParam.EQ,item.getId()));
            querySceneCheckDetailParam.getParams().put("is_overdue", new Parameter(QueryParam.EQ,1));
            List<SceneCheckDetailEntity> list = sceneCheckDetailService.queryList(querySceneCheckDetailParam,false);
            if (CollectionUtils.isNotEmpty(list)) {
                //设置逾期数
                LambdaUpdateWrapper<SceneCheckEntity> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.eq(SceneCheckEntity::getId, item.getId());
                updateWrapper.set(SceneCheckEntity::getOverdueNum,list.size());
                service.update(updateWrapper);
            }
        });
        return CommonResponse.success("跟新成功！");

    }
}
