package com.ejianc.business.scene.bean;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.scene.bean.SceneCheckDetailEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 检查单主表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_scene_check")
public class SceneCheckEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名
    @TableField(value="check_name")
    private String checkName; // 检查名称
    @TableField(value="check_type")
    private Long checkType; // 检查类型
    @TableField(value="check_type_name")
    private String checkTypeName;
    @TableField(value="check_id")
    private String checkId; // 检查人id
    @TableField(value="check_person")
    private String checkPerson; // 检查人
    @TableField(value="check_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date checkDate; // 检查日期
    @TableField(value="reform_finish_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date reformFinishDate; // 整改完成日期
    @TableField(value="finish_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date finishDate; // 要求完成日期
    @TableField(value="reform_duty_id")
    private String reformDutyId; // 整改责任人id
    @TableField(value="reform_duty_person")
    private String reformDutyPerson; // 整改责任人
    @TableField(value="review_id")
    private String reviewId; // 复查人id
    @TableField(value="review_person")
    private String reviewPerson; // 复查人
    @TableField(value="review_item")
    private Integer reviewItem; // 复查项
    @TableField(value="reviewed_num")
    private Integer reviewedNum; // 已复查数量
    @TableField(value="review_pass")// 复查合格的数量
    private Integer reviewPass;
    @TableField(value="notif_relevant_id")
    private String notifRelevantId; // 通知相关人员id
    @TableField(value="notif_relevant_person")
    private String notifRelevantPerson; // 通知相关人员
    @TableField(value="review_status")
    private Integer reviewStatus; // 复查状态：0-自由态，1-已提交
    @TableField(value ="reform_status")
    private Integer reformStatus;

    @TableField(value="overdue_num")
    private Integer overdueNum; // 逾期数量
    @TableField(value="remarks")
    private String remarks; // 备注
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="sceneCheckDetailService",pidName ="pid")
    private List<SceneCheckDetailEntity> sceneCheckDetails = new ArrayList<>(); // 检查单待检复检子表



    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目id
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织id
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织id
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 检查名称
     */
    public String getCheckName() {
        return checkName;
    }

    /**
     * 检查名称
     */
    public void setCheckName(String checkName) {
        this.checkName = checkName;
    }
    /**
     * 检查类型 1、综合检查；2、安全检查；3、质量检查；4、进度检查；5、其他检查；
     */
    public Long getCheckType() {
        return checkType;
    }

    /**
     * 检查类型
     */
    public void setCheckType(Long checkType) {
        this.checkType = checkType;
    }

    public String getCheckTypeName() {
        return checkTypeName;
    }

    public void setCheckTypeName(String checkTypeName) {
        this.checkTypeName = checkTypeName;
    }

    /**
     * 检查人id
     */
    public String getCheckId() {
        return checkId;
    }

    /**
     * 检查人id
     */
    public void setCheckId(String checkId) {
        this.checkId = checkId;
    }
    /**
     * 检查人
     */
    public String getCheckPerson() {
        return checkPerson;
    }

    /**
     * 检查人
     */
    public void setCheckPerson(String checkPerson) {
        this.checkPerson = checkPerson;
    }
    /**
     * 检查日期
     */
    public java.util.Date getCheckDate() {
        return checkDate;
    }

    /**
     * 检查日期
     */
    public void setCheckDate(java.util.Date checkDate) {
        this.checkDate = checkDate;
    }
    /**
     * 整改完成日期
     */
    public java.util.Date getReformFinishDate() {
        return reformFinishDate;
    }

    /**
     * 整改完成日期
     */
    public void setReformFinishDate(java.util.Date reformFinishDate) {
        this.reformFinishDate = reformFinishDate;
    }
    /**
     * 要求完成日期
     */
    public java.util.Date getFinishDate() {
        return finishDate;
    }

    /**
     * 要求完成日期
     */
    public void setFinishDate(java.util.Date finishDate) {
        this.finishDate = finishDate;
    }
    /**
     * 整改责任人id
     */
    public String getReformDutyId() {
        return reformDutyId;
    }

    /**
     * 整改责任人id
     */
    public void setReformDutyId(String reformDutyId) {
        this.reformDutyId = reformDutyId;
    }
    /**
     * 整改责任人
     */
    public String getReformDutyPerson() {
        return reformDutyPerson;
    }

    /**
     * 整改责任人
     */
    public void setReformDutyPerson(String reformDutyPerson) {
        this.reformDutyPerson = reformDutyPerson;
    }

    /**
     * 复查人id
     */
    public String getReviewId() {
        return reviewId;
    }

    /**
     * 复查人id
     */
    public void setReviewId(String reviewId) {
        this.reviewId = reviewId;
    }
    /**
     * 复查人
     */
    public String getReviewPerson() {
        return reviewPerson;
    }

    /**
     * 复查人
     */
    public void setReviewPerson(String reviewPerson) {
        this.reviewPerson = reviewPerson;
    }
    /**
     * 复查项
     */
    public Integer getReviewItem() {
        return reviewItem;
    }

    /**
     * 复查项
     */
    public void setReviewItem(Integer reviewItem) {
        this.reviewItem = reviewItem;
    }
    /**
     * 已复查数量
     */
    public Integer getReviewedNum() {
        return reviewedNum;
    }

    /**
     * 已复查数量
     */
    public void setReviewedNum(Integer reviewedNum) {
        this.reviewedNum = reviewedNum;
    }
    /**
     * 已复查合格数量
     */
    public Integer getReviewPass() {
        return reviewPass;
    }
    /**
     * 已复查合格数量
     */
    public void setReviewPass(Integer reviewePass) {
        this.reviewPass = reviewePass;
    }

    /**
     * 通知相关人员id
     */
    public String getNotifRelevantId() {
        return notifRelevantId;
    }

    /**
     * 通知相关人员id
     */
    public void setNotifRelevantId(String notifRelevantId) {
        this.notifRelevantId = notifRelevantId;
    }
    /**
     * 通知相关人员
     */
    public String getNotifRelevantPerson() {
        return notifRelevantPerson;
    }

    /**
     * 通知相关人员
     */
    public void setNotifRelevantPerson(String notifRelevantPerson) {
        this.notifRelevantPerson = notifRelevantPerson;
    }
    /**
     * 复查状态：0-自由态，1-已提交
     */
    public Integer getReviewStatus() {
        return reviewStatus;
    }

    /**
     * 复查状态：0-自由态，1-已提交
     */
    public void setReviewStatus(Integer reviewStatus) {
        this.reviewStatus = reviewStatus;
    }
    /**
     *  整改状态
     */
    public Integer getReformStatus() {
        return reformStatus;
    }
    /**
     *  整改状态
     */
    public void setReformStatus(Integer reformStatus) {
        this.reformStatus = reformStatus;
    }

    /**
     * 逾期数量
     */
    public Integer getOverdueNum() {
        return overdueNum;
    }

    /**
     * 逾期数量
     */
    public void setOverdueNum(Integer overdueNum) {
        this.overdueNum = overdueNum;
    }
    /**
     * 备注
     */
    public String getRemarks() {
        return remarks;
    }

    /**
     * 备注
     */
    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    /**
     * 检查单待检复检子表
     */
    public List<SceneCheckDetailEntity> getSceneCheckDetails() {
        return sceneCheckDetails;
    }
    /**
     * 检查单待检复检子表
     */
    public void setSceneCheckDetails(List<SceneCheckDetailEntity> sceneCheckDetails) {
        this.sceneCheckDetails = sceneCheckDetails;
    }
}
