/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scene.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.scene.bean.SceneCheckDetailEntity;
import com.ejianc.business.scene.service.ISceneCheckDetailService;
import com.ejianc.business.scene.util.CheckItemReformState;
import com.ejianc.business.scene.vo.SceneCheckDetailVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"reform"})
@Api(value="\u5f85\u590d\u67e5", tags={"\u68c0\u67e5\u5355\u4e3b\u5b50\u8868"})
public class ReformController {
    @Autowired
    private ISceneCheckDetailService sceneCheckDetailService;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "SCENE_CHECK_DETAIL_CODE";

    @ApiOperation(value="\u5f85\u590d\u68c0\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SceneCheckDetailVO> queryDetail(@RequestParam Long id) {
        SceneCheckDetailEntity entity = (SceneCheckDetailEntity)((Object)this.sceneCheckDetailService.selectById(id));
        SceneCheckDetailVO vo = (SceneCheckDetailVO)BeanMapper.map((Object)((Object)entity), SceneCheckDetailVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u5f85\u6574\u6539\u5355\u636e")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SceneCheckDetailVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("checkItem");
        fuzzyFields.add("checkPerson");
        fuzzyFields.add("checkName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("is_reform", new Parameter("in", Arrays.asList(CheckItemReformState.REFORM_STATE.getCode(), CheckItemReformState.REFORM_FAILED_STATE.getCode())));
        param.getParams().put("dr", new Parameter("eq", (Object)BaseVO.DR_UNDELETE));
        IPage page = this.sceneCheckDetailService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SceneCheckDetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SceneCheckDetailVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody SceneCheckDetailVO saveorUpdateVO) {
        SceneCheckDetailEntity entity = (SceneCheckDetailEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, SceneCheckDetailEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setIsReform(Integer.parseInt(CheckItemReformState.REVIEW_REFORM_STATE.getCode()));
        }
        this.sceneCheckDetailService.saveOrUpdate((Object)entity, false);
        SceneCheckDetailVO vo = (SceneCheckDetailVO)BeanMapper.map((Object)((Object)entity), SceneCheckDetailVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }
}

