package com.ejianc.business.scene.bean;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.scene.bean.SceneCheckRecordEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 检查单待检复检子表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_scene_check_detail")
public class SceneCheckDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="pid")
    private Long pid; // 检查单id
    @TableField(value = "bill_code")
    private String billCode; //检查项编号
    @TableField(value="check_name")
    private String checkName; // 检查名称(来源检查单)
    @TableField(value="project_name")
    private String projectName; // 项目名
    @TableField(value="check_type")
    private Long checkType; // 检查类型 1、综合检查；2、安全检查；3、质量检查；4、进度检查；5、其他检查；
    @TableField(value = "check_type_name")
    private String checkTypeName;//检查类型名称
    @TableField(value="check_item")
    private String checkItem; // 检查项
    @TableField(value="problem_img_ids")
    private String problemImgIds;//问题照片id
    @TableField(value="problem_img_url")
    private String problemImgUrl; // 问题照片
    @TableField(value="danger_level")
    private Long dangerLevel; // 隐患等级  0、一般；1、严重；2、紧急
    @TableField(value = "check_id")
    private String checkId;//检查人id
    @TableField(value="check_person")
    private String checkPerson; // 检查人
    @TableField(value="review_id")
    private String reviewId; // 复查人 id
    @TableField(value="review_person")
    private String reviewPerson; // 复查人
    @TableField(value="check_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date checkDate; // 检查日期
    @TableField(value = "current_rectification_id")
    private Long currentRectificationId; //当前整改人id
    @TableField(value = "current_rectification_person")
    private String currentRectificationPerson; //当前整改人
    @TableField(value="rectification_id")
    private String rectificationId; // 整改人id
    @TableField(value="rectification_person")
    private String rectificationPerson; // 整改人
    @TableField(value ="is_overdue")
    private Integer isOverdue;
    @TableField(value="finish_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date finishDate; // 要求完成日期
    @TableField(value="reform_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date reformDate; // 整改日期
    @TableField(value="reform_img_ids")
    private String reformImgIds; // 整改照片id
    @TableField(value="reform_img_url")
    private String reformImgUrl; // 整改照片
    @TableField(value = "reform_number")
    private Integer reformNumber;//整改次数
    @TableField(value="review_result")
    private Integer reviewResult; // 复查结果
    @TableField(value="review_describe")
    private String reviewDescribe; // 复查描述
    @TableField(value="review_img_ids")
    private String reviewImgIds; // 复查图片
    @TableField(value="review_img_url")
    private String reviewImgUrl; // 复查图片
    @TableField(value="reform_msg") //整改描述
    private String reformMsg;
    @TableField(value="reform_news") //整改信息
    private String 	reformNews;

    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="is_reform")
    private Integer isReform; // 检查项整改状态：1-待整改，2-已整改，3-整改不合格
    @TableField(value="review_msg")
    private String reviewMsg; // 复查信息
    @TableField(value="task_state")
    private String taskState; // 任务状态
    @TableField(value="review_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date reviewDate; // 复检时间

    
    @TableField(exist=false)
    @SubEntity(serviceName="sceneCheckRecordService")
    private List<SceneCheckRecordEntity> sceneCheckRecords = new ArrayList<>(); // 整改复查记录表

    /**
     * 检查单id
     */
    public Long getPid() {
        return pid;
    }
    /**
     * 检查单id
     */
    public void setPid(Long pid) {
        this.pid = pid;
    }
    /**
     * 检查单编号
     */
    public String getBillCode() {
        return billCode;
    }
    /**
     * 检查单编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    /**
     * 检查名称(来源检查单)
     */
    public String getCheckName() {
        return checkName;
    }

    /**
     * 检查名称(来源检查单)
     */
    public void setCheckName(String checkName) {
        this.checkName = checkName;
    }
    /**
     * 项目名
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 检查类型 1、综合检查；2、安全检查；3、质量检查；4、进度检查；5、其他检查；
     */
    public Long getCheckType() {
        return checkType;
    }

    /**
     * 检查类型 1、综合检查；2、安全检查；3、质量检查；4、进度检查；5、其他检查；
     */
    public void setCheckType(Long checkType) {
        this.checkType = checkType;
    }
    /**
     * 检查类型名称
     */
    public String getCheckTypeName() {
        return checkTypeName;
    }
    /**
     * 检查类型名称
     */
    public void setCheckTypeName(String checkTypeName) {
        this.checkTypeName = checkTypeName;
    }

    /**
     * 检查项
     */
    public String getCheckItem() {
        return checkItem;
    }

    /**
     * 检查项
     */
    public void setCheckItem(String checkItem) {
        this.checkItem = checkItem;
    }

    /**
     * 问题照片id
     */
    public String getProblemImgIds() {
        return problemImgIds;
    }
    /**
     * 问题照片id
     */
    public void setProblemImgIds(String problemImgIds) {
        this.problemImgIds = problemImgIds;
    }

    /**
     * 问题照片
     */
    public String getProblemImgUrl() {
        return problemImgUrl;
    }

    /**
     * 问题照片
     */
    public void setProblemImgUrl(String problemImgUrl) {
        this.problemImgUrl = problemImgUrl;
    }
    /**
     * 隐患等级  1、一般；2、严重；3、紧急
     */
    public Long getDangerLevel() {
        return dangerLevel;
    }

    /**
     * 隐患等级  1、一般；2、严重；3、紧急
     */
    public void setDangerLevel(Long dangerLevel) {
        this.dangerLevel = dangerLevel;
    }
    /**
     * 检查人id
     */
    public String getCheckId() {
        return checkId;
    }
    /**
     * 检查人id
     */
    public void setCheckId(String checkId) {
        this.checkId = checkId;
    }

    /**
     * 检查人
     */
    public String getCheckPerson() {
        return checkPerson;
    }

    /**
     * 检查人
     */
    public void setCheckPerson(String checkPerson) {
        this.checkPerson = checkPerson;
    }
    /**
     * 复查人 id
     */
    public String getReviewId() {
        return reviewId;
    }

    /**
     * 复查人 id
     */
    public void setReviewId(String reviewId) {
        this.reviewId = reviewId;
    }
    /**
     * 复查人
     */
    public String getReviewPerson() {
        return reviewPerson;
    }

    /**
     * 复查人
     */
    public void setReviewPerson(String reviewPerson) {
        this.reviewPerson = reviewPerson;
    }
    /**
     * 检查日期
     */
    public java.util.Date getCheckDate() {
        return checkDate;
    }

    /**
     * 检查日期
     */
    public void setCheckDate(java.util.Date checkDate) {
        this.checkDate = checkDate;
    }
    /**
     * 当前整改人id
     */
    public Long getCurrentRectificationId() {
        return currentRectificationId;
    }

    /**
     * 当前整改人id
     */
    public void setCurrentRectificationId(Long currentRectificationId) {
        this.currentRectificationId = currentRectificationId;
    }

    /**
     * 当前整改人
     */
    public String getCurrentRectificationPerson() {
        return currentRectificationPerson;
    }
    /**
     * 当前整改人
     */
    public void setCurrentRectificationPerson(String currentRectificationPerson) {
        this.currentRectificationPerson = currentRectificationPerson;
    }

    /**
     * 整改人id
     */
    public String getRectificationId() {
        return rectificationId;
    }

    /**
     * 整改人id
     */
    public void setRectificationId(String rectificationId) {
        this.rectificationId = rectificationId;
    }
    /**
     * 整改人
     */
    public String getRectificationPerson() {
        return rectificationPerson;
    }

    /**
     * 整改人
     */
    public void setRectificationPerson(String rectificationPerson) {
        this.rectificationPerson = rectificationPerson;
    }
    /**
     * 是否逾期
     */
    public Integer getIsOverdue() {
        return isOverdue;
    }
    /**
     * 是否逾期
     */
    public void setIsOverdue(Integer isOverdue) {
        this.isOverdue = isOverdue;
    }

    /**
     * 要求完成日期
     */
    public java.util.Date getFinishDate() {
        return finishDate;
    }

    /**
     * 要求完成日期
     */
    public void setFinishDate(java.util.Date finishDate) {
        this.finishDate = finishDate;
    }
    /**
     * 整改日期
     */
    public java.util.Date getReformDate() {
        return reformDate;
    }

    /**
     * 整改日期
     */
    public void setReformDate(java.util.Date reformDate) {
        this.reformDate = reformDate;
    }

    /**
     * 整改照片id
     */
    public String getReformImgIds() {
        return reformImgIds;
    }
    /**
     * 整改照片id
     */
    public void setReformImgIds(String reformImgIds) {
        this.reformImgIds = reformImgIds;
    }

    /**
     * 整改照片
     */
    public String getReformImgUrl() {
        return reformImgUrl;
    }

    /**
     * 整改照片
     */
    public void setReformImgUrl(String reformImgUrl) {
        this.reformImgUrl = reformImgUrl;
    }

    /**
     * 整改次数
     */
    public Integer getReformNumber() {
        return reformNumber;
    }
    /**
     * 整改次数
     */
    public void setReformNumber(Integer reformNumber) {
        this.reformNumber = reformNumber;
    }

    /**
     * 复查结果
     */
    public Integer getReviewResult() {
        return reviewResult;
    }

    /**
     * 复查结果
     */
    public void setReviewResult(Integer reviewResult) {
        this.reviewResult = reviewResult;
    }
    /**
     * 复查描述
     */
    public String getReviewDescribe() {
        return reviewDescribe;
    }

    /**
     * 复查描述
     */
    public void setReviewDescribe(String reviewDescribe) {
        this.reviewDescribe = reviewDescribe;
    }

    /**
     * 复查图片id
     */
    public String getReviewImgIds() {
        return reviewImgIds;
    }
    /**
     * 复查图片id
     */
    public void setReviewImgIds(String reviewImgIds) {
        this.reviewImgIds = reviewImgIds;
    }

    /**
     * 复查图片
     */
    public String getReviewImgUrl() {
        return reviewImgUrl;
    }

    /**
     * 复查图片
     */
    public void setReviewImgUrl(String reviewImgUrl) {
        this.reviewImgUrl = reviewImgUrl;
    }

    /**
     * 整改复查记录表
     */
    public List<SceneCheckRecordEntity> getSceneCheckRecords() {
        return sceneCheckRecords;
    }
    /**
     * 整改复查记录表
     */
    public void setSceneCheckRecords(List<SceneCheckRecordEntity> sceneCheckRecords) {
        this.sceneCheckRecords = sceneCheckRecords;
    }

    public String getReformMsg() {
        return reformMsg;
    }

    public void setReformMsg(String reformMsg) {
        this.reformMsg = reformMsg;
    }

    public String getReformNews() {
        return reformNews;
    }

    public void setReformNews(String reformNews) {
        this.reformNews = reformNews;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Integer getIsReform() {
        return isReform;
    }

    public void setIsReform(Integer isReform) {
        this.isReform = isReform;
    }

    public String getReviewMsg() {
        return reviewMsg;
    }

    public void setReviewMsg(String reviewMsg) {
        this.reviewMsg = reviewMsg;
    }

    public String getTaskState() {
        return taskState;
    }

    public void setTaskState(String taskState) {
        this.taskState = taskState;
    }

    public Date getReviewDate() {
        return reviewDate;
    }

    public void setReviewDate(Date reviewDate) {
        this.reviewDate = reviewDate;
    }
}
